/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Globals;
import polyglot.frontend.Goal;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.AccessControlResolver;
import polyglot.types.AccessControlWrapperResolver;
import polyglot.types.ArrayType;
import polyglot.types.ArrayType_c;
import polyglot.types.CachingResolver;
import polyglot.types.ClassContextResolver;
import polyglot.types.ClassDef;
import polyglot.types.ClassDef_c;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorDef_c;
import polyglot.types.ConstructorInstance;
import polyglot.types.ConstructorInstance_c;
import polyglot.types.Context;
import polyglot.types.Context_c;
import polyglot.types.DerefTransform;
import polyglot.types.FieldDef;
import polyglot.types.FieldDef_c;
import polyglot.types.FieldInstance;
import polyglot.types.FieldInstance_c;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.InitializerDef;
import polyglot.types.InitializerDef_c;
import polyglot.types.InitializerInstance;
import polyglot.types.InitializerInstance_c;
import polyglot.types.LazyRef;
import polyglot.types.LocalDef;
import polyglot.types.LocalDef_c;
import polyglot.types.LocalInstance;
import polyglot.types.LocalInstance_c;
import polyglot.types.Matcher;
import polyglot.types.MemberDef;
import polyglot.types.MemberInstance;
import polyglot.types.MethodDef;
import polyglot.types.MethodDef_c;
import polyglot.types.MethodInstance;
import polyglot.types.MethodInstance_c;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.NoMemberException;
import polyglot.types.NullType;
import polyglot.types.NullType_c;
import polyglot.types.ObjectType;
import polyglot.types.Package;
import polyglot.types.PackageContextResolver;
import polyglot.types.Package_c;
import polyglot.types.ParsedClassType;
import polyglot.types.ParsedClassType_c;
import polyglot.types.PrimitiveType;
import polyglot.types.PrimitiveType_c;
import polyglot.types.ProcedureDef;
import polyglot.types.ProcedureInstance;
import polyglot.types.ProcedureInstance_c;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.Ref_c;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.SystemResolver;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.types.TypeEnv;
import polyglot.types.TypeEnv_c;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.UnknownPackage;
import polyglot.types.UnknownPackage_c;
import polyglot.types.UnknownQualifier;
import polyglot.types.UnknownQualifier_c;
import polyglot.types.UnknownType;
import polyglot.types.UnknownType_c;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.Predicate2;
import polyglot.util.StringUtil;
import polyglot.util.TransformingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSystem_c
implements TypeSystem {
    protected SystemResolver systemResolver;
    protected TopLevelResolver loadedResolver;
    protected Map<String, Flags> flagsForName;
    protected ExtensionInfo extInfo;
    protected Type OBJECT_;
    protected Type CLASS_;
    protected Type STRING_;
    protected Type THROWABLE_;
    protected final NullType NULL_ = this.createNull();
    protected final PrimitiveType VOID_ = this.createPrimitive(Name.make("void"));
    protected final PrimitiveType BOOLEAN_ = this.createPrimitive(Name.make("boolean"));
    protected final PrimitiveType CHAR_ = this.createPrimitive(Name.make("char"));
    protected final PrimitiveType BYTE_ = this.createPrimitive(Name.make("byte"));
    protected final PrimitiveType SHORT_ = this.createPrimitive(Name.make("short"));
    protected final PrimitiveType INT_ = this.createPrimitive(Name.make("int"));
    protected final PrimitiveType LONG_ = this.createPrimitive(Name.make("long"));
    protected final PrimitiveType FLOAT_ = this.createPrimitive(Name.make("float"));
    protected final PrimitiveType DOUBLE_ = this.createPrimitive(Name.make("double"));
    protected ClassDef unknownClassDef = null;
    protected UnknownType unknownType = new UnknownType_c(this);
    protected UnknownPackage unknownPackage = new UnknownPackage_c(this);
    protected UnknownQualifier unknownQualifier = new UnknownQualifier_c(this);
    Map<Ref<? extends Type>, Type> arrayTypeCache = new HashMap<Ref<? extends Type>, Type>();
    protected final Flags ACCESS_FLAGS = this.legalAccessFlags();
    protected final Flags LOCAL_FLAGS = this.legalLocalFlags();
    protected final Flags FIELD_FLAGS = this.legalFieldFlags();
    protected final Flags CONSTRUCTOR_FLAGS = this.legalConstructorFlags();
    protected final Flags INITIALIZER_FLAGS = this.legalInitializerFlags();
    protected final Flags METHOD_FLAGS = this.legalMethodFlags();
    protected final Flags ABSTRACT_METHOD_FLAGS = this.legalAbstractMethodFlags();
    protected final Flags TOP_LEVEL_CLASS_FLAGS = this.legalTopLevelClassFlags();
    protected final Flags INTERFACE_FLAGS = this.legalInterfaceFlags();
    protected final Flags MEMBER_CLASS_FLAGS = this.legalMemberClassFlags();
    protected final Flags LOCAL_CLASS_FLAGS = this.legalLocalClassFlags();

    @Override
    public void initialize(TopLevelResolver loadedResolver, ExtensionInfo extInfo) throws SemanticException {
        if (Report.should_report("types", 1)) {
            Report.report(1, "Initializing " + this.getClass().getName());
        }
        this.extInfo = extInfo;
        this.loadedResolver = loadedResolver;
        this.systemResolver = new SystemResolver(loadedResolver, extInfo);
        this.initEnums();
        this.initFlags();
        this.initTypes();
    }

    protected void initEnums() {
        ClassDef.Kind o = ClassDef.TOP_LEVEL;
    }

    protected void initTypes() throws SemanticException {
    }

    @Override
    public ExtensionInfo extensionInfo() {
        return this.extInfo;
    }

    @Override
    public SystemResolver systemResolver() {
        return this.systemResolver;
    }

    public CachingResolver parsedResolver() {
        return this.systemResolver;
    }

    @Override
    public TopLevelResolver loadedResolver() {
        return this.loadedResolver;
    }

    @Override
    public ClassFileLazyClassInitializer classFileLazyClassInitializer(ClassFile clazz) {
        return new ClassFileLazyClassInitializer(clazz, this);
    }

    @Override
    public ImportTable importTable(String sourceName, Ref<? extends Package> pkg) {
        this.assert_(pkg);
        return new ImportTable(this, pkg, sourceName);
    }

    @Override
    public ImportTable importTable(Ref<? extends Package> pkg) {
        this.assert_(pkg);
        return new ImportTable(this, pkg);
    }

    @Override
    public boolean packageExists(QName name) {
        return this.systemResolver.packageExists(name);
    }

    protected void assert_(Collection<?> l) {
        for (Object o : l) {
            if (o instanceof TypeObject) {
                this.assert_((TypeObject)o);
                continue;
            }
            if (!(o instanceof Ref)) continue;
            this.assert_((Ref)o);
        }
    }

    protected void assert_(Ref<?> ref) {
    }

    protected void assert_(TypeObject o) {
        if (o != null && o.typeSystem() != this) {
            throw new InternalCompilerError("we are " + this + " but " + o + " (" + o.getClass() + ")" + " is from " + o.typeSystem());
        }
    }

    @Override
    public String wrapperTypeString(Type t) {
        this.assert_(t);
        if (t.isBoolean()) {
            return "java.lang.Boolean";
        }
        if (t.isChar()) {
            return "java.lang.Character";
        }
        if (t.isByte()) {
            return "java.lang.Byte";
        }
        if (t.isShort()) {
            return "java.lang.Short";
        }
        if (t.isInt()) {
            return "java.lang.Integer";
        }
        if (t.isLong()) {
            return "java.lang.Long";
        }
        if (t.isFloat()) {
            return "java.lang.Float";
        }
        if (t.isDouble()) {
            return "java.lang.Double";
        }
        if (t.isVoid()) {
            return "java.lang.Void";
        }
        throw new InternalCompilerError("Unrecognized primitive type " + t);
    }

    @Override
    public Context emptyContext() {
        return new Context_c(this);
    }

    public Resolver packageContextResolver(Resolver cr, Package p) {
        return this.packageContextResolver(p);
    }

    @Override
    public AccessControlResolver createPackageContextResolver(Package p) {
        this.assert_(p);
        return new PackageContextResolver(this, p);
    }

    @Override
    public Resolver packageContextResolver(Package p, ClassDef accessor, Context context) {
        if (accessor == null) {
            return p.resolver();
        }
        return new AccessControlWrapperResolver(this.createPackageContextResolver(p), context);
    }

    @Override
    public Resolver packageContextResolver(Package p) {
        this.assert_(p);
        return this.packageContextResolver(p, null, this.emptyContext());
    }

    @Override
    public Resolver classContextResolver(final Type type, Context context) {
        this.assert_(type);
        if (context == null) {
            if (type instanceof ClassType) {
                return ((ClassType)type).resolver();
            }
            return new Resolver(){

                @Override
                public Named find(Matcher<Named> matcher) throws SemanticException {
                    throw new NoClassException(matcher.name().toString(), type);
                }
            };
        }
        return new AccessControlWrapperResolver(this.createClassContextResolver(type), context);
    }

    @Override
    public Resolver classContextResolver(Type type) {
        return this.classContextResolver(type, this.emptyContext());
    }

    @Override
    public AccessControlResolver createClassContextResolver(Type type) {
        this.assert_(type);
        return new ClassContextResolver(this, type);
    }

    @Override
    public FieldDef fieldDef(Position pos, Ref<? extends StructType> container, Flags flags, Ref<? extends Type> type, Name name) {
        this.assert_(container);
        this.assert_(type);
        return new FieldDef_c(this, pos, container, flags, type, name);
    }

    @Override
    public LocalDef localDef(Position pos, Flags flags, Ref<? extends Type> type, Name name) {
        this.assert_(type);
        return new LocalDef_c(this, pos, flags, type, name);
    }

    @Override
    public ConstructorDef defaultConstructor(Position pos, Ref<? extends ClassType> container) {
        this.assert_(container);
        Flags access = Flags.NONE;
        Flags flags = container.get().flags();
        if (flags.isPrivate()) {
            access = access.Private();
        }
        if (flags.isProtected()) {
            access = access.Protected();
        }
        if (flags.isPublic()) {
            access = access.Public();
        }
        return this.constructorDef(pos, container, access, Collections.<Ref<Type>>emptyList(), Collections.<Ref<Type>>emptyList());
    }

    @Override
    public ConstructorDef constructorDef(Position pos, Ref<? extends ClassType> container, Flags flags, List<Ref<? extends Type>> argTypes, List<Ref<? extends Type>> excTypes) {
        this.assert_(container);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new ConstructorDef_c((TypeSystem)this, pos, container, flags, argTypes, excTypes);
    }

    @Override
    public InitializerDef initializerDef(Position pos, Ref<? extends ClassType> container, Flags flags) {
        this.assert_(container);
        return new InitializerDef_c(this, pos, container, flags);
    }

    @Override
    public MethodDef methodDef(Position pos, Ref<? extends StructType> container, Flags flags, Ref<? extends Type> returnType, Name name, List<Ref<? extends Type>> argTypes, List<Ref<? extends Type>> excTypes) {
        this.assert_(container);
        this.assert_(returnType);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new MethodDef_c(this, pos, container, flags, returnType, name, argTypes, excTypes);
    }

    @Override
    public ClassDef classDefOf(Type t) {
        if (t instanceof ClassType) {
            return (ClassDef)((ClassType)t).def();
        }
        return null;
    }

    @Override
    public boolean descendsFrom(ClassDef child, ClassDef ancestor) {
        if (child == ancestor) {
            return true;
        }
        ClassDef o = this.classDefOf(this.Object());
        if (ancestor == o) {
            return true;
        }
        if (child == o) {
            return false;
        }
        Type sup = Types.get(child.superType());
        if (sup != null && this.classDefOf(sup) != null && this.descendsFrom(this.classDefOf(sup), ancestor)) {
            return true;
        }
        for (Ref<? extends Type> parentType : child.interfaces()) {
            Type t = Types.get(parentType);
            if (t == null || this.classDefOf(t) == null || !this.descendsFrom(this.classDefOf(t), ancestor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCastValid(Type fromType, Type toType, Context context) {
        this.assert_(fromType);
        this.assert_(toType);
        return this.env(context).isCastValid(fromType, toType);
    }

    public TypeEnv env(Context context) {
        return new TypeEnv_c(context);
    }

    @Override
    public boolean isImplicitCastValid(Type fromType, Type toType, Context context) {
        this.assert_(fromType);
        this.assert_(toType);
        return this.env(context).isImplicitCastValid(fromType, toType);
    }

    @Override
    public boolean equals(TypeObject type1, TypeObject type2) {
        this.assert_(type1);
        this.assert_(type2);
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.equalsImpl(type2);
    }

    @Override
    public final void equals(Type type1, Type type2) {
        assert (false);
    }

    @Override
    public final void equals(Type type1, TypeObject type2) {
        assert (false);
    }

    @Override
    public final void equals(TypeObject type1, Type type2) {
        assert (false);
    }

    @Override
    public boolean typeEquals(Type type1, Type type2, Context context) {
        this.assert_(type1);
        this.assert_(type2);
        return this.env(context).typeEquals(type1, type2);
    }

    @Override
    public boolean packageEquals(Package type1, Package type2) {
        this.assert_(type1);
        this.assert_(type2);
        return this.env(this.emptyContext()).packageEquals(type1, type2);
    }

    @Override
    public boolean numericConversionValid(Type t, Object value, Context context) {
        this.assert_(t);
        return this.env(context).numericConversionValid(t, value);
    }

    @Override
    public boolean numericConversionValid(Type t, long value, Context context) {
        this.assert_(t);
        return this.env(context).numericConversionValid(t, value);
    }

    @Override
    public boolean isAccessible(MemberInstance<? extends MemberDef> mi, Context context) {
        this.assert_(mi);
        return this.env(context).isAccessible(mi);
    }

    @Override
    public boolean isAccessibleTarget(MemberInstance<? extends MemberDef> mi, Type target, Context context) {
        this.assert_(mi);
        return this.env(context).isAccessibleTarget(mi, target);
    }

    @Override
    public boolean classAccessible(ClassDef targetClass, Context context) {
        this.assert_(targetClass);
        return this.env(context).classAccessible(targetClass);
    }

    @Override
    public boolean classAccessibleFromPackage(ClassDef targetClass, Package pkg) {
        this.assert_(targetClass);
        return this.env(this.emptyContext()).classAccessibleFromPackage(targetClass, pkg);
    }

    protected boolean accessibleFromPackage(Flags flags, Package pkg1, Package pkg2) {
        return this.env(this.emptyContext()).accessibleFromPackage(flags, pkg1, pkg2);
    }

    @Override
    public boolean isEnclosed(ClassDef inner, ClassDef outer) {
        return inner.asType().isEnclosed(outer.asType());
    }

    @Override
    public boolean hasEnclosingInstance(ClassDef inner, ClassDef encl) {
        return inner.asType().hasEnclosingInstance(encl.asType());
    }

    @Override
    public void checkCycles(Type goal) throws SemanticException {
        this.checkCycles(goal, goal);
    }

    protected void checkCycles(Type curr, Type goal) throws SemanticException {
        this.assert_(curr);
        this.assert_(goal);
        if (curr == null) {
            return;
        }
        if (curr instanceof ObjectType) {
            ObjectType ot = (ObjectType)curr;
            Type superType = null;
            if (ot.superClass() != null) {
                superType = ot.superClass();
            }
            if (goal == superType) {
                throw new SemanticException("Circular inheritance involving " + goal, curr.position());
            }
            this.checkCycles(superType, goal);
            for (Type si : ot.interfaces()) {
                if (si == goal) {
                    throw new SemanticException("Circular inheritance involving " + goal, curr.position());
                }
                this.checkCycles(si, goal);
            }
        }
        if (curr.isClass()) {
            this.checkCycles(curr.toClass().outer(), goal);
        }
    }

    @Override
    public boolean canCoerceToString(Type t, Context c) {
        return this.env(c).canCoerceToString(t);
    }

    @Override
    public boolean isNumeric(Type t) {
        return t.isLongOrLess() || t.isFloat() || t.isDouble();
    }

    @Override
    public boolean isIntOrLess(Type t) {
        return t.isByte() || t.isShort() || t.isChar() || t.isInt();
    }

    @Override
    public boolean isLongOrLess(Type t) {
        return t.isByte() || t.isShort() || t.isChar() || t.isInt() || t.isLong();
    }

    @Override
    public boolean isVoid(Type t) {
        Context context = this.emptyContext();
        return this.typeEquals(t, this.Void(), context);
    }

    @Override
    public boolean isBoolean(Type t) {
        Context context = this.emptyContext();
        return this.isSubtype(t, this.Boolean(), context);
    }

    @Override
    public boolean isChar(Type t) {
        Context context = this.emptyContext();
        return this.isSubtype(t, this.Char(), context);
    }

    @Override
    public boolean isByte(Type t) {
        Context context = this.emptyContext();
        return this.isSubtype(t, this.Byte(), context);
    }

    @Override
    public boolean isShort(Type t) {
        Context context = this.emptyContext();
        return this.isSubtype(t, this.Short(), context);
    }

    @Override
    public boolean isInt(Type t) {
        Context context = this.emptyContext();
        return this.isSubtype(t, this.Int(), context);
    }

    @Override
    public boolean isLong(Type t) {
        Context context = this.emptyContext();
        return this.isSubtype(t, this.Long(), context);
    }

    @Override
    public boolean isFloat(Type t) {
        Context context = this.emptyContext();
        return this.isSubtype(t, this.Float(), context);
    }

    @Override
    public boolean isDouble(Type t) {
        Context context = this.emptyContext();
        return this.isSubtype(t, this.Double(), context);
    }

    @Override
    public boolean isThrowable(Type type) {
        this.assert_(type);
        Context context = this.emptyContext();
        return this.isSubtype(type, this.Throwable(), context);
    }

    @Override
    public boolean isUncheckedException(Type type) {
        this.assert_(type);
        Context context = this.emptyContext();
        if (type.isThrowable()) {
            for (Type t : this.uncheckedExceptions()) {
                if (!this.isSubtype(type, t, context)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<Type> uncheckedExceptions() {
        ArrayList<Type> l = new ArrayList<Type>(2);
        l.add(this.Error());
        l.add(this.RuntimeException());
        return l;
    }

    @Override
    public boolean isSubtype(Type t1, Type t2, Context context) {
        this.assert_(t1);
        this.assert_(t2);
        return this.env(context).isSubtype(t1, t2);
    }

    @Override
    public FieldInstance findField(Type container, FieldMatcher matcher) throws SemanticException {
        Context context = matcher.context();
        Set<FieldInstance> fields = this.findFields(container, matcher);
        if (fields.size() == 0) {
            throw new NoMemberException(3, "Field " + matcher.signature() + " not found in type \"" + container + "\".");
        }
        Iterator i = fields.iterator();
        FieldInstance fi = (FieldInstance)i.next();
        if (i.hasNext()) {
            FieldInstance fi2 = (FieldInstance)i.next();
            throw new SemanticException("Field " + matcher.signature() + " is ambiguous; it is defined in both " + fi.container() + " and " + fi2.container() + ".");
        }
        if (context != null && !this.isAccessible(fi, context)) {
            throw new SemanticException("Cannot access " + fi + ".");
        }
        return fi;
    }

    protected Set<FieldInstance> findFields(Type container, FieldMatcher matcher) {
        FieldInstance fi;
        Name name = matcher.name();
        Context context = matcher.context();
        this.assert_(container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access field \"" + name + "\" within a null container type.");
        }
        if (container instanceof StructType && (fi = ((StructType)container).fieldNamed(name)) != null) {
            try {
                fi = matcher.instantiate(fi);
                if (fi != null) {
                    return Collections.singleton(fi);
                }
            }
            catch (SemanticException e) {
                // empty catch block
            }
            return Collections.EMPTY_SET;
        }
        HashSet<FieldInstance> fields = new HashSet<FieldInstance>();
        if (container instanceof ObjectType) {
            ObjectType ot = (ObjectType)container;
            if (ot.superClass() != null && ot.superClass() instanceof StructType) {
                Set<FieldInstance> superFields = this.findFields((StructType)ot.superClass(), matcher);
                fields.addAll(superFields);
            }
            for (Type it : ot.interfaces()) {
                if (!(it instanceof StructType)) continue;
                Set<FieldInstance> superFields = this.findFields((StructType)it, matcher);
                fields.addAll(superFields);
            }
        }
        return fields;
    }

    @Override
    public Type findMemberType(Type container, Name name, Context context) throws SemanticException {
        return this.env(context).findMemberType(container, name);
    }

    @Override
    public boolean hasMethodNamed(Type container, Name name) {
        this.assert_(container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access method \"" + name + "\" within a null container type.");
        }
        if (container instanceof StructType && !((StructType)container).methodsNamed(name).isEmpty()) {
            return true;
        }
        if (container instanceof ObjectType) {
            ObjectType ot = (ObjectType)container;
            if (ot.superClass() != null && ot.superClass() instanceof StructType && this.hasMethodNamed((StructType)ot.superClass(), name)) {
                return true;
            }
            for (Type it : ot.interfaces()) {
                if (!(it instanceof StructType) || !this.hasMethodNamed((StructType)it, name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Matcher<Named> MemberTypeMatcher(Type container, Name name, Context context) {
        return new MemberTypeMatcher(container, name, context);
    }

    @Override
    public Matcher<Named> TypeMatcher(Name name) {
        return new TypeMatcher(name);
    }

    @Override
    public MethodMatcher MethodMatcher(Type container, Name name, List<Type> argTypes, Context context) {
        return new MethodMatcher(container, name, argTypes, context);
    }

    @Override
    public ConstructorMatcher ConstructorMatcher(Type container, List<Type> argTypes, Context context) {
        return new ConstructorMatcher(container, argTypes, context);
    }

    @Override
    public FieldMatcher FieldMatcher(Type container, Name name, Context context) {
        return new FieldMatcher(container, name, context);
    }

    @Override
    public MethodInstance findMethod(Type container, MethodMatcher matcher) throws SemanticException {
        this.assert_(container);
        Context context = matcher.context();
        List<MethodInstance> acceptable = this.findAcceptableMethods(container, matcher);
        if (acceptable.size() == 0) {
            throw new NoMemberException(1, "No valid method call found for " + matcher.signature() + " in " + container + ".");
        }
        Collection<MethodInstance> maximal = this.findMostSpecificProcedures(acceptable, matcher, context);
        if (maximal.size() > 1) {
            StringBuffer sb = new StringBuffer();
            Iterator<MethodInstance> i = maximal.iterator();
            while (i.hasNext()) {
                MethodInstance ma = i.next();
                sb.append(ma.container());
                sb.append(".");
                sb.append(ma.signature());
                if (!i.hasNext()) continue;
                if (maximal.size() == 2) {
                    sb.append(" and ");
                    continue;
                }
                sb.append(", ");
            }
            throw new SemanticException("Reference to " + matcher.name() + " is ambiguous, multiple methods match: " + sb.toString());
        }
        MethodInstance mi = maximal.iterator().next();
        return mi;
    }

    @Override
    public ConstructorInstance findConstructor(Type container, ConstructorMatcher matcher) throws SemanticException {
        this.assert_(container);
        Context context = matcher.context();
        List<ConstructorInstance> acceptable = this.findAcceptableConstructors(container, matcher);
        if (acceptable.size() == 0) {
            throw new NoMemberException(2, "No valid constructor found for " + matcher.signature() + ").");
        }
        Collection<ConstructorInstance> maximal = this.findMostSpecificProcedures(acceptable, matcher, context);
        if (maximal.size() > 1) {
            throw new NoMemberException(2, "Reference to " + container + " is ambiguous, multiple " + "constructors match: " + maximal);
        }
        ConstructorInstance ci = maximal.iterator().next();
        return ci;
    }

    @Override
    public <S extends ProcedureDef, T extends ProcedureInstance<S>> Collection<T> findMostSpecificProcedures(List<T> acceptable, Matcher<T> matcher, Context context) throws SemanticException {
        Comparator<ProcedureInstance> msc = this.mostSpecificComparator(matcher, context);
        acceptable = new ArrayList<T>(acceptable);
        Collections.sort(acceptable, msc);
        List<ProcedureInstance<Object>> maximal = new ArrayList<ProcedureInstance>(acceptable.size());
        Iterator<T> i = acceptable.iterator();
        ProcedureInstance first = (ProcedureInstance)i.next();
        maximal.add(first);
        while (i.hasNext()) {
            ProcedureInstance p = (ProcedureInstance)i.next();
            if (msc.compare(first, p) != 0) continue;
            maximal.add(p);
        }
        if (maximal.size() > 1) {
            ArrayList<ProcedureInstance> notAbstract = new ArrayList<ProcedureInstance>(maximal.size());
            for (ProcedureInstance p : maximal) {
                if (p instanceof MemberInstance && ((MemberInstance)((Object)p)).flags().isAbstract()) continue;
                notAbstract.add(p);
            }
            if (notAbstract.size() == 1) {
                maximal = notAbstract;
            } else if (notAbstract.size() == 0) {
                Iterator j = maximal.iterator();
                first = (ProcedureInstance)j.next();
                ProcedureDef firstDecl = (ProcedureDef)first.def();
                TransformingList firstFormals = new TransformingList(firstDecl.formalTypes(), new DerefTransform());
                while (j.hasNext()) {
                    ProcedureInstance p = (ProcedureInstance)j.next();
                    ProcedureDef pDecl = (ProcedureDef)p.def();
                    TransformingList pFormals = new TransformingList((List<Ref<Type>>)pDecl.formalTypes(), new DerefTransform());
                    if (CollectionUtil.allElementwise(firstFormals, pFormals, new TypeEquals(context))) continue;
                    return maximal;
                }
                maximal = Collections.singletonList(first);
            } else {
                Collections.sort(notAbstract, msc);
                maximal = Collections.singletonList(notAbstract.get(0));
            }
        }
        return maximal;
    }

    protected <S extends ProcedureDef, T extends ProcedureInstance<S>> Comparator<T> mostSpecificComparator(Matcher<T> matcher, Context context) {
        return new MostSpecificComparator(context);
    }

    @Override
    public List<MethodInstance> findAcceptableMethods(Type container, MethodMatcher matcher) throws SemanticException {
        this.assert_(container);
        Context context = matcher.context();
        NoMemberException error = null;
        ArrayList<MethodInstance> acceptable = new ArrayList<MethodInstance>();
        ArrayList<MethodInstance> unacceptable = new ArrayList<MethodInstance>();
        HashSet<StructType> visitedTypes = new HashSet<StructType>();
        LinkedList<Type> typeQueue = new LinkedList<Type>();
        typeQueue.addLast(container);
        block2: while (!typeQueue.isEmpty()) {
            Type t = (Type)typeQueue.removeFirst();
            if (t instanceof StructType) {
                StructType type = (StructType)t;
                for (Type type2 : visitedTypes) {
                    if (!this.typeEquals(type, type2, context)) continue;
                    continue block2;
                }
                if (visitedTypes.contains(type)) continue;
                visitedTypes.add(type);
                if (Report.should_report("types", 2)) {
                    Report.report(2, "Searching type " + type + " for method " + matcher.signature());
                }
                for (MethodInstance methodInstance : type.methodsNamed(matcher.name())) {
                    if (Report.should_report("types", 3)) {
                        Report.report(3, "Trying " + methodInstance);
                    }
                    try {
                        MethodInstance methodInstance2 = matcher.instantiate(methodInstance);
                        if (methodInstance2 == null) continue;
                        if (this.isAccessible(methodInstance2, context)) {
                            if (Report.should_report("types", 3)) {
                                Report.report(3, "->acceptable: " + methodInstance2 + " in " + methodInstance2.container());
                            }
                            acceptable.add(methodInstance2);
                            continue;
                        }
                        unacceptable.add(methodInstance2);
                        if (error != null) continue;
                        error = new NoMemberException(1, "Method " + methodInstance2.signature() + " in " + container + " is inaccessible.");
                    }
                    catch (SemanticException e) {
                        if (error == null) {
                            error = new NoMemberException(1, "Method " + methodInstance.signature() + " in " + container + " cannot be called with arguments " + matcher.argumentString() + "; " + e.getMessage());
                        }
                        if (error != null) continue;
                        error = new NoMemberException(1, "Method " + methodInstance.signature() + " in " + container + " cannot be called with arguments " + matcher.argumentString() + ".");
                    }
                }
            }
            if (!(t instanceof ObjectType)) continue;
            ObjectType ot = (ObjectType)t;
            if (ot.superClass() != null) {
                typeQueue.addLast(ot.superClass());
            }
            typeQueue.addAll(ot.interfaces());
        }
        if (acceptable.size() > 0) {
            for (MethodInstance mi : unacceptable) {
                acceptable.removeAll(mi.overrides(context));
            }
        }
        if (acceptable.size() == 0) {
            if (error == null) {
                error = new NoMemberException(1, "No valid method call found for " + matcher.signature() + " in " + container + ".");
            }
            throw error;
        }
        return acceptable;
    }

    @Override
    public List<ConstructorInstance> findAcceptableConstructors(Type container, ConstructorMatcher matcher) throws SemanticException {
        return this.env(matcher.context()).findAcceptableConstructors(container, matcher);
    }

    @Override
    public <T extends ProcedureDef> boolean moreSpecific(ProcedureInstance<T> p1, ProcedureInstance<T> p2, Context context) {
        return this.env(context).moreSpecific(p1, p2);
    }

    @Override
    public Type superClass(Type type) {
        this.assert_(type);
        if (type instanceof ObjectType) {
            return ((ObjectType)type).superClass();
        }
        return null;
    }

    @Override
    public List<Type> interfaces(Type type) {
        this.assert_(type);
        if (type instanceof ObjectType) {
            return ((ObjectType)type).interfaces();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Type leastCommonAncestor(Type type1, Type type2, Context context) throws SemanticException {
        this.assert_(type1);
        this.assert_(type2);
        return this.env(context).leastCommonAncestor(type1, type2);
    }

    @Override
    public boolean hasMethod(Type t, MethodInstance mi, Context context) {
        this.assert_(t);
        this.assert_(mi);
        return this.env(context).hasMethod(t, mi);
    }

    @Override
    public <T extends ProcedureDef> boolean throwsSubset(ProcedureInstance<T> p1, ProcedureInstance<T> p2) {
        this.assert_(p1);
        this.assert_(p2);
        return ((ProcedureInstance_c)p1).throwsSubset(p2);
    }

    @Override
    public boolean hasFormals(ProcedureInstance<? extends ProcedureDef> pi, List<Type> formalTypes, Context context) {
        this.assert_(pi);
        this.assert_(formalTypes);
        return this.env(context).hasFormals(pi, formalTypes);
    }

    @Override
    public List<MethodInstance> overrides(MethodInstance mi, Context context) {
        return this.env(context).overrides(mi);
    }

    @Override
    public List<MethodInstance> implemented(MethodInstance mi, Context context) {
        return this.env(context).implemented(mi);
    }

    protected List<MethodInstance> implemented(MethodInstance mi, StructType st, Context context) {
        return this.env(context).implemented(mi, st);
    }

    @Override
    public boolean canOverride(MethodInstance mi, MethodInstance mj, Context context) {
        return this.env(context).canOverride(mi, mj);
    }

    @Override
    public void checkOverride(MethodInstance mi, MethodInstance mj, Context context) throws SemanticException {
        this.env(context).checkOverride(mi, mj);
    }

    public void checkOverride(MethodInstance mi, MethodInstance mj, boolean allowCovariantReturn, Context context) throws SemanticException {
        this.env(context).checkOverride(mi, mj, allowCovariantReturn);
    }

    @Override
    public boolean isSameMethod(MethodInstance m1, MethodInstance m2, Context context) {
        this.assert_(m1);
        this.assert_(m2);
        return this.env(context).isSameMethod(m1, m2);
    }

    @Override
    public boolean callValid(ProcedureInstance<? extends ProcedureDef> prototype, Type thisType, List<Type> argTypes, Context context) {
        this.assert_(prototype);
        this.assert_(argTypes);
        return this.env(context).callValid(prototype, thisType, argTypes);
    }

    @Override
    public NullType Null() {
        return this.NULL_;
    }

    @Override
    public Type Void() {
        return this.VOID_;
    }

    @Override
    public Type Boolean() {
        return this.BOOLEAN_;
    }

    @Override
    public Type Char() {
        return this.CHAR_;
    }

    @Override
    public Type Byte() {
        return this.BYTE_;
    }

    @Override
    public Type Short() {
        return this.SHORT_;
    }

    @Override
    public Type Int() {
        return this.INT_;
    }

    @Override
    public Type Long() {
        return this.LONG_;
    }

    @Override
    public Type Float() {
        return this.FLOAT_;
    }

    @Override
    public Type Double() {
        return this.DOUBLE_;
    }

    protected ClassType load(String name) {
        try {
            return (ClassType)this.typeForName(QName.make(name));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Cannot find class \"" + name + "\"; " + e.getMessage(), e);
        }
    }

    @Override
    public Named forName(QName name) throws SemanticException {
        try {
            return this.systemResolver.find(name);
        }
        catch (SemanticException e) {
            if (name.qualifier() != null) {
                try {
                    Named container = this.forName(name.qualifier());
                    if (container instanceof ClassType) {
                        return this.classContextResolver((ClassType)container).find(this.MemberTypeMatcher((ClassType)container, name.name(), this.emptyContext()));
                    }
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public Type typeForName(QName name) throws SemanticException {
        return (Type)((Object)this.forName(name));
    }

    @Override
    public Type Object() {
        if (this.OBJECT_ != null) {
            return this.OBJECT_;
        }
        this.OBJECT_ = this.load("java.lang.Object");
        return this.OBJECT_;
    }

    @Override
    public Type Class() {
        if (this.CLASS_ != null) {
            return this.CLASS_;
        }
        this.CLASS_ = this.load("java.lang.Class");
        return this.CLASS_;
    }

    @Override
    public Type String() {
        if (this.STRING_ != null) {
            return this.STRING_;
        }
        this.STRING_ = this.load("java.lang.String");
        return this.STRING_;
    }

    @Override
    public Type Throwable() {
        if (this.THROWABLE_ != null) {
            return this.THROWABLE_;
        }
        this.THROWABLE_ = this.load("java.lang.Throwable");
        return this.THROWABLE_;
    }

    @Override
    public Type Error() {
        return this.load("java.lang.Error");
    }

    @Override
    public Type Exception() {
        return this.load("java.lang.Exception");
    }

    @Override
    public Type RuntimeException() {
        return this.load("java.lang.RuntimeException");
    }

    @Override
    public Type Cloneable() {
        return this.load("java.lang.Cloneable");
    }

    @Override
    public Type Serializable() {
        return this.load("java.io.Serializable");
    }

    @Override
    public Type NullPointerException() {
        return this.load("java.lang.NullPointerException");
    }

    @Override
    public Type ClassCastException() {
        return this.load("java.lang.ClassCastException");
    }

    @Override
    public Type OutOfBoundsException() {
        return this.load("java.lang.ArrayIndexOutOfBoundsException");
    }

    @Override
    public Type ArrayStoreException() {
        return this.load("java.lang.ArrayStoreException");
    }

    @Override
    public Type ArithmeticException() {
        return this.load("java.lang.ArithmeticException");
    }

    protected NullType createNull() {
        return new NullType_c(this);
    }

    protected PrimitiveType createPrimitive(Name name) {
        return new PrimitiveType_c((TypeSystem)this, name);
    }

    @Override
    public Object placeHolder(TypeObject o) {
        return this.placeHolder(o, Collections.EMPTY_SET);
    }

    @Override
    public Object placeHolder(TypeObject o, Set roots) {
        Ref_c ref;
        this.assert_(o);
        if (o instanceof Ref_c && (ref = (Ref_c)o).get() instanceof ClassDef) {
            ClassDef ct = (ClassDef)ref.get();
            if (ct.isLocal() || ct.isAnonymous()) {
                throw new InternalCompilerError("Cannot serialize " + o + ".");
            }
            QName name = this.getTransformedClassName(ct);
            TypeSystem_c ts = this;
            LazyRef<ClassDef> sym2 = Types.lazyRef(this.unknownClassDef(), null);
            Goal resolver = Globals.Scheduler().LookupGlobalTypeDef(sym2, name);
            resolver.update(Goal.Status.SUCCESS);
            sym2.setResolver(resolver);
            return sym2;
        }
        return o;
    }

    @Override
    public ClassDef unknownClassDef() {
        if (this.unknownClassDef == null) {
            this.unknownClassDef = new ClassDef_c((TypeSystem)this, null);
            this.unknownClassDef.name(Name.make("<unknown class>"));
            this.unknownClassDef.kind(ClassDef.TOP_LEVEL);
        }
        return this.unknownClassDef;
    }

    @Override
    public UnknownType unknownType(Position pos) {
        return this.unknownType;
    }

    @Override
    public UnknownPackage unknownPackage(Position pos) {
        return this.unknownPackage;
    }

    @Override
    public UnknownQualifier unknownQualifier(Position pos) {
        return this.unknownQualifier;
    }

    @Override
    public Package packageForName(Package prefix, Name name) throws SemanticException {
        return this.createPackage(prefix, name);
    }

    @Override
    public Package packageForName(Ref<? extends Package> prefix, Name name) throws SemanticException {
        return this.createPackage(prefix, name);
    }

    @Override
    public Package packageForName(QName name) throws SemanticException {
        if (name == null) {
            return null;
        }
        return this.packageForName(this.packageForName(name.qualifier()), name.name());
    }

    @Override
    public Package createPackage(Package prefix, Name name) {
        return this.createPackage(prefix != null ? Types.ref(prefix) : null, name);
    }

    @Override
    public Package createPackage(Ref<? extends Package> prefix, Name name) {
        this.assert_(prefix);
        return new Package_c(this, prefix, name);
    }

    @Override
    public Package createPackage(QName name) {
        if (name == null) {
            return null;
        }
        return this.createPackage(this.createPackage(name.qualifier()), name.name());
    }

    @Override
    public Type arrayOf(Type type) {
        this.assert_(type);
        return this.arrayOf(type.position(), Types.ref(type));
    }

    @Override
    public Type arrayOf(Ref<? extends Type> type) {
        this.assert_(type);
        return this.arrayOf(null, type);
    }

    @Override
    public Type arrayOf(Position pos, Ref<? extends Type> type) {
        return this.arrayType(pos, type);
    }

    @Override
    public Type arrayOf(Position pos, Type type) {
        this.assert_(type);
        return this.arrayOf(pos, Types.ref(type));
    }

    @Override
    public Type arrayOf(Type type, int dims) {
        return this.arrayOf(Types.ref(type), dims);
    }

    @Override
    public Type arrayOf(Position pos, Type type, int dims) {
        return this.arrayOf(pos, Types.ref(type), dims);
    }

    protected ArrayType arrayType(Position pos, Ref<? extends Type> type) {
        ArrayType t = (ArrayType)this.arrayTypeCache.get(type);
        if (t == null) {
            t = this.createArrayType(pos, type);
            this.arrayTypeCache.put(type, t);
        }
        return t;
    }

    protected ArrayType createArrayType(Position pos, Ref<? extends Type> type) {
        return new ArrayType_c(this, pos, type);
    }

    @Override
    public Type arrayOf(Ref<? extends Type> type, int dims) {
        return this.arrayOf(null, type, dims);
    }

    @Override
    public Type arrayOf(Position pos, Ref<? extends Type> type, int dims) {
        if (dims > 1) {
            return this.arrayOf(pos, this.arrayOf(pos, type, dims - 1));
        }
        if (dims == 1) {
            return this.arrayOf(pos, type);
        }
        throw new InternalCompilerError("Must call arrayOf(type, dims) with dims > 0");
    }

    public Type typeForClass(Class<?> clazz) throws SemanticException {
        if (clazz == Void.TYPE) {
            return this.VOID_;
        }
        if (clazz == Boolean.TYPE) {
            return this.BOOLEAN_;
        }
        if (clazz == Byte.TYPE) {
            return this.BYTE_;
        }
        if (clazz == Character.TYPE) {
            return this.CHAR_;
        }
        if (clazz == Short.TYPE) {
            return this.SHORT_;
        }
        if (clazz == Integer.TYPE) {
            return this.INT_;
        }
        if (clazz == Long.TYPE) {
            return this.LONG_;
        }
        if (clazz == Float.TYPE) {
            return this.FLOAT_;
        }
        if (clazz == Double.TYPE) {
            return this.DOUBLE_;
        }
        if (clazz.isArray()) {
            return this.arrayOf(this.typeForClass(clazz.getComponentType()));
        }
        return (Type)((Object)this.systemResolver.find(QName.make(clazz.getName())));
    }

    public Set getTypeEncoderRootSet(TypeObject t) {
        return Collections.singleton(t);
    }

    @Override
    public QName getTransformedClassName(ClassDef ct) {
        assert (ct != null);
        assert (ct.fullName() != null);
        if (!ct.isMember() && !ct.isTopLevel()) {
            assert (!ct.asType().isGloballyAccessible());
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (ct.isMember()) {
            sb.insert(0, ct.name());
            sb.insert(0, '$');
            if ((ct = ct.outer().get()).isMember() || ct.isTopLevel()) continue;
            assert (!ct.asType().isGloballyAccessible());
            return null;
        }
        assert (ct.asType().isGloballyAccessible());
        if (sb.length() > 0) {
            return QName.make(ct.fullName(), Name.make(sb.toString()));
        }
        return QName.make(ct.fullName());
    }

    @Override
    public String translatePackage(Resolver c, Package p) {
        return p.translate(c);
    }

    @Override
    public String translateArray(Resolver c, ArrayType t) {
        return t.translate(c);
    }

    @Override
    public String translateClass(Resolver c, ClassType t) {
        return t.translate(c);
    }

    @Override
    public String translatePrimitive(Resolver c, PrimitiveType t) {
        return t.translate(c);
    }

    @Override
    public Type primitiveForName(Name sname) throws SemanticException {
        String name = sname.toString();
        if (name.equals("void")) {
            return this.Void();
        }
        if (name.equals("boolean")) {
            return this.Boolean();
        }
        if (name.equals("char")) {
            return this.Char();
        }
        if (name.equals("byte")) {
            return this.Byte();
        }
        if (name.equals("short")) {
            return this.Short();
        }
        if (name.equals("int")) {
            return this.Int();
        }
        if (name.equals("long")) {
            return this.Long();
        }
        if (name.equals("float")) {
            return this.Float();
        }
        if (name.equals("double")) {
            return this.Double();
        }
        throw new SemanticException("Unrecognized primitive type \"" + name + "\".");
    }

    @Override
    public final ClassDef createClassDef() {
        return this.createClassDef(null);
    }

    @Override
    public ClassDef createClassDef(Source fromSource) {
        return new ClassDef_c((TypeSystem)this, fromSource);
    }

    @Override
    public ParsedClassType createClassType(Position pos, Ref<? extends ClassDef> def) {
        return new ParsedClassType_c(this, pos, def);
    }

    @Override
    public ConstructorInstance createConstructorInstance(Position pos, Ref<? extends ConstructorDef> def) {
        return new ConstructorInstance_c((TypeSystem)this, pos, def);
    }

    @Override
    public MethodInstance createMethodInstance(Position pos, Ref<? extends MethodDef> def) {
        return new MethodInstance_c((TypeSystem)this, pos, def);
    }

    @Override
    public FieldInstance createFieldInstance(Position pos, Ref<? extends FieldDef> def) {
        return new FieldInstance_c((TypeSystem)this, pos, def);
    }

    @Override
    public LocalInstance createLocalInstance(Position pos, Ref<? extends LocalDef> def) {
        return new LocalInstance_c((TypeSystem)this, pos, def);
    }

    @Override
    public InitializerInstance createInitializerInstance(Position pos, Ref<? extends InitializerDef> def) {
        return new InitializerInstance_c((TypeSystem)this, pos, def);
    }

    @Override
    public List<QName> defaultOnDemandImports() {
        ArrayList<QName> l = new ArrayList<QName>(1);
        l.add(QName.make("java.lang"));
        return l;
    }

    @Override
    public Type promote(Type t1, Type t2) throws SemanticException {
        if (!t1.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t1);
        }
        if (!t2.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t2);
        }
        if (t1.isDouble() || t2.isDouble()) {
            return this.Double();
        }
        if (t1.isFloat() || t2.isFloat()) {
            return this.Float();
        }
        if (t1.isLong() || t2.isLong()) {
            return this.Long();
        }
        return this.Int();
    }

    @Override
    public Type promote(Type t) throws SemanticException {
        if (!t.isNumeric()) {
            throw new SemanticException("Cannot promote non-numeric type " + t);
        }
        if (t.isIntOrLess()) {
            return this.Int();
        }
        return t;
    }

    @Override
    public Flags legalAccessFlags() {
        return this.Public().Protected().Private();
    }

    @Override
    public Flags legalLocalFlags() {
        return this.Final();
    }

    @Override
    public Flags legalFieldFlags() {
        return this.legalAccessFlags().Static().Final().Transient().Volatile();
    }

    @Override
    public Flags legalConstructorFlags() {
        return this.legalAccessFlags().Synchronized();
    }

    @Override
    public Flags legalInitializerFlags() {
        return this.Static();
    }

    @Override
    public Flags legalMethodFlags() {
        return this.legalAccessFlags().Abstract().Static().Final().Native().Synchronized().StrictFP();
    }

    @Override
    public Flags legalAbstractMethodFlags() {
        return this.legalAccessFlags().clear(this.Private()).Abstract();
    }

    @Override
    public Flags legalTopLevelClassFlags() {
        return this.legalAccessFlags().clear(this.Private()).Abstract().Final().StrictFP().Interface();
    }

    @Override
    public Flags legalInterfaceFlags() {
        return this.legalAccessFlags().Abstract().Interface().Static();
    }

    @Override
    public Flags legalMemberClassFlags() {
        return this.legalAccessFlags().Static().Abstract().Final().StrictFP().Interface();
    }

    @Override
    public Flags legalLocalClassFlags() {
        return this.Abstract().Final().StrictFP().Interface();
    }

    @Override
    public void checkMethodFlags(Flags f) throws SemanticException {
        if (!f.clear(this.METHOD_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare method with flags " + f.clear(this.METHOD_FLAGS) + ".");
        }
        if (f.isAbstract() && !f.clear(this.ABSTRACT_METHOD_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare abstract method with flags " + f.clear(this.ABSTRACT_METHOD_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkLocalFlags(Flags f) throws SemanticException {
        if (!f.clear(this.LOCAL_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare local variable with flags " + f.clear(this.LOCAL_FLAGS) + ".");
        }
    }

    @Override
    public void checkFieldFlags(Flags f) throws SemanticException {
        if (!f.clear(this.FIELD_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare field with flags " + f.clear(this.FIELD_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkConstructorFlags(Flags f) throws SemanticException {
        if (!f.clear(this.CONSTRUCTOR_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare constructor with flags " + f.clear(this.CONSTRUCTOR_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkInitializerFlags(Flags f) throws SemanticException {
        if (!f.clear(this.INITIALIZER_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare initializer with flags " + f.clear(this.INITIALIZER_FLAGS) + ".");
        }
    }

    @Override
    public void checkTopLevelClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.TOP_LEVEL_CLASS_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a top-level class with flag(s) " + f.clear(this.TOP_LEVEL_CLASS_FLAGS) + ".");
        }
        if (f.isInterface() && !f.clear(this.INTERFACE_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare interface with flags " + f.clear(this.INTERFACE_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkMemberClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.MEMBER_CLASS_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a member class with flag(s) " + f.clear(this.MEMBER_CLASS_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkLocalClassFlags(Flags f) throws SemanticException {
        if (f.isInterface()) {
            throw new SemanticException("Cannot declare a local interface.");
        }
        if (!f.clear(this.LOCAL_CLASS_FLAGS).equals(Flags.NONE)) {
            throw new SemanticException("Cannot declare a local class with flag(s) " + f.clear(this.LOCAL_CLASS_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public void checkAccessFlags(Flags f) throws SemanticException {
        int count = 0;
        if (f.isPublic()) {
            ++count;
        }
        if (f.isProtected()) {
            ++count;
        }
        if (f.isPrivate()) {
            ++count;
        }
        if (count > 1) {
            throw new SemanticException("Invalid access flags: " + f.retain(this.ACCESS_FLAGS) + ".");
        }
    }

    @Override
    public List<Type> abstractSuperInterfaces(Type t) {
        if (t instanceof ObjectType) {
            ClassType c;
            ObjectType rt = (ObjectType)t;
            LinkedList<Type> superInterfaces = new LinkedList<Type>();
            superInterfaces.add(rt);
            for (Type interf : rt.interfaces()) {
                superInterfaces.addAll(this.abstractSuperInterfaces(interf));
            }
            if (rt.superClass() instanceof ClassType && (c = (ClassType)rt.superClass()).flags().isAbstract()) {
                superInterfaces.addAll(this.abstractSuperInterfaces(c));
            }
            return superInterfaces;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void checkClassConformance(ClassType ct, Context context) throws SemanticException {
        this.env(context).checkClassConformance(ct);
    }

    @Override
    public MethodInstance findImplementingMethod(ClassType ct, MethodInstance mi, Context context) {
        return this.findImplementingMethod(ct, mi, false, context);
    }

    @Override
    public MethodInstance findImplementingMethod(ClassType ct, MethodInstance mi, boolean includeAbstract, Context context) {
        StructType curr = ct;
        while (curr != null) {
            List<MethodInstance> possible = curr.methods(mi.name(), mi.formalTypes(), context);
            for (MethodInstance mj : possible) {
                if (!includeAbstract && mj.flags().isAbstract() || (!this.isAccessible(mi, context) || !this.isAccessible(mj, context)) && !this.isAccessible(mi, context)) continue;
                return mj;
            }
            if (curr.typeEquals(mi.container(), context)) break;
            if (curr instanceof ObjectType) {
                ObjectType ot = curr;
                if (ot.superClass() instanceof StructType) {
                    curr = (StructType)ot.superClass();
                    continue;
                }
                curr = null;
                continue;
            }
            curr = null;
        }
        return null;
    }

    protected void initFlags() {
        this.flagsForName = new HashMap<String, Flags>();
        this.flagsForName.put("public", Flags.PUBLIC);
        this.flagsForName.put("private", Flags.PRIVATE);
        this.flagsForName.put("protected", Flags.PROTECTED);
        this.flagsForName.put("static", Flags.STATIC);
        this.flagsForName.put("final", Flags.FINAL);
        this.flagsForName.put("synchronized", Flags.SYNCHRONIZED);
        this.flagsForName.put("transient", Flags.TRANSIENT);
        this.flagsForName.put("native", Flags.NATIVE);
        this.flagsForName.put("interface", Flags.INTERFACE);
        this.flagsForName.put("abstract", Flags.ABSTRACT);
        this.flagsForName.put("volatile", Flags.VOLATILE);
        this.flagsForName.put("strictfp", Flags.STRICTFP);
    }

    @Override
    public Flags createNewFlag(String name, Flags after) {
        Flags f = Flags.createFlag(name, after);
        this.flagsForName.put(name, f);
        return f;
    }

    @Override
    public Flags NoFlags() {
        return Flags.NONE;
    }

    @Override
    public Flags Public() {
        return Flags.PUBLIC;
    }

    @Override
    public Flags Private() {
        return Flags.PRIVATE;
    }

    @Override
    public Flags Protected() {
        return Flags.PROTECTED;
    }

    @Override
    public Flags Static() {
        return Flags.STATIC;
    }

    @Override
    public Flags Final() {
        return Flags.FINAL;
    }

    @Override
    public Flags Synchronized() {
        return Flags.SYNCHRONIZED;
    }

    @Override
    public Flags Transient() {
        return Flags.TRANSIENT;
    }

    @Override
    public Flags Native() {
        return Flags.NATIVE;
    }

    @Override
    public Flags Interface() {
        return Flags.INTERFACE;
    }

    @Override
    public Flags Abstract() {
        return Flags.ABSTRACT;
    }

    @Override
    public Flags Volatile() {
        return Flags.VOLATILE;
    }

    @Override
    public Flags StrictFP() {
        return Flags.STRICTFP;
    }

    @Override
    public Flags flagsForBits(int bits) {
        Flags f = Flags.NONE;
        if ((bits & 1) != 0) {
            f = f.Public();
        }
        if ((bits & 2) != 0) {
            f = f.Private();
        }
        if ((bits & 4) != 0) {
            f = f.Protected();
        }
        if ((bits & 8) != 0) {
            f = f.Static();
        }
        if ((bits & 0x10) != 0) {
            f = f.Final();
        }
        if ((bits & 0x20) != 0) {
            f = f.Synchronized();
        }
        if ((bits & 0x80) != 0) {
            f = f.Transient();
        }
        if ((bits & 0x100) != 0) {
            f = f.Native();
        }
        if ((bits & 0x200) != 0) {
            f = f.Interface();
        }
        if ((bits & 0x400) != 0) {
            f = f.Abstract();
        }
        if ((bits & 0x40) != 0) {
            f = f.Volatile();
        }
        if ((bits & 0x800) != 0) {
            f = f.StrictFP();
        }
        return f;
    }

    public Flags flagsForName(String name) {
        Flags f = this.flagsForName.get(name);
        if (f == null) {
            throw new InternalCompilerError("No flag named \"" + name + "\".");
        }
        return f;
    }

    public String toString() {
        return StringUtil.getShortNameComponent(this.getClass().getName());
    }

    @Override
    public ClassType rawify(ClassDef type) {
        return type.asType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MostSpecificComparator<S extends ProcedureDef, T extends ProcedureInstance<S>>
    implements Comparator<T> {
        Context context;

        public MostSpecificComparator(Context context) {
            this.context = context;
        }

        @Override
        public int compare(T p1, T p2) {
            if (p1.moreSpecific(p2, this.context)) {
                return -1;
            }
            if (p2.moreSpecific(p1, this.context)) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Subtype
    implements Predicate2<Type> {
        Context context;

        public Subtype(Context context) {
            this.context = context;
        }

        @Override
        public boolean isTrue(Type o, Type p) {
            TypeSystem ts = this.context.typeSystem();
            return ts.isSubtype(o, p, this.context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImplicitCastValid
    implements Predicate2<Type> {
        Context context;

        public ImplicitCastValid(Context context) {
            this.context = context;
        }

        @Override
        public boolean isTrue(Type o, Type p) {
            TypeSystem ts = this.context.typeSystem();
            return ts.isImplicitCastValid(o, p, this.context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeEquals
    implements Predicate2<Type> {
        Context context;

        public TypeEquals(Context context) {
            this.context = context;
        }

        @Override
        public boolean isTrue(Type o, Type p) {
            TypeSystem ts = this.context.typeSystem();
            return ts.typeEquals(o, p, this.context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeMatcher
    implements Matcher<Named> {
        protected Name name;

        protected TypeMatcher(Name name) {
            this.name = name;
        }

        @Override
        public String signature() {
            return this.name.toString();
        }

        @Override
        public Name name() {
            return this.name;
        }

        @Override
        public Named instantiate(Named t) throws SemanticException {
            if (!t.name().equals(this.name)) {
                return null;
            }
            return t;
        }

        public String toString() {
            return this.signature();
        }

        @Override
        public Object key() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberTypeMatcher
    implements Matcher<Named> {
        protected Type container;
        protected Name name;
        protected Context context;

        protected MemberTypeMatcher(Type container, Name name, Context context) {
            this.container = container;
            this.name = name;
            this.context = context;
        }

        @Override
        public String signature() {
            return this.name.toString();
        }

        @Override
        public Name name() {
            return this.name;
        }

        @Override
        public Named instantiate(Named t) throws SemanticException {
            if (!t.name().equals(this.name)) {
                return null;
            }
            return t;
        }

        public String toString() {
            return this.signature();
        }

        @Override
        public Object key() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldMatcher
    implements Copy,
    Matcher<FieldInstance> {
        protected Type container;
        protected Name name;
        protected Context context;

        protected FieldMatcher(Type container, Name name, Context context) {
            this.container = container;
            this.name = name;
            this.context = context;
        }

        public Context context() {
            return this.context;
        }

        public FieldMatcher container(Type container) {
            FieldMatcher n = this.copy();
            n.container = container;
            return n;
        }

        @Override
        public FieldMatcher copy() {
            try {
                return (FieldMatcher)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalCompilerError(e);
            }
        }

        @Override
        public String signature() {
            return this.name.toString();
        }

        @Override
        public Name name() {
            return this.name;
        }

        @Override
        public FieldInstance instantiate(FieldInstance mi) throws SemanticException {
            if (!mi.name().equals(this.name)) {
                return null;
            }
            return mi;
        }

        public String toString() {
            return this.signature();
        }

        @Override
        public Object key() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodMatcher
    implements Copy,
    Matcher<MethodInstance> {
        protected Type container;
        protected Name name;
        protected List<Type> argTypes;
        protected Context context;

        protected MethodMatcher(Type container, Name name, List<Type> argTypes, Context context) {
            this.container = container;
            this.name = name;
            this.argTypes = argTypes;
            this.context = context;
        }

        public MethodMatcher container(Type container) {
            MethodMatcher n = this.copy();
            n.container = container;
            return n;
        }

        @Override
        public MethodMatcher copy() {
            try {
                return (MethodMatcher)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalCompilerError(e);
            }
        }

        @Override
        public String signature() {
            return this.name + this.argumentString();
        }

        @Override
        public Name name() {
            return this.name;
        }

        @Override
        public MethodInstance instantiate(MethodInstance mi) throws SemanticException {
            if (!mi.name().equals(this.name)) {
                return null;
            }
            if (mi.formalTypes().size() != this.argTypes.size()) {
                return null;
            }
            TypeSystem ts = mi.typeSystem();
            if (!ts.callValid(mi, this.container, this.argTypes, this.context)) {
                throw new SemanticException("Cannot invoke " + mi + " on " + this.signature() + ".");
            }
            return mi;
        }

        public String argumentString() {
            return "(" + CollectionUtil.listToString(this.argTypes) + ")";
        }

        public String toString() {
            return this.signature();
        }

        @Override
        public Object key() {
            return null;
        }

        public Context context() {
            return this.context;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorMatcher
    implements Matcher<ConstructorInstance> {
        protected Type container;
        protected List<Type> argTypes;
        protected Context context;

        protected ConstructorMatcher(Type receiverType, List<Type> argTypes, Context context) {
            this.container = receiverType;
            this.argTypes = argTypes;
            this.context = context;
        }

        public Context context() {
            return this.context;
        }

        @Override
        public Name name() {
            return Name.make("this");
        }

        @Override
        public String signature() {
            return this.container + this.argumentString();
        }

        @Override
        public ConstructorInstance instantiate(ConstructorInstance ci) throws SemanticException {
            TypeSystem ts = ci.typeSystem();
            if (ci.formalTypes().size() != this.argTypes.size()) {
                return null;
            }
            Context context = ts.emptyContext();
            if (!ts.callValid(ci, this.container, this.argTypes, context)) {
                throw new SemanticException("Cannot invoke " + ci + " on " + this.signature() + ".");
            }
            return ci;
        }

        public String argumentString() {
            return "(" + CollectionUtil.listToString(this.argTypes) + ")";
        }

        public String toString() {
            return this.signature();
        }

        @Override
        public Object key() {
            return null;
        }
    }
}

