/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import polyglot.frontend.Globals;
import polyglot.main.Report;
import polyglot.types.ClassDef;
import polyglot.types.ConstructorDef;
import polyglot.types.FieldDef;
import polyglot.types.Flags;
import polyglot.types.LazyRef;
import polyglot.types.MethodDef;
import polyglot.types.Name;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Exceptions;
import polyglot.types.reflect.Field;
import polyglot.types.reflect.InnerClasses;
import polyglot.types.reflect.Method;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileLazyClassInitializer {
    protected ClassFile clazz;
    protected TypeSystem ts;
    protected ClassDef ct;
    protected boolean init;
    protected boolean constructorsInitialized;
    protected boolean fieldsInitialized;
    protected boolean interfacesInitialized;
    protected boolean memberClassesInitialized;
    protected boolean methodsInitialized;
    protected boolean superclassInitialized;
    protected static Collection verbose = ClassFileLoader.verbose;

    public ClassFileLazyClassInitializer(ClassFile file, TypeSystem ts) {
        this.clazz = file;
        this.ts = ts;
    }

    public void setClass(ClassDef ct) {
        this.ct = ct;
    }

    public boolean fromClassFile() {
        return true;
    }

    public Position position() {
        return new Position(null, this.clazz.name() + ".class");
    }

    protected ClassDef createType() throws SemanticException {
        String name = this.clazz.classNameCP(this.clazz.getThisClass());
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "creating ClassType for " + name);
        }
        ClassDef ct = this.ts.createClassDef();
        this.setClass(ct);
        ct.setFromJavaClassFile();
        ct.flags(this.ts.flagsForBits(this.clazz.getModifiers()));
        ct.position(this.position());
        String packageName = StringUtil.getPackageComponent(name);
        if (!packageName.equals("")) {
            ct.setPackage(Types.ref(this.ts.packageForName(QName.make(packageName))));
        }
        String className = StringUtil.getShortNameComponent(name);
        String outerName = name;
        String innerName = null;
        int dollar = outerName.lastIndexOf(36);
        if (dollar >= 0) {
            outerName = name.substring(0, dollar);
            innerName = name.substring(dollar + 1);
            ct.outer(this.defForName(outerName));
        } else {
            outerName = name;
            innerName = null;
        }
        ClassDef.Kind kind = ClassDef.TOP_LEVEL;
        if (innerName != null) {
            StringTokenizer st = new StringTokenizer(className, "$");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (Character.isDigit(s.charAt(0))) {
                    kind = ClassDef.ANONYMOUS;
                    continue;
                }
                if (kind == ClassDef.ANONYMOUS) {
                    kind = ClassDef.LOCAL;
                    continue;
                }
                kind = ClassDef.MEMBER;
            }
        }
        if (Report.should_report(verbose, 3)) {
            Report.report(3, name + " is " + kind);
        }
        ct.kind(kind);
        if (ct.isTopLevel()) {
            ct.name(Name.make(className));
        } else if (ct.isMember() || ct.isLocal()) {
            ct.name(Name.make(innerName));
        }
        this.initSuperclass();
        this.initInterfaces();
        this.initMemberClasses();
        this.initFields();
        this.initMethods();
        this.initConstructors();
        return ct;
    }

    public ClassDef type() throws SemanticException {
        if (this.ct == null) {
            this.ct = this.createType();
        }
        return this.ct;
    }

    public Ref<? extends Type> arrayOf(Type t, int dims) {
        return this.arrayOf(Types.ref(t), dims);
    }

    public Ref<? extends Type> arrayOf(Ref<? extends Type> t, int dims) {
        if (dims == 0) {
            return t;
        }
        return Types.ref(this.ts.arrayOf(t, dims));
    }

    public List<Ref<? extends Type>> typeListForString(String str) {
        ArrayList<Ref<? extends Type>> types = new ArrayList<Ref<? extends Type>>();
        block12: for (int i = 0; i < str.length(); ++i) {
            int dims = 0;
            while (str.charAt(i) == '[') {
                ++dims;
                ++i;
            }
            switch (str.charAt(i)) {
                case 'Z': {
                    types.add(this.arrayOf(this.ts.Boolean(), dims));
                    continue block12;
                }
                case 'B': {
                    types.add(this.arrayOf(this.ts.Byte(), dims));
                    continue block12;
                }
                case 'S': {
                    types.add(this.arrayOf(this.ts.Short(), dims));
                    continue block12;
                }
                case 'C': {
                    types.add(this.arrayOf(this.ts.Char(), dims));
                    continue block12;
                }
                case 'I': {
                    types.add(this.arrayOf(this.ts.Int(), dims));
                    continue block12;
                }
                case 'J': {
                    types.add(this.arrayOf(this.ts.Long(), dims));
                    continue block12;
                }
                case 'F': {
                    types.add(this.arrayOf(this.ts.Float(), dims));
                    continue block12;
                }
                case 'D': {
                    types.add(this.arrayOf(this.ts.Double(), dims));
                    continue block12;
                }
                case 'V': {
                    types.add(this.arrayOf(this.ts.Void(), dims));
                    continue block12;
                }
                case 'L': {
                    int start = ++i;
                    while (i < str.length()) {
                        if (str.charAt(i) == ';') {
                            String s = str.substring(start, i);
                            s = s.replace('/', '.');
                            types.add(this.arrayOf(this.typeForName(s), dims));
                            continue block12;
                        }
                        ++i;
                    }
                    continue block12;
                }
            }
        }
        if (Report.should_report(verbose, 4)) {
            Report.report(4, "parsed \"" + str + "\" -> " + types);
        }
        return types;
    }

    public Ref<? extends Type> typeForString(String str) {
        List<Ref<? extends Type>> l = this.typeListForString(str);
        if (l.size() == 1) {
            return l.get(0);
        }
        throw new InternalCompilerError("Bad type string: \"" + str + "\"");
    }

    public Ref<ClassDef> defForName(String name) {
        return this.defForName(name, null);
    }

    public Ref<ClassDef> defForName(String name, Flags flags) {
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "resolving " + name);
        }
        LazyRef<ClassDef> sym2 = Types.lazyRef(this.ts.unknownClassDef(), null);
        if (flags == null) {
            sym2.setResolver(Globals.Scheduler().LookupGlobalTypeDef(sym2, QName.make(name)));
        } else {
            sym2.setResolver(Globals.Scheduler().LookupGlobalTypeDefAndSetFlags(sym2, QName.make(name), flags));
        }
        return sym2;
    }

    public Ref<? extends Type> typeForName(String name) {
        return this.typeForName(name, null);
    }

    public Ref<? extends Type> typeForName(String name, Flags flags) {
        return Types.ref(this.ts.createClassType(this.position(), this.defForName(name, flags)));
    }

    public void initTypeObject() {
        this.init = true;
    }

    public boolean isTypeObjectInitialized() {
        return this.init;
    }

    public void initSuperclass() {
        if (this.superclassInitialized) {
            return;
        }
        if (this.clazz.name().equals("java/lang/Object")) {
            this.ct.superType(null);
        } else {
            String superName = this.clazz.classNameCP(this.clazz.getSuperClass());
            if (superName != null) {
                this.ct.superType(this.typeForName(superName));
            } else {
                this.ct.superType(this.typeForName("java.lang.Object"));
            }
        }
        this.superclassInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void initInterfaces() {
        if (this.interfacesInitialized) {
            return;
        }
        int[] interfaces = this.clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String name = this.clazz.classNameCP(interfaces[i]);
            this.ct.addInterface(this.typeForName(name));
        }
        this.interfacesInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void initMemberClasses() {
        if (this.memberClassesInitialized) {
            return;
        }
        InnerClasses innerClasses = this.clazz.getInnerClasses();
        if (innerClasses != null) {
            for (int i = 0; i < innerClasses.getClasses().length; ++i) {
                InnerClasses.Info c = innerClasses.getClasses()[i];
                if (c.outerClassIndex == this.clazz.getThisClass() && c.classIndex != 0) {
                    String name = this.clazz.classNameCP(c.classIndex);
                    int index = name.lastIndexOf(36);
                    if (index >= 0 && Character.isDigit(name.charAt(index + 1))) continue;
                    Ref<? extends Type> t = this.typeForName(name, this.ts.flagsForBits(c.modifiers));
                    if (Report.should_report(verbose, 3)) {
                        Report.report(3, "adding member " + t + " to " + this.ct);
                    }
                    this.ct.addMemberClass(t);
                }
                if (c.classIndex != this.clazz.getThisClass()) continue;
                this.ct.flags(this.ts.flagsForBits(c.modifiers));
            }
        }
        this.memberClassesInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void canonicalFields() {
        this.initFields();
    }

    public void canonicalMethods() {
        this.initMethods();
    }

    public void canonicalConstructors() {
        this.initConstructors();
    }

    public void initFields() {
        if (this.fieldsInitialized) {
            return;
        }
        Field[] fields = this.clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].name().startsWith("jlc$") || fields[i].isSynthetic()) continue;
            FieldDef fi = this.fieldInstance(fields[i], this.ct);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + fi + " to " + this.ct);
            }
            this.ct.addField(fi);
        }
        this.fieldsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void initMethods() {
        if (this.methodsInitialized) {
            return;
        }
        Method[] methods = this.clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].name().equals("<init>") || methods[i].name().equals("<clinit>") || methods[i].isSynthetic()) continue;
            MethodDef mi = this.methodInstance(methods[i], this.ct);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + mi + " to " + this.ct);
            }
            this.ct.addMethod(mi);
        }
        this.methodsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void initConstructors() {
        if (this.constructorsInitialized) {
            return;
        }
        Method[] methods = this.clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].name().equals("<init>") || methods[i].isSynthetic()) continue;
            ConstructorDef ci = this.constructorInstance(methods[i], this.ct, this.clazz.getFields());
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + ci + " to " + this.ct);
            }
            this.ct.addConstructor(ci);
        }
        this.constructorsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    protected boolean initialized() {
        return this.superclassInitialized && this.interfacesInitialized && this.memberClassesInitialized && this.methodsInitialized && this.fieldsInitialized && this.constructorsInitialized;
    }

    protected MethodDef methodInstance(Method method, ClassDef ct) {
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[method.getName()].value();
        String type = (String)constants[method.getType()].value();
        if (type.charAt(0) != '(') {
            throw new ClassFormatError("Bad method type descriptor.");
        }
        int index = type.indexOf(41, 1);
        List<Ref<? extends Type>> argTypes = this.typeListForString(type.substring(1, index));
        Ref<? extends Type> returnType = this.typeForString(type.substring(index + 1));
        ArrayList<Ref<? extends Type>> excTypes = new ArrayList<Ref<? extends Type>>();
        Exceptions exceptions = method.getExceptions();
        if (exceptions != null) {
            int[] throwTypes = exceptions.getThrowTypes();
            for (int i = 0; i < throwTypes.length; ++i) {
                String s = this.clazz.classNameCP(throwTypes[i]);
                excTypes.add(this.typeForName(s));
            }
        }
        return this.ts.methodDef(ct.position(), Types.ref(ct.asType()), this.ts.flagsForBits(method.getModifiers()), returnType, Name.make(name), argTypes, excTypes);
    }

    protected ConstructorDef constructorInstance(Method method, ClassDef ct, Field[] fields) {
        MethodDef mi = this.methodInstance(method, ct);
        List<Ref<? extends Type>> formals = mi.formalTypes();
        if (ct.isInnerClass()) {
            int numSynthetic = 0;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].isSynthetic()) continue;
                ++numSynthetic;
            }
            if (numSynthetic <= formals.size()) {
                formals = formals.subList(numSynthetic, formals.size());
            }
        }
        return this.ts.constructorDef(mi.position(), Types.ref(ct.asType()), mi.flags(), formals, mi.throwTypes());
    }

    protected FieldDef fieldInstance(Field field, ClassDef ct) {
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[field.getName()].value();
        String type = (String)constants[field.getType()].value();
        FieldDef fi = this.ts.fieldDef(ct.position(), Types.ref(ct.asType()), this.ts.flagsForBits(field.getModifiers()), this.typeForString(type), Name.make(name));
        if (field.isConstant()) {
            Constant c = field.constantValue();
            Object o = null;
            try {
                switch (c.tag()) {
                    case 8: {
                        o = field.getString();
                        break;
                    }
                    case 3: {
                        o = field.getInt();
                        break;
                    }
                    case 5: {
                        o = field.getLong();
                        break;
                    }
                    case 4: {
                        o = Float.valueOf(field.getFloat());
                        break;
                    }
                    case 6: {
                        o = field.getDouble();
                    }
                }
            }
            catch (SemanticException e) {
                throw new ClassFormatError("Unexpected constant pool entry.");
            }
            fi.setConstantValue(o);
            return fi;
        }
        fi.setNotConstant();
        return fi;
    }
}

