/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import polyglot.util.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilteringIterator<T>
implements Iterator<T> {
    protected T next_item;
    protected Iterator<? extends T> backing_iterator;
    protected Predicate<? super T> predicate;

    public FilteringIterator(Collection<? extends T> iterator, Predicate<? super T> keyNotInMyMap) {
        this(iterator.iterator(), keyNotInMyMap);
    }

    public FilteringIterator(Iterator<? extends T> iter, Predicate<? super T> pred) {
        this.backing_iterator = iter;
        this.predicate = pred;
        this.findNextItem();
    }

    @Override
    public T next() {
        T res = this.next_item;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.findNextItem();
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.next_item != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("FilteringIterator.remove");
    }

    private void findNextItem() {
        while (this.backing_iterator.hasNext()) {
            T o = this.backing_iterator.next();
            if (!this.predicate.isTrue(o)) continue;
            this.next_item = o;
            return;
        }
        this.next_item = null;
    }
}

