/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.util.FilteringIterator;
import polyglot.util.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringList<T>
extends AbstractList<T> {
    protected final Predicate<T> predicate;
    protected final List<T> underlying;
    protected int[] map;
    protected int size;

    public FilteringList(Collection<T> underlying, Predicate<T> predicate) {
        this((List<T>)new ArrayList<T>(underlying), predicate);
    }

    public FilteringList(List<T> underlying, Predicate<T> predicate) {
        this.underlying = underlying;
        this.predicate = predicate;
        this.map = null;
    }

    @Override
    public int size() {
        this.init();
        return this.size;
    }

    protected void init() {
        if (this.map != null) {
            return;
        }
        this.map = new int[this.underlying.size()];
        this.size = 0;
        for (int i = 0; i < this.underlying.size(); ++i) {
            T x = this.underlying.get(i);
            if (!this.predicate.isTrue(x)) continue;
            this.map[this.size++] = i;
        }
    }

    @Override
    public T get(int index) {
        this.init();
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.underlying.get(this.map[index]);
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteringIterator<T>(this.underlying, this.predicate);
    }
}

