/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import polyglot.util.CodeWriter;

public class SimpleCodeWriter
extends CodeWriter {
    protected PrintWriter output;
    protected int width;
    protected int rmargin;
    protected int lmargin;
    protected boolean breakAll;
    protected Stack lmargins;
    protected int pos;

    public SimpleCodeWriter(OutputStream o, int width_) {
        this(new PrintWriter(new OutputStreamWriter(o)), width_);
    }

    public SimpleCodeWriter(PrintWriter o, int width_) {
        this.output = o;
        this.rmargin = this.width = width_;
        this.adjustRmargin();
        this.breakAll = false;
        this.pos = 0;
        this.lmargins = new Stack();
    }

    public SimpleCodeWriter(Writer o, int width_) {
        this(new PrintWriter(o), width_);
    }

    private void adjustRmargin() {
        this.rmargin -= 8;
        if (this.rmargin < this.width / 2) {
            this.rmargin = this.width / 2;
        }
    }

    public void write(String s) {
        if (s == null) {
            this.write("null", 4);
        } else if (s.length() > 0) {
            this.write(s, s.length());
        }
    }

    public void write(String s, int length) {
        this.output.print(s);
        this.pos += length;
    }

    public void begin(int n) {
        this.lmargins.push(new State(this.lmargin, this.breakAll));
        this.lmargin = this.pos + n;
    }

    public void end() {
        State s = (State)this.lmargins.pop();
        this.lmargin = s.lmargin;
        this.breakAll = s.breakAll;
    }

    public void allowBreak(int n, int level, String alt, int altlen) {
        if (this.pos > this.width) {
            this.adjustRmargin();
        }
        if (this.breakAll || this.pos > this.rmargin) {
            this.newline(n, 1);
            this.breakAll = true;
        } else {
            this.output.print(alt);
            this.pos += altlen;
        }
    }

    public void unifiedBreak(int n, int level, String alt, int altlen) {
        this.allowBreak(n, level, alt, altlen);
    }

    private void spaces(int n) {
        for (int i = 0; i < n; ++i) {
            this.output.print(' ');
        }
    }

    public void newline() {
        if (this.pos != this.lmargin) {
            this.output.println();
            this.pos = this.lmargin;
            this.spaces(this.lmargin);
        }
    }

    public void newline(int n, int level) {
        this.newline();
        this.spaces(n);
        this.pos += n;
    }

    public boolean flush() throws IOException {
        this.output.flush();
        this.pos = 0;
        return true;
    }

    public boolean flush(boolean format) throws IOException {
        return this.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    public String toString() {
        return "<SimpleCodeWriter>";
    }

    protected class State {
        public int lmargin;
        public boolean breakAll;

        State(int m, boolean b) {
            this.lmargin = m;
            this.breakAll = b;
        }
    }
}

