/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

public class StringUtil {
    public static String getPackageComponent(String fullName) {
        int lastDot = fullName.lastIndexOf(46);
        return lastDot >= 0 ? fullName.substring(0, lastDot) : "";
    }

    public static String getShortNameComponent(String fullName) {
        int lastDot = fullName.lastIndexOf(46);
        return lastDot >= 0 ? fullName.substring(lastDot + 1) : fullName;
    }

    public static boolean isNameShort(String name) {
        return name.indexOf(46) < 0;
    }

    public static String getFirstComponent(String fullName) {
        int firstDot = fullName.indexOf(46);
        return firstDot >= 0 ? fullName.substring(0, firstDot) : fullName;
    }

    public static String removeFirstComponent(String fullName) {
        int firstDot = fullName.indexOf(46);
        return firstDot >= 0 ? fullName.substring(firstDot + 1) : "";
    }

    public static String escape(String s) {
        return StringUtil.escape(s, false);
    }

    public static String escape(char c) {
        String t = StringUtil.escape(c, false);
        if (t != null) {
            return t;
        }
        return String.valueOf(c);
    }

    public static String unicodeEscape(String s) {
        return StringUtil.escape(s, true);
    }

    public static String unicodeEscape(char c) {
        String t = StringUtil.escape(c, true);
        if (t != null) {
            return t;
        }
        return String.valueOf(c);
    }

    public static String escape(String s, boolean unicode) {
        StringBuffer sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String t = StringUtil.escape(c, unicode);
            if (sb == null && t != null) {
                sb = new StringBuffer(s.length() + 10);
                sb.append(s.substring(0, i));
            }
            if (sb == null) continue;
            if (t != null) {
                sb.append(t);
                continue;
            }
            sb.append(c);
        }
        if (sb != null) {
            return sb.toString();
        }
        return s;
    }

    private static String escape(char c, boolean unicode) {
        if (c > '\u00ff') {
            if (unicode) {
                StringBuffer sb = new StringBuffer(8);
                sb.append(Integer.toHexString(c));
                while (sb.length() < 4) {
                    sb.insert(0, '0');
                }
                sb.insert(0, "\\u");
                return sb.toString();
            }
            return null;
        }
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c >= ' ' && c < '\u007f') {
            return null;
        }
        return "\\" + (char)(48 + c / 64) + (char)(48 + (c & 0x3F) / 8) + (char)(48 + (c & 7));
    }

    public static String nth(int n) {
        StringBuffer s = new StringBuffer(String.valueOf(n));
        if (s.length() > 1 && s.charAt(s.length() - 2) == '1') {
            s.append("th");
            return s.toString();
        }
        char last = s.charAt(s.length() - 1);
        switch (last) {
            case '1': {
                s.append("st");
                break;
            }
            case '2': {
                s.append("nd");
                break;
            }
            case '3': {
                s.append("rd");
                break;
            }
            default: {
                s.append("th");
            }
        }
        return s.toString();
    }
}

