/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import polyglot.util.Transformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformingIterator<S, T>
implements Iterator<T> {
    protected T next_item;
    protected Iterator<S> current_iter;
    protected int index = 0;
    protected Iterator[] backing_iterators;
    protected Transformation<S, T> transformation;

    public TransformingIterator(Iterator<S> iter, Transformation<S, T> trans) {
        this(new Iterator[]{iter}, trans);
    }

    public TransformingIterator(Collection<S> iters, Transformation<S, T> trans) {
        this.backing_iterators = iters.toArray(new Iterator[0]);
        this.transformation = trans;
        if (this.backing_iterators.length > 0) {
            this.current_iter = this.backing_iterators[0];
        }
        this.findNextItem();
    }

    public TransformingIterator(Iterator[] iters, Transformation<S, T> trans) {
        this.backing_iterators = (Iterator[])iters.clone();
        this.transformation = trans;
        if (iters.length > 0) {
            this.current_iter = iters[0];
        }
        this.findNextItem();
    }

    @Override
    public T next() {
        T res = this.next_item;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.findNextItem();
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.next_item != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("TransformingIterator.remove");
    }

    private void findNextItem() {
        while (this.current_iter != null) {
            while (this.current_iter.hasNext()) {
                S o = this.current_iter.next();
                T res = this.transformation.transform(o);
                if (res == null) continue;
                this.next_item = res;
                return;
            }
            ++this.index;
            if (this.index < this.backing_iterators.length) {
                this.current_iter = this.backing_iterators[this.index];
                continue;
            }
            this.current_iter = null;
        }
        this.next_item = null;
    }
}

