/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import polyglot.ast.Block;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.types.LocalDef;
import polyglot.types.Name;
import polyglot.util.InternalCompilerError;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaRenamer
extends NodeVisitor {
    protected Stack<Set<Name>> setStack = new Stack();
    protected Map<Name, Name> renamingMap;
    protected Map<LocalDef, Name> oldNamesMap;
    protected Set<Name> freshVars;

    public AlphaRenamer() {
        this.setStack.push(new HashSet());
        this.oldNamesMap = new HashMap<LocalDef, Name>();
        this.renamingMap = new HashMap<Name, Name>();
        this.freshVars = new HashSet<Name>();
    }

    public Map<LocalDef, Name> getMap() {
        return this.oldNamesMap;
    }

    @Override
    public NodeVisitor enter(Node n) {
        LocalDecl l;
        Name name;
        if (n instanceof Block) {
            this.setStack.push(new HashSet());
        }
        if (n instanceof LocalDecl && !this.freshVars.contains(name = (l = (LocalDecl)n).name().id())) {
            Name name_ = Name.makeFresh(name);
            this.freshVars.add(name_);
            this.setStack.peek().add(name);
            this.renamingMap.put(name, name_);
        }
        return this;
    }

    @Override
    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof Block) {
            Set<Name> s = this.setStack.pop();
            this.renamingMap.keySet().removeAll(s);
            return n;
        }
        if (n instanceof Local) {
            Local l = (Local)n;
            Name name = l.name().id();
            if (!this.renamingMap.containsKey(name)) {
                return n;
            }
            Name newName = this.renamingMap.get(name);
            return l.name(l.name().id(newName));
        }
        if (n instanceof LocalDecl) {
            LocalDecl l = (LocalDecl)n;
            Name name = l.name().id();
            if (this.freshVars.contains(name)) {
                return n;
            }
            if (!this.renamingMap.containsKey(name)) {
                throw new InternalCompilerError("Unexpected error encountered while alpha-renaming.");
            }
            Name newName = this.renamingMap.get(name);
            LocalDef li = l.localDef();
            if (li != null) {
                this.oldNamesMap.put(li, li.name());
                li.setName(newName);
            }
            return l.name(l.name().id(newName));
        }
        return n;
    }
}

