/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashSet;
import java.util.Set;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Initializer;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.FieldDef;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.TypeSystem;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class FwdReferenceChecker
extends ContextVisitor {
    private boolean inInitialization = false;
    private boolean inStaticInit = false;
    private Set<FieldDef> declaredFields = new HashSet<FieldDef>();

    public FwdReferenceChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (n instanceof FieldDecl) {
            FieldDecl fd = (FieldDecl)n;
            FwdReferenceChecker frc = (FwdReferenceChecker)this.copy();
            frc.inInitialization = true;
            frc.inStaticInit = fd.flags().flags().isStatic();
            frc.declaredFields = new HashSet<FieldDef>(this.declaredFields);
            this.declaredFields.add(fd.fieldDef());
            return frc;
        }
        if (n instanceof Initializer) {
            FwdReferenceChecker frc = (FwdReferenceChecker)this.copy();
            frc.inInitialization = true;
            frc.inStaticInit = ((Initializer)n).flags().flags().isStatic();
            return frc;
        }
        if (n instanceof FieldAssign) {
            FwdReferenceChecker frc = (FwdReferenceChecker)this.copy();
            return frc;
        }
        if (n instanceof Field && this.inInitialization) {
            Field f = (Field)n;
            ClassType currentClass = this.context().currentClass();
            StructType fContainer = f.fieldInstance().container();
            if (this.inStaticInit == f.fieldInstance().flags().isStatic() && currentClass.typeEquals(fContainer, this.context) && !this.declaredFields.contains(f.fieldInstance().def()) && f.isTargetImplicit()) {
                throw new SemanticException("Illegal forward reference", f.position());
            }
        }
        return this;
    }
}

