/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.io.InputStreamReader;
import java.util.Iterator;
import polyglot.frontend.AllBarrierGoal;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Goal;
import polyglot.frontend.Job;
import polyglot.frontend.SourceGoal_c;
import polyglot.main.Options;
import polyglot.main.Report;
import polyglot.util.ErrorQueue;
import polyglot.util.QuotedStringTokenizer;

public class PostCompiled
extends AllBarrierGoal {
    ExtensionInfo ext;
    public static final String postcompile = "postcompile";

    public PostCompiled(ExtensionInfo ext) {
        super("PostCompile", ext.scheduler());
        this.ext = ext;
    }

    public Goal prereqForJob(Job job) {
        if (this.scheduler.shouldCompile(job)) {
            return this.scheduler.End(job);
        }
        return new SourceGoal_c("DummyEnd", job){

            public boolean runTask() {
                return true;
            }
        }.intern(this.scheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runTask() {
        Compiler compiler = this.ext.compiler();
        if (Report.should_report(postcompile, 2)) {
            Report.report(2, "Output files: " + compiler.outputFiles());
        }
        long start_time = System.currentTimeMillis();
        try {
            boolean bl = this.invokePostCompiler(this.ext.getOptions(), compiler, compiler.errorQueue());
            return bl;
        }
        finally {
            if (Report.should_report("time", 1)) {
                Report.report(1, "Finished compiling Java output files. time=" + (System.currentTimeMillis() - start_time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokePostCompiler(Options options, Compiler compiler, ErrorQueue eq) {
        if (options.post_compiler != null && !options.output_stdout) {
            Runtime runtime = Runtime.getRuntime();
            QuotedStringTokenizer st = new QuotedStringTokenizer(options.post_compiler);
            int pc_size = st.countTokens();
            String[] javacCmd = new String[pc_size + 2 + compiler.outputFiles().size()];
            int j = 0;
            for (int i = 0; i < pc_size; ++i) {
                javacCmd[j++] = st.nextToken();
            }
            javacCmd[j++] = "-classpath";
            javacCmd[j++] = options.constructPostCompilerClasspath();
            Iterator iter = compiler.outputFiles().iterator();
            while (iter.hasNext()) {
                javacCmd[j] = (String)iter.next();
                ++j;
            }
            if (Report.should_report(postcompile, 1)) {
                StringBuffer cmdStr = new StringBuffer();
                for (int i = 0; i < javacCmd.length; ++i) {
                    cmdStr.append(javacCmd[i] + " ");
                }
                Report.report(1, "Executing post-compiler " + cmdStr);
            }
            try {
                Process proc = runtime.exec(javacCmd);
                InputStreamReader err = new InputStreamReader(proc.getErrorStream());
                try {
                    int len;
                    char[] c = new char[72];
                    StringBuffer sb = new StringBuffer();
                    while ((len = err.read(c)) > 0) {
                        sb.append(String.valueOf(c, 0, len));
                    }
                    if (sb.length() != 0) {
                        eq.enqueue(6, sb.toString());
                    }
                }
                finally {
                    err.close();
                }
                proc.waitFor();
                if (!options.keep_output_files) {
                    String[] rmCmd = new String[1 + compiler.outputFiles().size()];
                    rmCmd[0] = "rm";
                    iter = compiler.outputFiles().iterator();
                    int i = 1;
                    while (iter.hasNext()) {
                        rmCmd[i] = (String)iter.next();
                        ++i;
                    }
                    runtime.exec(rmCmd);
                }
                if (proc.exitValue() > 0) {
                    eq.enqueue(6, "Non-zero return code: " + proc.exitValue());
                    return false;
                }
            }
            catch (Exception e) {
                eq.enqueue(6, e.getMessage());
                return false;
            }
        }
        return true;
    }
}

