/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.LinkedList;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.ClassDef;
import polyglot.types.CodeDef;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.ErrorRef_c;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class TypeBuilder
extends NodeVisitor {
    protected ImportTable importTable;
    protected Job job;
    protected TypeSystem ts;
    protected NodeFactory nf;
    protected TypeBuilder outer;
    protected boolean inCode;
    protected boolean global;
    protected Package package_;
    protected ClassDef type;
    protected Def def;
    private static int dupId = 0;

    public TypeBuilder(Job job, TypeSystem ts, NodeFactory nf) {
        this.job = job;
        this.ts = ts;
        this.nf = nf;
        this.outer = null;
    }

    public TypeBuilder push() {
        TypeBuilder tb = (TypeBuilder)this.copy();
        tb.outer = this;
        return tb;
    }

    public boolean inCode() {
        return this.inCode;
    }

    public TypeBuilder pop() {
        return this.outer;
    }

    public Def def() {
        return this.def;
    }

    public Job job() {
        return this.job;
    }

    public ErrorQueue errorQueue() {
        return this.job().compiler().errorQueue();
    }

    public NodeFactory nodeFactory() {
        return this.nf;
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    public NodeVisitor begin() {
        return this;
    }

    public Node override(Node n) {
        try {
            return n.del().buildTypesOverride(this);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            if (e.getMessage() != null) {
                this.errorQueue().enqueue(5, e.getMessage(), position);
            }
            return n;
        }
    }

    public NodeVisitor enter(Node n) {
        try {
            return n.del().buildTypesEnter(this);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            if (e.getMessage() != null) {
                this.errorQueue().enqueue(5, e.getMessage(), position);
            }
            return this;
        }
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        try {
            return n.del().buildTypes((TypeBuilder)v);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            if (e.getMessage() != null) {
                this.errorQueue().enqueue(5, e.getMessage(), position);
            }
            return n;
        }
    }

    public TypeBuilder pushContext(Context c2) {
        LinkedList<Context> stack = new LinkedList<Context>();
        while (c2 != null) {
            stack.addFirst(c2);
            c2 = c2.pop();
        }
        TypeBuilder tb = this;
        boolean inCode = false;
        for (Context c2 : stack) {
            if (c2.inCode()) {
                if (inCode) continue;
                inCode = true;
                tb = tb.pushCode(c2.currentCode());
                continue;
            }
            if (c2.importTable() != null && tb.importTable() == null) {
                tb.setImportTable(c2.importTable());
            }
            if (c2.importTable() != null && c2.package_() != null && tb.currentPackage() == null) {
                tb = tb.pushPackage(c2.package_());
            }
            if (c2.currentClassDef() == tb.currentClass()) continue;
            tb = tb.pushClass(c2.currentClassDef());
        }
        return tb;
    }

    public TypeBuilder pushDef(Def def) {
        TypeBuilder tb = this.push();
        tb.def = def;
        return tb;
    }

    public TypeBuilder pushPackage(Package p) {
        if (Report.should_report("visit", 4)) {
            Report.report(4, "TB pushing package " + p + ": " + this.context());
        }
        TypeBuilder tb = this.push();
        tb.inCode = false;
        tb.package_ = p;
        return tb;
    }

    public TypeBuilder pushCode(CodeDef def) {
        if (Report.should_report("visit", 4)) {
            Report.report(4, "TB pushing code: " + this.context());
        }
        TypeBuilder tb = this.pushDef(def);
        tb.inCode = true;
        tb.global = false;
        return tb;
    }

    public TypeBuilder pushClass(ClassDef classDef) {
        if (Report.should_report("visit", 4)) {
            Report.report(4, "TB pushing class " + classDef + ": " + this.context());
        }
        TypeBuilder tb = this.pushDef(classDef);
        tb.inCode = false;
        tb.type = classDef;
        if (this.importTable() != null && classDef.isTopLevel()) {
            tb.importTable().addExplicitImport(QName.make(classDef.fullName()));
        }
        return tb;
    }

    protected ClassDef newClass(Position pos, Flags flags, Name name) {
        QName fullName;
        TypeSystem ts = this.typeSystem();
        ClassDef ct = ts.createClassDef(this.job().source());
        ct.position(pos);
        ct.flags(flags);
        ct.name(name);
        ct.superType(new ErrorRef_c(ts, pos, "Cannot get superclass before type-checking class declaration."));
        if (this.inCode) {
            ct.kind(ClassDef.LOCAL);
            ct.outer(Types.ref(this.currentClass()));
            ct.setJob(this.job());
            if (this.currentPackage() != null) {
                ct.setPackage(Types.ref(this.currentPackage()));
            }
            return ct;
        }
        if (this.currentClass() != null) {
            ClassDef container;
            boolean allMembers;
            ct.kind(ClassDef.MEMBER);
            ct.outer(Types.ref(this.currentClass()));
            ct.setJob(this.job());
            this.currentClass().addMemberClass(Types.ref(ct.asType()));
            if (this.currentPackage() != null) {
                ct.setPackage(Types.ref(this.currentPackage()));
            }
            boolean bl = allMembers = (container = this.currentClass()).isMember() || container.isTopLevel();
            while (container.isMember()) {
                container = container.outer().get();
                allMembers = allMembers && (container.isMember() || container.isTopLevel());
            }
            if (allMembers) {
                try {
                    this.typeSystem().systemResolver().addNamed(QName.make(this.currentClass().fullName(), ct.name()), ct.asType());
                    QName classFileName = this.typeSystem().getTransformedClassName(ct);
                    this.typeSystem().systemResolver().install(classFileName, ct.asType());
                }
                catch (SemanticException e) {
                    this.job.compiler().errorQueue().enqueue(5, e.getMessage(), e.position());
                }
            }
            return ct;
        }
        ct.kind(ClassDef.TOP_LEVEL);
        ct.setJob(this.job());
        if (this.currentPackage() != null) {
            ct.setPackage(Types.ref(this.currentPackage()));
            fullName = QName.make(this.currentPackage().fullName(), ct.name());
        } else {
            fullName = QName.make(null, ct.name());
        }
        Named dup = this.typeSystem().systemResolver().check(fullName);
        if (dup != null && dup.fullName().equals(fullName)) {
            this.job.compiler().errorQueue().enqueue(5, "Duplicate class \"" + ct.fullName() + "\".", pos);
            Name newName = Name.make(name.toString() + "_dup" + dupId++);
            ct.name(newName);
            fullName = QName.make(null, newName);
        }
        try {
            this.typeSystem().systemResolver().addNamed(fullName, ct.asType());
        }
        catch (SemanticException e) {
            this.job.compiler().errorQueue().enqueue(5, e.getMessage(), e.position());
        }
        return ct;
    }

    public TypeBuilder pushAnonClass(Position pos) {
        if (Report.should_report("visit", 4)) {
            Report.report(4, "TB pushing anon class: " + this);
        }
        if (!this.inCode) {
            throw new InternalCompilerError("Can only push an anonymous class within code.");
        }
        TypeSystem ts = this.typeSystem();
        ClassDef ct = ts.createClassDef(this.job().source());
        ct.kind(ClassDef.ANONYMOUS);
        ct.outer(Types.ref(this.currentClass()));
        ct.position(pos);
        ct.setJob(this.job());
        if (this.currentPackage() != null) {
            ct.setPackage(Types.ref(this.currentPackage()));
        }
        return this.pushClass(ct);
    }

    public TypeBuilder pushClass(Position pos, Flags flags, Name name) {
        ClassDef t = this.newClass(pos, flags, name);
        return this.pushClass(t);
    }

    public ClassDef currentClass() {
        return this.type;
    }

    public Package currentPackage() {
        return this.package_;
    }

    public ImportTable importTable() {
        return this.importTable;
    }

    public void setImportTable(ImportTable it) {
        this.importTable = it;
    }

    public String context() {
        return "(TB " + this.type + (this.inCode ? " inCode" : "") + (this.global ? " global" : "") + (this.outer == null ? ")" : " " + this.outer.context() + ")");
    }
}

