/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.BadParseException;
import lpg.runtime.BadParseSymFileException;
import lpg.runtime.ConfigurationElement;
import lpg.runtime.ConfigurationStack;
import lpg.runtime.ErrorToken;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntSegmentedTuple;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.NotBacktrackParseTableException;
import lpg.runtime.ParseTable;
import lpg.runtime.PrsStream;
import lpg.runtime.RecoveryParser;
import lpg.runtime.RuleAction;
import lpg.runtime.Stacks;
import lpg.runtime.TokenStream;
import lpg.runtime.TokenStreamNotIPrsStreamException;

public class BacktrackingParser
extends Stacks {
    private Monitor monitor;
    private int START_STATE;
    private int NUM_RULES;
    private int NT_OFFSET;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ERROR_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int lastToken;
    private int currentAction;
    private TokenStream tokStream;
    private ParseTable prs;
    private RuleAction ra;
    private IntSegmentedTuple action = new IntSegmentedTuple(10, 1024);
    private IntTuple tokens;
    private int[] actionStack;
    private boolean skipTokens = false;
    private int markerTokenIndex = 0;

    private int getMarkerToken(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (this.markerTokenIndex == 0) {
            if (!(this.tokStream instanceof IPrsStream)) {
                throw new TokenStreamNotIPrsStreamException();
            }
            this.markerTokenIndex = ((IPrsStream)this.tokStream).makeErrorToken(this.tokStream.getPrevious(n2), this.tokStream.getPrevious(n2), this.tokStream.getPrevious(n2), n);
        } else {
            ((IPrsStream)this.tokStream).getIToken(this.markerTokenIndex).setKind(n);
        }
        return this.markerTokenIndex;
    }

    public final int getToken(int n) {
        return this.tokens.get(this.locationStack[this.stateStackTop + (n - 1)]);
    }

    public final int getCurrentRule() {
        return this.currentAction;
    }

    public final int getFirstToken() {
        return this.tokStream.getFirstRealToken(this.getToken(1));
    }

    public final int getFirstToken(int n) {
        return this.tokStream.getFirstRealToken(this.getToken(n));
    }

    public final int getLastToken() {
        return this.tokStream.getLastRealToken(this.lastToken);
    }

    public final int getLastToken(int n) {
        int n2 = n >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokens.get(this.locationStack[this.stateStackTop + n] - 1);
        return this.tokStream.getLastRealToken(n2);
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void reset() {
        this.action.reset();
        this.skipTokens = false;
        this.markerTokenIndex = 0;
    }

    public void reset(Monitor monitor, TokenStream tokenStream) {
        this.monitor = monitor;
        this.tokStream = tokenStream;
        this.reset();
    }

    public void reset(TokenStream tokenStream) {
        this.reset(null, tokenStream);
    }

    public void reset(Monitor monitor, TokenStream tokenStream, ParseTable parseTable, RuleAction ruleAction) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.reset(monitor, tokenStream);
        this.prs = parseTable;
        this.ra = ruleAction;
        this.START_STATE = parseTable.getStartState();
        this.NUM_RULES = parseTable.getNumRules();
        this.NT_OFFSET = parseTable.getNtOffset();
        this.LA_STATE_OFFSET = parseTable.getLaStateOffset();
        this.EOFT_SYMBOL = parseTable.getEoftSymbol();
        this.ERROR_SYMBOL = parseTable.getErrorSymbol();
        this.ACCEPT_ACTION = parseTable.getAcceptAction();
        this.ERROR_ACTION = parseTable.getErrorAction();
        if (!parseTable.isValidForParser()) {
            throw new BadParseSymFileException();
        }
        if (!parseTable.getBacktrack()) {
            throw new NotBacktrackParseTableException();
        }
    }

    public void reset(TokenStream tokenStream, ParseTable parseTable, RuleAction ruleAction) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.reset(null, tokenStream, parseTable, ruleAction);
    }

    public BacktrackingParser() {
    }

    public BacktrackingParser(TokenStream tokenStream, ParseTable parseTable, RuleAction ruleAction) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.reset(null, tokenStream, parseTable, ruleAction);
    }

    public BacktrackingParser(Monitor monitor, TokenStream tokenStream, ParseTable parseTable, RuleAction ruleAction) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.reset(monitor, tokenStream, parseTable, ruleAction);
    }

    public void reallocateOtherStacks(int n) {
        if (this.actionStack == null) {
            this.actionStack = new int[this.stateStack.length];
            this.locationStack = new int[this.stateStack.length];
            this.parseStack = new Object[this.stateStack.length];
            this.actionStack[0] = 0;
            this.locationStack[0] = n;
        } else if (this.actionStack.length < this.stateStack.length) {
            int n2 = this.actionStack.length;
            this.actionStack = new int[this.stateStack.length];
            System.arraycopy(this.actionStack, 0, this.actionStack, 0, n2);
            this.locationStack = new int[this.stateStack.length];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, n2);
            this.parseStack = new Object[this.stateStack.length];
            System.arraycopy(this.parseStack, 0, this.parseStack, 0, n2);
        }
    }

    public Object fuzzyParse() throws BadParseException {
        return this.fuzzyParseEntry(0, Integer.MAX_VALUE);
    }

    public Object fuzzyParse(int n) throws BadParseException {
        return this.fuzzyParseEntry(0, n);
    }

    public Object fuzzyParseEntry(int n) throws BadParseException {
        return this.fuzzyParseEntry(n, Integer.MAX_VALUE);
    }

    public Object fuzzyParseEntry(int n, int n2) throws BadParseException {
        int n3;
        this.action.reset();
        this.tokStream.reset();
        this.reallocateStateStack();
        this.stateStackTop = 0;
        this.stateStack[0] = this.START_STATE;
        int n4 = n3 = this.tokStream.peek();
        int n5 = this.getMarkerToken(n, n3);
        this.tokens = new IntTuple(this.tokStream.getStreamLength());
        this.tokens.add(this.tokStream.getPrevious(n3));
        int n6 = this.backtrackParse(this.action, n5);
        if (n6 != 0) {
            if (!(this.tokStream instanceof IPrsStream)) {
                throw new TokenStreamNotIPrsStreamException();
            }
            RecoveryParser recoveryParser = new RecoveryParser(this, this.monitor, this.action, this.tokens, (IPrsStream)this.tokStream, this.prs, n2, 0L);
            n4 = recoveryParser.recover(n5, n6);
        }
        if (n5 != 0 && n4 == n3) {
            this.tokens.add(n5);
        }
        int n7 = n4;
        while (this.tokStream.getKind(n7) != this.EOFT_SYMBOL) {
            this.tokens.add(n7);
            n7 = this.tokStream.getNext(n7);
        }
        this.tokens.add(n7);
        return this.parseActions(n);
    }

    public Object parse() throws BadParseException {
        return this.parseEntry(0, 0);
    }

    public Object parse(int n) throws BadParseException {
        return this.parseEntry(0, n);
    }

    public Object parseEntry(int n) throws BadParseException {
        return this.parseEntry(n, 0);
    }

    public Object parseEntry(int n, int n2) throws BadParseException {
        int n3;
        this.action.reset();
        this.tokStream.reset();
        this.reallocateStateStack();
        this.stateStackTop = 0;
        this.stateStack[0] = this.START_STATE;
        boolean bl = this.skipTokens = n2 < 0;
        if (n2 > 0 && this.tokStream instanceof IPrsStream) {
            n2 = 0;
        }
        this.tokens = new IntTuple(this.tokStream.getStreamLength());
        this.tokens.add(this.tokStream.getPrevious(this.tokStream.peek()));
        int n4 = this.tokStream.peek();
        int n5 = this.getMarkerToken(n, n4);
        int n6 = this.action.size();
        int[] nArray = new int[this.stateStackTop + 1];
        System.arraycopy(this.stateStack, 0, nArray, 0, nArray.length);
        int n7 = n3 = this.backtrackParse(this.action, n5);
        int n8 = 0;
        while (n7 != 0) {
            int n9;
            if (n8 == n2) {
                throw new BadParseException(n3);
            }
            this.action.reset(n6);
            this.tokStream.reset(n4);
            this.stateStackTop = nArray.length - 1;
            System.arraycopy(nArray, 0, this.stateStack, 0, nArray.length);
            this.reallocateOtherStacks(n4);
            this.backtrackParseUpToError(n5, n7);
            this.stateStackTop = this.findRecoveryStateIndex(this.stateStackTop);
            while (this.stateStackTop >= 0 && (n5 = this.errorRepair((IPrsStream)this.tokStream, (n9 = this.tokens.get(this.locationStack[this.stateStackTop] - 1)) >= n4 ? n9 : n7, n7)) == 0) {
                this.stateStackTop = this.findRecoveryStateIndex(this.stateStackTop - 1);
            }
            if (this.stateStackTop < 0) {
                throw new BadParseException(n3);
            }
            nArray = new int[this.stateStackTop + 1];
            System.arraycopy(this.stateStack, 0, nArray, 0, nArray.length);
            n6 = this.action.size();
            n4 = this.tokStream.peek();
            n7 = this.backtrackParse(this.action, n5);
            ++n8;
        }
        if (n5 != 0) {
            this.tokens.add(n5);
        }
        n7 = n4;
        while (this.tokStream.getKind(n7) != this.EOFT_SYMBOL) {
            this.tokens.add(n7);
            n7 = this.tokStream.getNext(n7);
        }
        this.tokens.add(n7);
        return this.parseActions(n);
    }

    private final void process_reductions() {
        do {
            this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
            this.ra.ruleAction(this.currentAction);
            this.currentAction = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(this.currentAction));
        } while (this.currentAction <= this.NUM_RULES);
    }

    private Object parseActions(int n) throws BadParseException {
        int n2 = -1;
        this.lastToken = this.tokens.get(++n2);
        int n3 = this.tokens.get(++n2);
        this.allocateOtherStacks();
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        for (int i = 0; i < this.action.size(); ++i) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return null;
            }
            this.stateStack[++this.stateStackTop] = this.currentAction;
            this.locationStack[this.stateStackTop] = n2++;
            this.currentAction = this.action.get(i);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                this.process_reductions();
                continue;
            }
            if (this.tokStream.getKind(n3) > this.NT_OFFSET) {
                ErrorToken errorToken = (ErrorToken)((PrsStream)this.tokStream).getIToken(n3);
                throw new BadParseException(errorToken.getErrorToken().getTokenIndex());
            }
            this.lastToken = n3;
            n3 = this.tokens.get(n2);
            if (this.currentAction <= this.ERROR_ACTION) continue;
            this.currentAction -= this.ERROR_ACTION;
            this.process_reductions();
        }
        return this.parseStack[n == 0 ? 0 : 1];
    }

    private int process_backtrack_reductions(int n) {
        do {
            this.stateStackTop -= this.prs.rhs(n) - 1;
        } while ((n = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(n))) <= this.NUM_RULES);
        return n;
    }

    int backtrackParse(int[] nArray, int n, IntSegmentedTuple intSegmentedTuple, int n2) {
        this.stateStackTop = n;
        System.arraycopy(nArray, 0, this.stateStack, 0, this.stateStackTop + 1);
        return this.backtrackParse(intSegmentedTuple, n2);
    }

    private int backtrackParse(IntSegmentedTuple intSegmentedTuple, int n) {
        ConfigurationStack configurationStack = new ConfigurationStack(this.prs);
        int n2 = 0;
        int n3 = this.stateStackTop;
        int n4 = this.tokStream.peek();
        int n5 = n > 0 ? n : this.tokStream.getToken();
        int n6 = this.tokStream.getKind(n5);
        int n7 = this.tAction(this.stateStack[this.stateStackTop], n6);
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return 0;
            }
            if (n7 <= this.NUM_RULES) {
                intSegmentedTuple.add(n7);
                --this.stateStackTop;
                n7 = this.process_backtrack_reductions(n7);
            } else if (n7 > this.ERROR_ACTION) {
                intSegmentedTuple.add(n7);
                n5 = this.tokStream.getToken();
                n6 = this.tokStream.getKind(n5);
                n7 = this.process_backtrack_reductions(n7 - this.ERROR_ACTION);
            } else if (n7 < this.ACCEPT_ACTION) {
                intSegmentedTuple.add(n7);
                n5 = this.tokStream.getToken();
                n6 = this.tokStream.getKind(n5);
            } else {
                if (n7 == this.ERROR_ACTION) {
                    n2 = n2 > n5 ? n2 : n5;
                    ConfigurationElement configurationElement = configurationStack.pop();
                    if (configurationElement == null) {
                        n7 = this.ERROR_ACTION;
                        break;
                    }
                    intSegmentedTuple.reset(configurationElement.action_length);
                    n7 = configurationElement.act;
                    n5 = configurationElement.curtok;
                    n6 = this.tokStream.getKind(n5);
                    this.tokStream.reset(n5 == n ? n4 : this.tokStream.getNext(n5));
                    this.stateStackTop = configurationElement.stack_top;
                    configurationElement.retrieveStack(this.stateStack);
                    continue;
                }
                if (n7 <= this.ACCEPT_ACTION) break;
                if (configurationStack.findConfiguration(this.stateStack, this.stateStackTop, n5)) {
                    n7 = this.ERROR_ACTION;
                    continue;
                }
                configurationStack.push(this.stateStack, this.stateStackTop, n7 + 1, n5, intSegmentedTuple.size());
                n7 = this.prs.baseAction(n7);
                n3 = this.stateStackTop > n3 ? this.stateStackTop : n3;
                continue;
            }
            try {
                this.stateStack[++this.stateStackTop] = n7;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStateStack();
                this.stateStack[this.stateStackTop] = n7;
            }
            n7 = this.tAction(n7, n6);
        }
        return n7 == this.ERROR_ACTION ? n2 : 0;
    }

    private void backtrackParseUpToError(int n, int n2) {
        ConfigurationStack configurationStack = new ConfigurationStack(this.prs);
        int n3 = this.tokStream.peek();
        int n4 = n > 0 ? n : this.tokStream.getToken();
        int n5 = this.tokStream.getKind(n4);
        int n6 = this.tAction(this.stateStack[this.stateStackTop], n5);
        this.tokens.add(n4);
        this.locationStack[this.stateStackTop] = this.tokens.size();
        this.actionStack[this.stateStackTop] = this.action.size();
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return;
            }
            if (n6 <= this.NUM_RULES) {
                this.action.add(n6);
                --this.stateStackTop;
                n6 = this.process_backtrack_reductions(n6);
            } else if (n6 > this.ERROR_ACTION) {
                this.action.add(n6);
                n4 = this.tokStream.getToken();
                n5 = this.tokStream.getKind(n4);
                this.tokens.add(n4);
                n6 = this.process_backtrack_reductions(n6 - this.ERROR_ACTION);
            } else if (n6 < this.ACCEPT_ACTION) {
                this.action.add(n6);
                n4 = this.tokStream.getToken();
                n5 = this.tokStream.getKind(n4);
                this.tokens.add(n4);
            } else {
                if (n6 == this.ERROR_ACTION) {
                    if (n4 == n2) break;
                    ConfigurationElement configurationElement = configurationStack.pop();
                    if (configurationElement == null) {
                        n6 = this.ERROR_ACTION;
                        break;
                    }
                    this.action.reset(configurationElement.action_length);
                    n6 = configurationElement.act;
                    int n7 = configurationElement.curtok;
                    this.tokens.reset(n7);
                    n4 = this.tokens.get(n7 - 1);
                    n5 = this.tokStream.getKind(n4);
                    this.tokStream.reset(n4 == n ? n3 : this.tokStream.getNext(n4));
                    this.stateStackTop = configurationElement.stack_top;
                    configurationElement.retrieveStack(this.stateStack);
                    this.locationStack[this.stateStackTop] = this.tokens.size();
                    this.actionStack[this.stateStackTop] = this.action.size();
                    continue;
                }
                if (n6 <= this.ACCEPT_ACTION) break;
                if (configurationStack.findConfiguration(this.stateStack, this.stateStackTop, this.tokens.size())) {
                    n6 = this.ERROR_ACTION;
                    continue;
                }
                configurationStack.push(this.stateStack, this.stateStackTop, n6 + 1, this.tokens.size(), this.action.size());
                n6 = this.prs.baseAction(n6);
                continue;
            }
            this.stateStack[++this.stateStackTop] = n6;
            this.locationStack[this.stateStackTop] = this.tokens.size();
            this.actionStack[this.stateStackTop] = this.action.size();
            n6 = this.tAction(n6, n5);
        }
    }

    private boolean repairable(int n) {
        ConfigurationStack configurationStack = new ConfigurationStack(this.prs);
        int n2 = this.tokStream.peek();
        int n3 = this.tokStream.getStreamLength();
        int n4 = 0;
        int n5 = this.ERROR_SYMBOL;
        int n6 = this.tAction(this.stateStack[this.stateStackTop], n5);
        while (true) {
            if (n6 <= this.NUM_RULES) {
                --this.stateStackTop;
                n6 = this.process_backtrack_reductions(n6);
            } else if (n6 > this.ERROR_ACTION) {
                n4 = this.tokStream.getToken();
                if (n4 > n3) {
                    return true;
                }
                n5 = this.tokStream.getKind(n4);
                n6 = this.process_backtrack_reductions(n6 - this.ERROR_ACTION);
            } else if (n6 < this.ACCEPT_ACTION) {
                n4 = this.tokStream.getToken();
                if (n4 > n3) {
                    return true;
                }
                n5 = this.tokStream.getKind(n4);
            } else {
                if (n6 == this.ERROR_ACTION) {
                    ConfigurationElement configurationElement = configurationStack.pop();
                    if (configurationElement == null) {
                        n6 = this.ERROR_ACTION;
                        break;
                    }
                    this.stateStackTop = configurationElement.stack_top;
                    configurationElement.retrieveStack(this.stateStack);
                    n6 = configurationElement.act;
                    n4 = configurationElement.curtok;
                    if (n4 == 0) {
                        n5 = this.ERROR_SYMBOL;
                        this.tokStream.reset(n2);
                        continue;
                    }
                    n5 = this.tokStream.getKind(n4);
                    this.tokStream.reset(this.tokStream.getNext(n4));
                    continue;
                }
                if (n6 <= this.ACCEPT_ACTION) break;
                if (configurationStack.findConfiguration(this.stateStack, this.stateStackTop, n4)) {
                    n6 = this.ERROR_ACTION;
                    continue;
                }
                configurationStack.push(this.stateStack, this.stateStackTop, n6 + 1, n4, 0);
                n6 = this.prs.baseAction(n6);
                continue;
            }
            try {
                if (n4 > n && n3 == this.tokStream.getStreamLength() && this.recoverableState(n6)) {
                    n3 = this.skipTokens ? n4 : this.tokStream.getNext(n4);
                }
                this.stateStack[++this.stateStackTop] = n6;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStateStack();
                this.stateStack[this.stateStackTop] = n6;
            }
            n6 = this.tAction(n6, n5);
        }
        return n6 == this.ACCEPT_ACTION;
    }

    private boolean recoverableState(int n) {
        int n2 = this.prs.asi(n);
        while (this.prs.asr(n2) != 0) {
            if (this.prs.asr(n2) == this.ERROR_SYMBOL) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int findRecoveryStateIndex(int n) {
        int n2;
        for (n2 = n; n2 >= 0 && !this.recoverableState(this.stateStack[n2]); --n2) {
        }
        if (n2 >= 0) {
            int n3;
            for (n3 = n2 - 1; n3 >= 0 && this.locationStack[n3] == this.locationStack[n2]; --n3) {
            }
            n2 = n3 + 1;
        }
        return n2;
    }

    private int errorRepair(IPrsStream iPrsStream, int n, int n2) {
        int[] nArray = new int[this.stateStackTop + 1];
        System.arraycopy(this.stateStack, 0, nArray, 0, nArray.length);
        while (iPrsStream.getKind(n) != this.EOFT_SYMBOL) {
            iPrsStream.reset(n);
            if (this.repairable(n2)) break;
            this.stateStackTop = nArray.length - 1;
            System.arraycopy(nArray, 0, this.stateStack, 0, nArray.length);
            n = iPrsStream.getNext(n);
        }
        if (iPrsStream.getKind(n) == this.EOFT_SYMBOL) {
            iPrsStream.reset(n);
            if (!this.repairable(n2)) {
                this.stateStackTop = nArray.length - 1;
                System.arraycopy(nArray, 0, this.stateStack, 0, nArray.length);
                return 0;
            }
        }
        this.stateStackTop = nArray.length - 1;
        System.arraycopy(nArray, 0, this.stateStack, 0, nArray.length);
        iPrsStream.reset(n);
        this.tokens.reset(this.locationStack[this.stateStackTop] - 1);
        this.action.reset(this.actionStack[this.stateStackTop]);
        return iPrsStream.makeErrorToken(this.tokens.get(this.locationStack[this.stateStackTop] - 1), iPrsStream.getPrevious(n), n2, this.ERROR_SYMBOL);
    }

    private int lookahead(int n, int n2) {
        return (n = this.prs.lookAhead(n - this.LA_STATE_OFFSET, this.tokStream.getKind(n2))) > this.LA_STATE_OFFSET ? this.lookahead(n, this.tokStream.getNext(n2)) : n;
    }

    private int tAction(int n, int n2) {
        return (n = this.prs.tAction(n, n2)) > this.LA_STATE_OFFSET ? this.lookahead(n, this.tokStream.peek()) : n;
    }
}

