/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

public class IntSegmentedTuple {
    private int top;
    private int size;
    private int log_blksize = 3;
    private int base_size = 4;
    private int[][] base;

    private void allocateMoreSpace() {
        int n = this.size >> this.log_blksize;
        if (n == this.base_size) {
            this.base_size *= 2;
            int[][] nArrayArray = new int[this.base_size][];
            this.base = nArrayArray;
            System.arraycopy(this.base, 0, nArrayArray, 0, n);
        }
        this.base[n] = new int[1 << this.log_blksize];
        this.size += 1 << this.log_blksize;
    }

    public void resize() {
        this.resize(0);
    }

    public void resize(int n) {
        if (n > this.size) {
            do {
                this.allocateMoreSpace();
            } while (n > this.size);
        }
        this.top = n;
    }

    public void reset() {
        this.reset(0);
    }

    public void reset(int n) {
        this.top = n;
    }

    public int size() {
        return this.top;
    }

    public boolean outOfRange(int n) {
        return n < 0 || n >= this.top;
    }

    public int get(int n) {
        return this.base[n >> this.log_blksize][n % (1 << this.log_blksize)];
    }

    public void set(int n, int n2) {
        this.base[n >> this.log_blksize][n % (1 << this.log_blksize)] = n2;
    }

    public int NextIndex() {
        int n;
        if ((n = this.top++) == this.size) {
            this.allocateMoreSpace();
        }
        return n;
    }

    public void add(int n) {
        int n2 = this.NextIndex();
        this.base[n2 >> this.log_blksize][n2 % (1 << this.log_blksize)] = n;
    }

    public int binarySearch(int n) {
        int n2 = 0;
        int n3 = this.top;
        while (n3 > n2) {
            int n4 = (n3 + n2) / 2;
            int n5 = this.get(n4);
            if (n == n5) {
                return n4;
            }
            if (n < n5) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return -n2;
    }

    public IntSegmentedTuple() {
        this.base = new int[this.base_size][];
    }

    public IntSegmentedTuple(int n) {
        this.log_blksize = n;
        this.base = new int[this.base_size][];
    }

    public IntSegmentedTuple(int n, int n2) {
        this.log_blksize = n;
        this.base_size = n2 <= 0 ? 4 : n2;
        this.base = new int[this.base_size][];
    }
}

