/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.BooleanType;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Literal;
import soot.JastAddJ.TypeDecl;
import soot.Value;

public class BooleanLiteral
extends Literal
implements Cloneable {
    protected boolean constant_computed = false;
    protected Constant constant_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public BooleanLiteral clone() throws CloneNotSupportedException {
        BooleanLiteral node = (BooleanLiteral)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public BooleanLiteral copy() {
        try {
            BooleanLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public BooleanLiteral fullCopy() {
        BooleanLiteral res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild((ASTNode)node, i);
        }
        return res;
    }

    public BooleanLiteral(boolean b) {
        this(b ? "true" : "false");
    }

    public Value eval(Body b) {
        return BooleanType.emitConstant(this.constant().booleanValue());
    }

    public BooleanLiteral() {
    }

    public BooleanLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public BooleanLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    protected int numChildren() {
        return 0;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        return Constant.create(Boolean.valueOf(this.getLITERAL()));
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeBoolean();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

