/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.MultiplicativeExpr;
import soot.Value;

public class DivExpr
extends MultiplicativeExpr
implements Cloneable {
    protected int isConstant_visited = -1;
    protected boolean isConstant_computed = false;
    protected boolean isConstant_initialized = false;
    protected boolean isConstant_value;

    public void flushCache() {
        super.flushCache();
        this.isConstant_visited = -1;
        this.isConstant_computed = false;
        this.isConstant_initialized = false;
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public DivExpr clone() throws CloneNotSupportedException {
        DivExpr node = (DivExpr)super.clone();
        node.isConstant_visited = -1;
        node.isConstant_computed = false;
        node.isConstant_initialized = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public DivExpr copy() {
        try {
            DivExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public DivExpr fullCopy() {
        DivExpr res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild((ASTNode)node, i);
        }
        return res;
    }

    public Value emitOperation(Body b, Value left, Value right) {
        return this.asLocal(b, b.newDivExpr(this.asImmediate(b, left), this.asImmediate(b, right), this));
    }

    public DivExpr() {
    }

    public DivExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    protected int numChildren() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        return this.type().div(this.getLeftOperand().constant(), this.getRightOperand().constant());
    }

    public boolean isConstant() {
        if (this.isConstant_computed) {
            return this.isConstant_value;
        }
        ASTNode$State state = this.state();
        if (!this.isConstant_initialized) {
            this.isConstant_initialized = true;
            this.isConstant_value = false;
        }
        if (!state.IN_CIRCLE) {
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                this.isConstant_visited = state.CIRCLE_INDEX;
                state.CHANGE = false;
                boolean new_isConstant_value = this.isConstant_compute();
                if (new_isConstant_value != this.isConstant_value) {
                    state.CHANGE = true;
                }
                this.isConstant_value = new_isConstant_value;
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.isConstant_computed = true;
            } else {
                state.RESET_CYCLE = true;
                this.isConstant_compute();
                state.RESET_CYCLE = false;
                this.isConstant_computed = false;
                this.isConstant_initialized = false;
            }
            state.IN_CIRCLE = false;
            return this.isConstant_value;
        }
        if (this.isConstant_visited != state.CIRCLE_INDEX) {
            this.isConstant_visited = state.CIRCLE_INDEX;
            if (state.RESET_CYCLE) {
                this.isConstant_computed = false;
                this.isConstant_initialized = false;
                this.isConstant_visited = -1;
                return this.isConstant_value;
            }
            boolean new_isConstant_value = this.isConstant_compute();
            if (new_isConstant_value != this.isConstant_value) {
                state.CHANGE = true;
            }
            this.isConstant_value = new_isConstant_value;
            return this.isConstant_value;
        }
        return this.isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getLeftOperand().isConstant() && this.getRightOperand().isConstant() && (!this.getRightOperand().type().isInt() || this.getRightOperand().constant().intValue() != 0);
    }

    public String printOp() {
        ASTNode$State state = this.state();
        String printOp_value = this.printOp_compute();
        return printOp_value;
    }

    private String printOp_compute() {
        return " / ";
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

