/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.HashMap;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.BranchTargetStmt;
import soot.JastAddJ.BreakStmt;
import soot.JastAddJ.ContinueStmt;
import soot.JastAddJ.Expr;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;

public class DoStmt
extends BranchTargetStmt
implements Cloneable {
    protected Map targetOf_ContinueStmt_values;
    protected Map targetOf_BreakStmt_values;
    protected Map isDAafter_Variable_values;
    protected Map isDUafter_Variable_values;
    protected Map isDUbeforeCondition_Variable_values;
    protected boolean canCompleteNormally_computed = false;
    protected boolean canCompleteNormally_value;
    protected boolean begin_label_computed = false;
    protected soot.jimple.Stmt begin_label_value;
    protected boolean cond_label_computed = false;
    protected soot.jimple.Stmt cond_label_value;
    protected boolean end_label_computed = false;
    protected soot.jimple.Stmt end_label_value;

    public void flushCache() {
        super.flushCache();
        this.targetOf_ContinueStmt_values = null;
        this.targetOf_BreakStmt_values = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.isDUbeforeCondition_Variable_values = null;
        this.canCompleteNormally_computed = false;
        this.begin_label_computed = false;
        this.begin_label_value = null;
        this.cond_label_computed = false;
        this.cond_label_value = null;
        this.end_label_computed = false;
        this.end_label_value = null;
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public DoStmt clone() throws CloneNotSupportedException {
        DoStmt node = (DoStmt)super.clone();
        node.targetOf_ContinueStmt_values = null;
        node.targetOf_BreakStmt_values = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.isDUbeforeCondition_Variable_values = null;
        node.canCompleteNormally_computed = false;
        node.begin_label_computed = false;
        node.begin_label_value = null;
        node.cond_label_computed = false;
        node.cond_label_value = null;
        node.end_label_computed = false;
        node.end_label_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public DoStmt copy() {
        try {
            DoStmt node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public DoStmt fullCopy() {
        DoStmt res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild((ASTNode)node, i);
        }
        return res;
    }

    public void toString(StringBuffer s) {
        s.append(this.indent());
        s.append("do ");
        this.getStmt().toString(s);
        s.append("while(");
        this.getCondition().toString(s);
        s.append(");");
    }

    public void typeCheck() {
        TypeDecl cond = this.getCondition().type();
        if (!cond.isBoolean()) {
            this.error("the type of \"" + this.getCondition() + "\" is " + cond.name() + " which is not boolean");
        }
    }

    public void jimplify2(Body b) {
        b.setLine(this);
        b.addLabel(this.begin_label());
        this.getStmt().jimplify2(b);
        b.addLabel(this.cond_label());
        this.getCondition().emitEvalBranch(b);
        if (this.canCompleteNormally()) {
            b.addLabel(this.end_label());
        }
    }

    public DoStmt() {
    }

    public DoStmt(Stmt p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    protected int numChildren() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setStmt(Stmt node) {
        this.setChild(node, 0);
    }

    public Stmt getStmt() {
        return (Stmt)this.getChild(0);
    }

    public Stmt getStmtNoTransform() {
        return (Stmt)this.getChildNoTransform(0);
    }

    public void setCondition(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getCondition() {
        return (Expr)this.getChild(1);
    }

    public Expr getConditionNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    public boolean targetOf(ContinueStmt stmt) {
        ContinueStmt _parameters = stmt;
        if (this.targetOf_ContinueStmt_values == null) {
            this.targetOf_ContinueStmt_values = new HashMap(4);
        }
        if (this.targetOf_ContinueStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_ContinueStmt_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_ContinueStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetOf_ContinueStmt_values.put(_parameters, targetOf_ContinueStmt_value);
        }
        return targetOf_ContinueStmt_value;
    }

    private boolean targetOf_compute(ContinueStmt stmt) {
        return !stmt.hasLabel();
    }

    public boolean targetOf(BreakStmt stmt) {
        BreakStmt _parameters = stmt;
        if (this.targetOf_BreakStmt_values == null) {
            this.targetOf_BreakStmt_values = new HashMap(4);
        }
        if (this.targetOf_BreakStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_BreakStmt_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_BreakStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetOf_BreakStmt_values.put(_parameters, targetOf_BreakStmt_value);
        }
        return targetOf_BreakStmt_value;
    }

    private boolean targetOf_compute(BreakStmt stmt) {
        return !stmt.hasLabel();
    }

    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        if (!this.getCondition().isDAafterFalse(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDAafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        if (!this.isDUbeforeCondition(v)) {
            return false;
        }
        if (!this.getCondition().isDUafterFalse(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public boolean isDUbeforeCondition(Variable v) {
        ASTNode$State.CircularValue _value;
        Variable _parameters = v;
        if (this.isDUbeforeCondition_Variable_values == null) {
            this.isDUbeforeCondition_Variable_values = new HashMap(4);
        }
        if (this.isDUbeforeCondition_Variable_values.containsKey(_parameters)) {
            Object _o = this.isDUbeforeCondition_Variable_values.get(_parameters);
            if (!(_o instanceof ASTNode$State.CircularValue)) {
                return (Boolean)_o;
            }
            _value = (ASTNode$State.CircularValue)_o;
        } else {
            _value = new ASTNode$State.CircularValue();
            this.isDUbeforeCondition_Variable_values.put(_parameters, _value);
            _value.value = true;
        }
        ASTNode$State state = this.state();
        if (!state.IN_CIRCLE) {
            boolean new_isDUbeforeCondition_Variable_value;
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                _value.visited = new Integer(state.CIRCLE_INDEX);
                state.CHANGE = false;
                new_isDUbeforeCondition_Variable_value = this.isDUbeforeCondition_compute(v);
                if (new_isDUbeforeCondition_Variable_value != (Boolean)_value.value) {
                    state.CHANGE = true;
                    _value.value = new_isDUbeforeCondition_Variable_value;
                }
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.isDUbeforeCondition_Variable_values.put(_parameters, new_isDUbeforeCondition_Variable_value);
            } else {
                this.isDUbeforeCondition_Variable_values.remove(_parameters);
                state.RESET_CYCLE = true;
                this.isDUbeforeCondition_compute(v);
                state.RESET_CYCLE = false;
            }
            state.IN_CIRCLE = false;
            return new_isDUbeforeCondition_Variable_value;
        }
        if (!new Integer(state.CIRCLE_INDEX).equals(_value.visited)) {
            _value.visited = new Integer(state.CIRCLE_INDEX);
            boolean new_isDUbeforeCondition_Variable_value = this.isDUbeforeCondition_compute(v);
            if (state.RESET_CYCLE) {
                this.isDUbeforeCondition_Variable_values.remove(_parameters);
            } else if (new_isDUbeforeCondition_Variable_value != (Boolean)_value.value) {
                state.CHANGE = true;
                _value.value = new_isDUbeforeCondition_Variable_value;
            }
            return new_isDUbeforeCondition_Variable_value;
        }
        return (Boolean)_value.value;
    }

    private boolean isDUbeforeCondition_compute(Variable v) {
        if (!this.getStmt().isDUafter(v)) {
            return false;
        }
        for (ContinueStmt stmt : this.targetContinues()) {
            if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public boolean continueLabel() {
        ASTNode$State state = this.state();
        boolean continueLabel_value = this.continueLabel_compute();
        return continueLabel_value;
    }

    private boolean continueLabel_compute() {
        return true;
    }

    public boolean canCompleteNormally() {
        if (this.canCompleteNormally_computed) {
            return this.canCompleteNormally_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.canCompleteNormally_value = this.canCompleteNormally_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.canCompleteNormally_computed = true;
        }
        return this.canCompleteNormally_value;
    }

    private boolean canCompleteNormally_compute() {
        return this.getStmt().canCompleteNormally() && (!this.getCondition().isConstant() || !this.getCondition().isTrue()) || this.reachableContinue() && (!this.getCondition().isConstant() || !this.getCondition().isTrue()) || this.reachableBreak();
    }

    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return true;
    }

    public soot.jimple.Stmt begin_label() {
        if (this.begin_label_computed) {
            return this.begin_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.begin_label_value = this.begin_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.begin_label_computed = true;
        }
        return this.begin_label_value;
    }

    private soot.jimple.Stmt begin_label_compute() {
        return this.newLabel();
    }

    public soot.jimple.Stmt cond_label() {
        if (this.cond_label_computed) {
            return this.cond_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.cond_label_value = this.cond_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.cond_label_computed = true;
        }
        return this.cond_label_value;
    }

    private soot.jimple.Stmt cond_label_compute() {
        return this.newLabel();
    }

    public soot.jimple.Stmt end_label() {
        if (this.end_label_computed) {
            return this.end_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.end_label_value = this.end_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.end_label_computed = true;
        }
        return this.end_label_value;
    }

    private soot.jimple.Stmt end_label_compute() {
        return this.newLabel();
    }

    public soot.jimple.Stmt break_label() {
        ASTNode$State state = this.state();
        soot.jimple.Stmt break_label_value = this.break_label_compute();
        return break_label_value;
    }

    private soot.jimple.Stmt break_label_compute() {
        return this.end_label();
    }

    public soot.jimple.Stmt continue_label() {
        ASTNode$State state = this.state();
        soot.jimple.Stmt continue_label_value = this.continue_label_compute();
        return continue_label_value;
    }

    private soot.jimple.Stmt continue_label_compute() {
        return this.cond_label();
    }

    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getConditionNoTransform()) {
            if (!this.getStmt().isDAafter(v)) {
                return false;
            }
            for (ContinueStmt stmt : this.targetContinues()) {
                if (stmt.isDAafterReachedFinallyBlocks(v)) continue;
                return false;
            }
            return true;
        }
        if (caller == this.getStmtNoTransform()) {
            return this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getConditionNoTransform()) {
            return this.isDUbeforeCondition(v);
        }
        if (caller == this.getStmtNoTransform()) {
            return this.isDUbefore(v) && this.getCondition().isDUafterTrue(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    public boolean Define_boolean_insideLoop(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_insideLoop(this, caller);
    }

    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    public boolean Define_boolean_reportUnreachable(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reportUnreachable(this, caller);
    }

    public soot.jimple.Stmt Define_soot_jimple_Stmt_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getConditionNoTransform()) {
            return this.end_label();
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_false_label(this, caller);
    }

    public soot.jimple.Stmt Define_soot_jimple_Stmt_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getConditionNoTransform()) {
            return this.begin_label();
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_true_label(this, caller);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

