/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.Collection;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Annotation;
import soot.JastAddJ.ElementValue;
import soot.JastAddJ.EnumConstant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.NameType;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;

public class ElementConstantValue
extends ElementValue
implements Cloneable {
    public void flushCache() {
        super.flushCache();
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public ElementConstantValue clone() throws CloneNotSupportedException {
        ElementConstantValue node = (ElementConstantValue)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ElementConstantValue copy() {
        try {
            ElementConstantValue node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ElementConstantValue fullCopy() {
        ElementConstantValue res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild((ASTNode)node, i);
        }
        return res;
    }

    public void nameCheck() {
        Variable v;
        if (this.enclosingAnnotationDecl().fullName().equals("java.lang.annotation.Target") && (v = this.getExpr().varDecl()) != null && v.hostType().fullName().equals("java.lang.annotation.ElementType") && this.lookupElementTypeValue(v.name()) != this) {
            this.error("repeated annotation target");
        }
    }

    public void toString(StringBuffer s) {
        this.getExpr().toString(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendAsAttributeTo(Collection list, String name) {
        if (this.getExpr().isConstant() && !this.getExpr().type().isEnumDecl()) {
            char kind = this.getExpr().type().isString() ? (char)'s' : (char)this.getExpr().type().typeDescriptor().charAt(0);
            TypeDecl type = this.getExpr().type();
            if (type.isLong()) {
                list.add(new AnnotationLongElem(this.getExpr().constant().longValue(), kind, name));
                return;
            } else if (type.isDouble()) {
                list.add(new AnnotationDoubleElem(this.getExpr().constant().doubleValue(), kind, name));
                return;
            } else if (type.isFloat()) {
                list.add(new AnnotationFloatElem(this.getExpr().constant().floatValue(), kind, name));
                return;
            } else if (type.isString()) {
                list.add(new AnnotationStringElem(this.getExpr().constant().stringValue(), kind, name));
                return;
            } else if (type.isIntegralType()) {
                list.add(new AnnotationIntElem(this.getExpr().constant().intValue(), kind, name));
                return;
            } else {
                if (!this.type().isBoolean()) throw new UnsupportedOperationException("Unsupported attribute constant type " + type.typeName());
                list.add(new AnnotationBooleanElem(this.getExpr().constant().booleanValue(), kind, name));
            }
            return;
        } else if (this.getExpr().isClassAccess()) {
            list.add(new AnnotationClassElem(this.getExpr().type().typeDescriptor(), 'c', name));
            return;
        } else {
            Variable v = this.getExpr().varDecl();
            if (v == null) {
                throw new Error("Expected Enumeration constant");
            }
            list.add(new AnnotationEnumElem(v.type().typeDescriptor(), v.name(), 'e', name));
        }
    }

    public ElementConstantValue() {
    }

    public ElementConstantValue(Expr p0) {
        this.setChild(p0, 0);
    }

    protected int numChildren() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public boolean validTarget(Annotation a) {
        ASTNode$State state = this.state();
        boolean validTarget_Annotation_value = this.validTarget_compute(a);
        return validTarget_Annotation_value;
    }

    private boolean validTarget_compute(Annotation a) {
        Variable v = this.getExpr().varDecl();
        if (v == null) {
            return true;
        }
        return v.hostType().fullName().equals("java.lang.annotation.ElementType") && a.mayUseAnnotationTarget(v.name());
    }

    public ElementValue definesElementTypeValue(String name) {
        ASTNode$State state = this.state();
        ElementValue definesElementTypeValue_String_value = this.definesElementTypeValue_compute(name);
        return definesElementTypeValue_String_value;
    }

    private ElementValue definesElementTypeValue_compute(String name) {
        Variable v = this.getExpr().varDecl();
        if (v != null && v.hostType().fullName().equals("java.lang.annotation.ElementType") && v.name().equals(name)) {
            return this;
        }
        return null;
    }

    public boolean hasValue(String s) {
        ASTNode$State state = this.state();
        boolean hasValue_String_value = this.hasValue_compute(s);
        return hasValue_String_value;
    }

    private boolean hasValue_compute(String s) {
        return this.getExpr().type().isString() && this.getExpr().isConstant() && this.getExpr().constant().stringValue().equals(s);
    }

    public boolean commensurateWithTypeDecl(TypeDecl type) {
        ASTNode$State state = this.state();
        boolean commensurateWithTypeDecl_TypeDecl_value = this.commensurateWithTypeDecl_compute(type);
        return commensurateWithTypeDecl_TypeDecl_value;
    }

    private boolean commensurateWithTypeDecl_compute(TypeDecl type) {
        Expr v = this.getExpr();
        if (!v.type().assignConversionTo(type, v)) {
            return false;
        }
        if ((type.isPrimitive() || type.isString()) && !v.isConstant()) {
            return false;
        }
        if (v.type().isNull()) {
            return false;
        }
        if (type.fullName().equals("java.lang.Class") && !v.isClassAccess()) {
            return false;
        }
        return !type.isEnumDecl() || v.varDecl() != null && v.varDecl() instanceof EnumConstant;
    }

    public TypeDecl type() {
        ASTNode$State state = this.state();
        TypeDecl type_value = this.type_compute();
        return type_value;
    }

    private TypeDecl type_compute() {
        return this.getExpr().type();
    }

    public ElementValue lookupElementTypeValue(String name) {
        ASTNode$State state = this.state();
        ElementValue lookupElementTypeValue_String_value = this.getParent().Define_ElementValue_lookupElementTypeValue(this, null, name);
        return lookupElementTypeValue_String_value;
    }

    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return NameType.AMBIGUOUS_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    public String Define_String_methodHost(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return this.enclosingAnnotationDecl().typeName();
        }
        return this.getParent().Define_String_methodHost(this, caller);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

