/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.Iterator;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.ElementArrayValue;
import soot.JastAddJ.ElementConstantValue;
import soot.JastAddJ.ElementValue;
import soot.JastAddJ.List;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.TypeDecl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementValuePair
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ElementValuePair clone() throws CloneNotSupportedException {
        ElementValuePair node = (ElementValuePair)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ElementValuePair copy() {
        try {
            ElementValuePair node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ElementValuePair fullCopy() {
        ElementValuePair res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild((ASTNode)node, i);
        }
        return res;
    }

    @Override
    public void typeCheck() {
        if (!this.type().commensurateWith(this.getElementValue())) {
            this.error(this.type().typeName() + " is not commensurate with " + this.getElementValue().type().typeName());
        }
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.getName() + " = ");
        this.getElementValue().toString(s);
    }

    public ElementValuePair() {
    }

    public ElementValuePair(String p0, ElementValue p1) {
        this.setName(p0);
        this.setChild(p1, 0);
    }

    public ElementValuePair(Symbol p0, ElementValue p1) {
        this.setName(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setElementValue(ElementValue node) {
        this.setChild(node, 0);
    }

    public ElementValue getElementValue() {
        return (ElementValue)this.getChild(0);
    }

    public ElementValue getElementValueNoTransform() {
        return (ElementValue)this.getChildNoTransform(0);
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        Iterator iter = this.enclosingAnnotationDecl().memberMethods(this.getName()).iterator();
        if (iter.hasNext()) {
            MethodDecl m = (MethodDecl)iter.next();
            return m.type();
        }
        return this.unknownType();
    }

    public TypeDecl unknownType() {
        ASTNode$State state = this.state();
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    public TypeDecl enclosingAnnotationDecl() {
        ASTNode$State state = this.state();
        TypeDecl enclosingAnnotationDecl_value = this.getParent().Define_TypeDecl_enclosingAnnotationDecl(this, null);
        return enclosingAnnotationDecl_value;
    }

    @Override
    public ASTNode rewriteTo() {
        if (this.type().isArrayDecl() && this.getElementValue() instanceof ElementConstantValue) {
            ++this.state().duringAnnotations;
            ElementValuePair result = this.rewriteRule0();
            --this.state().duringAnnotations;
            return result;
        }
        return super.rewriteTo();
    }

    private ElementValuePair rewriteRule0() {
        this.setElementValue(new ElementArrayValue(new List<ElementValue>().add(this.getElementValue())));
        return this;
    }
}

