/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.IntType;
import soot.JastAddJ.Literal;
import soot.JastAddJ.TypeDecl;
import soot.Value;

public class IntegerLiteral
extends Literal
implements Cloneable {
    protected boolean constant_computed = false;
    protected Constant constant_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    public IntegerLiteral clone() throws CloneNotSupportedException {
        IntegerLiteral node = (IntegerLiteral)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public IntegerLiteral copy() {
        try {
            IntegerLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public IntegerLiteral fullCopy() {
        IntegerLiteral res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild((ASTNode)node, i);
        }
        return res;
    }

    public IntegerLiteral(int i) {
        this(Integer.toString(i));
    }

    public void typeCheck() {
        if (this.constant().error) {
            this.error("The value of an int literal must be a decimal value in the range -2147483648..2147483647 or a hexadecimal or octal literal that fits in 32 bits.");
        }
    }

    public Value eval(Body b) {
        return IntType.emitConstant(this.constant().intValue());
    }

    public IntegerLiteral() {
    }

    public IntegerLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public IntegerLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    protected int numChildren() {
        return 0;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public boolean isHex() {
        ASTNode$State state = this.state();
        boolean isHex_value = this.isHex_compute();
        return isHex_value;
    }

    private boolean isHex_compute() {
        return this.getLITERAL().toLowerCase().startsWith("0x");
    }

    public boolean isOctal() {
        ASTNode$State state = this.state();
        boolean isOctal_value = this.isOctal_compute();
        return isOctal_value;
    }

    private boolean isOctal_compute() {
        return this.getLITERAL().startsWith("0");
    }

    public boolean isDecimal() {
        ASTNode$State state = this.state();
        boolean isDecimal_value = this.isDecimal_compute();
        return isDecimal_value;
    }

    private boolean isDecimal_compute() {
        return !this.isHex() && !this.isOctal();
    }

    public boolean isPositive() {
        ASTNode$State state = this.state();
        boolean isPositive_value = this.isPositive_compute();
        return isPositive_value;
    }

    private boolean isPositive_compute() {
        return !this.getLITERAL().startsWith("-");
    }

    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        long l = 0L;
        try {
            l = Literal.parseLong(this.getLITERAL());
        }
        catch (NumberFormatException e) {
            Constant c = Constant.create(0L);
            c.error = true;
            return c;
        }
        Constant c = Constant.create((int)l);
        if (this.isDecimal() && l != (long)((int)l)) {
            c.error = true;
        }
        if (this.isOctal() && l > 0xFFFFFFFFL) {
            c.error = true;
        }
        if (this.isHex() && l > 0xFFFFFFFFL) {
            c.error = true;
        }
        return c;
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeInt();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

