/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import polyglot.ast.Node;
import soot.ClassSource;
import soot.G;
import soot.JastAddInitialResolver;
import soot.SootClass;
import soot.SourceLocator;
import soot.javaToJimple.IInitialResolver;
import soot.javaToJimple.InitialResolver;
import soot.options.Options;
import soot.toolkits.astmetrics.ComputeASTMetrics;

public class JavaClassSource
extends ClassSource {
    protected File fullPath;

    public JavaClassSource(String className, File fullPath) {
        super(className);
        this.fullPath = fullPath;
    }

    public JavaClassSource(String className) {
        super(className);
    }

    public IInitialResolver.Dependencies resolve(SootClass sc) {
        if (Options.v().verbose()) {
            G.v().out.println("resolving [from .java]: " + this.className);
        }
        IInitialResolver resolver = Options.v().polyglot() ? InitialResolver.v() : JastAddInitialResolver.v();
        if (this.fullPath != null) {
            resolver.formAst(this.fullPath.getPath(), SourceLocator.v().sourcePath(), this.className);
        }
        IInitialResolver.Dependencies references = resolver.resolveFromJavaFile(sc);
        if (Options.v().ast_metrics()) {
            Node ast = InitialResolver.v().getAst();
            if (ast == null) {
                G.v().out.println("No compatible AST available for AST metrics. Skipping. Try -polyglot option.");
            } else {
                ComputeASTMetrics metrics = new ComputeASTMetrics(ast);
                metrics.apply();
            }
        }
        return references;
    }
}

