/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.Unit;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchingChain<E extends Unit>
extends AbstractCollection<E>
implements Chain<E> {
    protected Chain<E> innerChain;

    public PatchingChain(Chain<E> aChain) {
        this.innerChain = aChain;
    }

    public Chain<E> getNonPatchingChain() {
        return this.innerChain;
    }

    @Override
    public boolean add(E o) {
        return this.innerChain.add(o);
    }

    @Override
    public void swapWith(E out, E in) {
        this.insertBefore(in, out);
        this.remove(out);
    }

    @Override
    public void insertAfter(E toInsert, E point) {
        this.innerChain.insertAfter(toInsert, point);
    }

    @Override
    public void insertAfter(List<E> toInsert, E point) {
        this.innerChain.insertAfter(toInsert, (List<E>)point);
    }

    @Override
    public void insertAfter(Chain<E> toInsert, E point) {
        this.innerChain.insertAfter(toInsert, point);
    }

    @Override
    public void insertBefore(List<E> toInsert, E point) {
        LinkedList<E> backwardList = new LinkedList<E>();
        Iterator<E> it = toInsert.iterator();
        while (it.hasNext()) {
            backwardList.addFirst(it.next());
        }
        Object previousPoint = point;
        for (Unit o : backwardList) {
            this.insertBeforeNoRedirect(o, previousPoint);
            previousPoint = o;
        }
        point.redirectJumpsToThisTo((Unit)toInsert.get(0));
    }

    @Override
    public void insertBefore(Chain<E> toInsert, E point) {
        LinkedList<E> backwardList = new LinkedList<E>();
        Iterator<E> it = toInsert.iterator();
        while (it.hasNext()) {
            backwardList.addFirst(it.next());
        }
        Object previousPoint = point;
        for (Unit o : backwardList) {
            this.insertBefore((E)o, (E)previousPoint);
            previousPoint = o;
        }
    }

    @Override
    public void insertBefore(E toInsert, E point) {
        point.redirectJumpsToThisTo((Unit)toInsert);
        this.innerChain.insertBefore(toInsert, point);
    }

    public void insertBeforeNoRedirect(E toInsert, E point) {
        this.innerChain.insertBefore(toInsert, point);
    }

    @Override
    public boolean follows(E a, E b) {
        return this.innerChain.follows(a, b);
    }

    @Override
    public boolean remove(Object obj) {
        boolean res = false;
        if (this.contains(obj)) {
            Unit successor = this.getSuccOf((E)((Unit)obj));
            if (successor == null) {
                successor = this.getPredOf((E)((Unit)obj));
            }
            res = this.innerChain.remove(obj);
            ((Unit)obj).redirectJumpsToThisTo(successor);
        }
        return res;
    }

    @Override
    public boolean contains(Object u) {
        return this.innerChain.contains(u);
    }

    @Override
    public void addFirst(E u) {
        this.innerChain.addFirst(u);
    }

    @Override
    public void addLast(E u) {
        this.innerChain.addLast(u);
    }

    @Override
    public void removeFirst() {
        this.remove(this.innerChain.getFirst());
    }

    @Override
    public void removeLast() {
        this.remove(this.innerChain.getLast());
    }

    @Override
    public E getFirst() {
        return (E)((Unit)this.innerChain.getFirst());
    }

    @Override
    public E getLast() {
        return (E)((Unit)this.innerChain.getLast());
    }

    @Override
    public E getSuccOf(E point) {
        return (E)((Unit)this.innerChain.getSuccOf(point));
    }

    @Override
    public E getPredOf(E point) {
        return (E)((Unit)this.innerChain.getPredOf(point));
    }

    @Override
    public Iterator<E> snapshotIterator() {
        ArrayList l = new ArrayList();
        l.addAll(this);
        return l.iterator();
    }

    @Override
    public Iterator<E> iterator() {
        return new PatchingIterator(this.innerChain);
    }

    @Override
    public Iterator<E> iterator(E u) {
        return new PatchingIterator(this, this.innerChain, u);
    }

    @Override
    public Iterator<E> iterator(E head, E tail) {
        return new PatchingIterator(this, this.innerChain, head, tail);
    }

    @Override
    public int size() {
        return this.innerChain.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PatchingIterator
    implements Iterator<E> {
        protected Iterator<E> innerIterator;
        protected E lastObject;
        protected boolean state;

        protected PatchingIterator(Chain<E> innerChain) {
            this.innerIterator = null;
            this.state = false;
            this.innerIterator = innerChain.iterator();
        }

        protected PatchingIterator(Chain<E> innerChain, E u) {
            this.innerIterator = null;
            this.state = false;
            this.innerIterator = innerChain.iterator(u);
        }

        protected PatchingIterator(Chain<E> innerChain, E head, E tail) {
            this.innerIterator = null;
            this.state = false;
            this.innerIterator = innerChain.iterator(head, tail);
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public E next() {
            this.lastObject = (Unit)this.innerIterator.next();
            this.state = true;
            return this.lastObject;
        }

        @Override
        public void remove() {
            if (!this.state) {
                throw new IllegalStateException("remove called before first next() call");
            }
            Object successor = PatchingChain.this.getSuccOf(this.lastObject);
            if (successor == null) {
                successor = PatchingChain.this.getPredOf(this.lastObject);
            }
            this.innerIterator.remove();
            this.lastObject.redirectJumpsToThisTo((Unit)successor);
        }
    }
}

