/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import soot.G;
import soot.Value;
import soot.coffi.cp_info;
import soot.jimple.StringConstant;

public class CONSTANT_Utf8_info
extends cp_info {
    private final String s;
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public CONSTANT_Utf8_info(DataInputStream d) throws IOException {
        this.s = DataInputStream.readUTF(d);
    }

    public void writeBytes(DataOutputStream dd) throws IOException {
        dd.writeUTF(this.s);
    }

    public int length() {
        return this.s.getBytes(utf8Charset).length;
    }

    public int size() {
        return this.length() + 3;
    }

    public String toString() {
        return this.s;
    }

    public String convert() {
        return this.s;
    }

    public boolean equals(CONSTANT_Utf8_info cu) {
        return cu.s.equals(this.s);
    }

    public int compareTo(cp_info[] constant_pool, cp_info cp, cp_info[] cp_constant_pool) {
        return this.compareTo(cp);
    }

    public int compareTo(cp_info cp) {
        if (this.tag != cp.tag) {
            return this.tag - cp.tag;
        }
        CONSTANT_Utf8_info cu = (CONSTANT_Utf8_info)cp;
        byte[] bytes = this.s.getBytes(utf8Charset);
        byte[] cu_bytes = cu.s.getBytes(utf8Charset);
        G.v().coffi_CONSTANT_Utf8_info_e1.reset(bytes);
        G.v().coffi_CONSTANT_Utf8_info_e2.reset(cu_bytes);
        while (G.v().coffi_CONSTANT_Utf8_info_e1.hasMoreElements() && G.v().coffi_CONSTANT_Utf8_info_e2.hasMoreElements()) {
            G.v().coffi_CONSTANT_Utf8_info_e1.nextElement();
            G.v().coffi_CONSTANT_Utf8_info_e2.nextElement();
            if (G.v().coffi_CONSTANT_Utf8_info_e1.c < G.v().coffi_CONSTANT_Utf8_info_e2.c) {
                return -1;
            }
            if (G.v().coffi_CONSTANT_Utf8_info_e2.c >= G.v().coffi_CONSTANT_Utf8_info_e1.c) continue;
            return 1;
        }
        if (G.v().coffi_CONSTANT_Utf8_info_e1.hasMoreElements()) {
            return -1;
        }
        if (G.v().coffi_CONSTANT_Utf8_info_e2.hasMoreElements()) {
            return 1;
        }
        return 0;
    }

    public static byte[] toUtf8(String s) {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(s.length());
            DataOutputStream d = new DataOutputStream(bs);
            d.writeUTF(s);
            return bs.toByteArray();
        }
        catch (IOException e) {
            G.v().out.println("Some sort of IO exception in toUtf8 with " + s);
            return null;
        }
    }

    public String toString(cp_info[] constant_pool) {
        return this.convert();
    }

    public String typeName() {
        return "utf8";
    }

    public Value createJimpleConstantValue(cp_info[] constant_pool) {
        return StringConstant.v(this.convert());
    }
}

