/*
 * Decompiled with CFR 0.152.
 */
package soot.factory;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ProcedureCall;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.util.IdentityKey;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.VoidType;
import soot.factory.ISootType;
import soot.factory.SootFactory;
import soot.javaToJimple.InitialResolver;

public class SootType
implements ISootType {
    public static ISootType v() {
        return SootFactory.v().getSootType();
    }

    public boolean isPrimitive(Type t) {
        return t instanceof PrimType;
    }

    public int getModifier(Flags flags) {
        int modifier = 0;
        if (flags.isPublic()) {
            modifier |= 1;
        }
        if (flags.isPrivate()) {
            modifier |= 2;
        }
        if (flags.isProtected()) {
            modifier |= 4;
        }
        if (flags.isFinal()) {
            modifier |= 0x10;
        }
        if (flags.isStatic()) {
            modifier |= 8;
        }
        if (flags.isNative()) {
            modifier |= 0x100;
        }
        if (flags.isAbstract()) {
            modifier |= 0x400;
        }
        if (flags.isVolatile()) {
            modifier |= 0x40;
        }
        if (flags.isTransient()) {
            modifier |= 0x80;
        }
        if (flags.isSynchronized()) {
            modifier |= 0x20;
        }
        if (flags.isInterface()) {
            modifier |= 0x200;
        }
        if (flags.isStrictFP()) {
            modifier |= 0x800;
        }
        return modifier;
    }

    public Type getSootType(polyglot.types.Type type) {
        if (type == null) {
            throw new RuntimeException("Trying to get soot type for null polyglot type");
        }
        Type sootType = null;
        if (type.isInt()) {
            sootType = IntType.v();
        } else if (type.isArray()) {
            polyglot.types.Type polyglotBase = ((polyglot.types.ArrayType)type).base();
            while (polyglotBase instanceof polyglot.types.ArrayType) {
                polyglotBase = ((polyglot.types.ArrayType)polyglotBase).base();
            }
            Type baseType = this.getSootType(polyglotBase);
            int dims = ((polyglot.types.ArrayType)type).dims();
            sootType = ArrayType.v(baseType, dims);
        } else if (type.isBoolean()) {
            sootType = BooleanType.v();
        } else if (type.isByte()) {
            sootType = ByteType.v();
        } else if (type.isChar()) {
            sootType = CharType.v();
        } else if (type.isDouble()) {
            sootType = DoubleType.v();
        } else if (type.isFloat()) {
            sootType = FloatType.v();
        } else if (type.isLong()) {
            sootType = LongType.v();
        } else if (type.isShort()) {
            sootType = ShortType.v();
        } else if (type.isNull()) {
            sootType = NullType.v();
        } else if (type.isVoid()) {
            sootType = VoidType.v();
        } else if (type.isClass()) {
            String className;
            ClassType classType = (ClassType)type;
            ClassDef classDef = (ClassDef)classType.def();
            if (classType.isNested()) {
                IdentityKey key = new IdentityKey((Object)classDef);
                if (classType.isAnonymous() && InitialResolver.v().getAnonTypeMap().containsKey(key)) {
                    className = InitialResolver.v().getAnonTypeMap().get(key);
                } else if (classType.isLocal() && InitialResolver.v().getLocalTypeMap() != null && InitialResolver.v().getLocalTypeMap().containsKey(key)) {
                    className = InitialResolver.v().getLocalTypeMap().get(key);
                } else {
                    String pkgName = "";
                    if (classType.package_() != null) {
                        pkgName = classType.package_().fullName().toString();
                    }
                    className = classType.name().toString();
                    if (classType.isAnonymous()) {
                        throw new RuntimeException("Compiler Internal Error: Anonymous class should have been processed before");
                    }
                    if (classType.outer().isAnonymous() || classType.outer().isLocal()) {
                        className = this.getSootType((polyglot.types.Type)classType.outer()).toString() + "$" + className;
                    } else {
                        while (classType.outer() != null) {
                            className = classType.outer().name() + "$" + className;
                            classType = classType.outer();
                        }
                        if (!pkgName.equals("")) {
                            className = pkgName + "." + className;
                        }
                    }
                }
            } else {
                className = classType.fullName().toString();
            }
            sootType = RefType.v(className);
        } else {
            throw new RuntimeException("Unknown Type");
        }
        return sootType;
    }

    public List getSootParamsTypes(List polyglotTypes) {
        ArrayList<Type> sootParamsTypes = new ArrayList<Type>();
        for (Object next : polyglotTypes) {
            sootParamsTypes.add(SootType.v().getSootType((polyglot.types.Type)next));
        }
        return sootParamsTypes;
    }

    public List getSootParamsTypes(ProcedureCall call) {
        return this.getSootParamsTypes(call.procedureInstance().formalTypes());
    }
}

