/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import soot.Body;
import soot.Local;
import soot.MethodSource;
import soot.Scene;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.factory.LocalGenerator;
import soot.factory.SootFactory;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;

public class PrivateFieldAccMethodSource
implements MethodSource {
    private final Type fieldType;
    private final String fieldName;
    private final boolean isStatic;

    public PrivateFieldAccMethodSource(Type fieldType, String fieldName, boolean isStatic) {
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    public Body getBody(SootMethod sootMethod, String phaseName) {
        JimpleBody body = Jimple.v().newBody(sootMethod);
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        Local fieldLocal = lg.generateLocal(this.fieldType);
        SootFieldRef field = Scene.v().makeFieldRef(sootMethod.getDeclaringClass(), this.fieldName, this.fieldType, this.isStatic);
        FieldRef fieldRef = null;
        if (this.isStatic) {
            fieldRef = Jimple.v().newStaticFieldRef(field);
        } else {
            Local fieldBase = null;
            assert (sootMethod.getParameterCount() == 1);
            Type sootType = sootMethod.getParameterType(0);
            Local paramLocal = lg.generateLocal(sootType);
            ParameterRef paramRef = Jimple.v().newParameterRef(sootType, 0);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(paramLocal, paramRef);
            body.getUnits().add(stmt);
            fieldBase = paramLocal;
            fieldRef = Jimple.v().newInstanceFieldRef(fieldBase, field);
        }
        AssignStmt assign = Jimple.v().newAssignStmt(fieldLocal, fieldRef);
        body.getUnits().add(assign);
        ReturnStmt retStmt = Jimple.v().newReturnStmt(fieldLocal);
        body.getUnits().add(retStmt);
        return body;
    }
}

