/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import polyglot.ast.Node;
import polyglot.types.ClassType;
import polyglot.util.Position;
import soot.ArrayType;
import soot.Body;
import soot.FastHierarchy;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.ValueBox;
import soot.VoidType;
import soot.factory.LocalGenerator;
import soot.factory.SootType;
import soot.javaToJimple.InitialResolver;
import soot.javaToJimple.PrivateFieldAccMethodSource;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Jimple;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.tagkit.Host;
import soot.tagkit.InnerClassTag;
import soot.tagkit.SourceLineNumberTag;
import soot.tagkit.SourceLnNamePosTag;
import soot.tagkit.SourceLnPosTag;
import soot.tagkit.SourcePositionTag;
import soot.tagkit.SyntheticTag;
import soot.util.SingletonList;
import soot.util.StringTools;

public class Util {
    public static void addInnerClassTag(SootClass sc, String innerName, String outerName, String simpleName, int access) {
        innerName = StringTools.replaceAll(innerName, ".", "/");
        if (outerName != null) {
            outerName = StringTools.replaceAll(outerName, ".", "/");
        }
        sc.addTag(new InnerClassTag(innerName, outerName, simpleName, access));
    }

    public static String getParamNameForClassLit(polyglot.types.Type type) {
        String name = "";
        if (type.isArray()) {
            int dims = ((polyglot.types.ArrayType)type).dims();
            polyglot.types.Type arrType = ((polyglot.types.ArrayType)type).base();
            while (arrType instanceof polyglot.types.ArrayType) {
                arrType = ((polyglot.types.ArrayType)arrType).base();
            }
            String fieldName = "";
            if (arrType.isBoolean()) {
                fieldName = "Z";
            } else if (arrType.isByte()) {
                fieldName = "B";
            } else if (arrType.isChar()) {
                fieldName = "C";
            } else if (arrType.isDouble()) {
                fieldName = "D";
            } else if (arrType.isFloat()) {
                fieldName = "F";
            } else if (arrType.isInt()) {
                fieldName = "I";
            } else if (arrType.isLong()) {
                fieldName = "J";
            } else if (arrType.isShort()) {
                fieldName = "S";
            } else {
                String typeSt = SootType.v().getSootType(arrType).toString();
                fieldName = "L" + typeSt;
            }
            for (int i = 0; i < dims; ++i) {
                name = name + "[";
            }
            name = name + fieldName;
            if (!arrType.isPrimitive()) {
                name = name + ";";
            }
        } else {
            name = SootType.v().getSootType(type).toString();
        }
        return name;
    }

    public static String getFieldNameForClassLit(polyglot.types.Type type) {
        String fieldName = "";
        if (type.isArray()) {
            int dims = ((polyglot.types.ArrayType)type).dims();
            polyglot.types.Type arrType = ((polyglot.types.ArrayType)type).base();
            while (arrType instanceof polyglot.types.ArrayType) {
                arrType = ((polyglot.types.ArrayType)arrType).base();
            }
            fieldName = "array$";
            for (int i = 0; i < dims - 1; ++i) {
                fieldName = fieldName + "$";
            }
            if (arrType.isBoolean()) {
                fieldName = fieldName + "Z";
            } else if (arrType.isByte()) {
                fieldName = fieldName + "B";
            } else if (arrType.isChar()) {
                fieldName = fieldName + "C";
            } else if (arrType.isDouble()) {
                fieldName = fieldName + "D";
            } else if (arrType.isFloat()) {
                fieldName = fieldName + "F";
            } else if (arrType.isInt()) {
                fieldName = fieldName + "I";
            } else if (arrType.isLong()) {
                fieldName = fieldName + "J";
            } else if (arrType.isShort()) {
                fieldName = fieldName + "S";
            } else {
                String typeSt = SootType.v().getSootType(arrType).toString();
                typeSt = StringTools.replaceAll(typeSt, ".", "$");
                fieldName = fieldName + "L" + typeSt;
            }
        } else {
            fieldName = "class$";
            String typeSt = SootType.v().getSootType(type).toString();
            typeSt = StringTools.replaceAll(typeSt, ".", "$");
            fieldName = fieldName + typeSt;
        }
        return fieldName;
    }

    public static String getSourceFileOfClass(SootClass sootClass) {
        String name = sootClass.getName();
        int index = name.indexOf("$");
        if (index != -1) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static void addLnPosTags(Host host, Position pos) {
        if (pos != null && Options.v().keep_line_number()) {
            if (pos.file() != null) {
                host.addTag(new SourceLnNamePosTag(pos.file(), pos.line(), pos.endLine(), pos.column(), pos.endColumn()));
            } else {
                host.addTag(new SourceLnPosTag(pos.line(), pos.endLine(), pos.column(), pos.endColumn()));
            }
        }
    }

    public static void addLnPosTags(Host host, int sline, int eline, int spos, int epos) {
        if (Options.v().keep_line_number()) {
            host.addTag(new SourceLnPosTag(sline, eline, spos, epos));
        }
    }

    public static void addPosTag(Host host, Position pos) {
        if (pos != null) {
            Util.addPosTag(host, pos.column(), pos.endColumn());
        }
    }

    public static void addMethodPosTag(Host meth, int start, int end) {
        meth.addTag(new SourcePositionTag(start, end));
    }

    public static void addPosTag(Host host, int sc, int ec) {
        host.addTag(new SourcePositionTag(sc, ec));
    }

    public static void addMethodLineTag(Host host, int sline, int eline) {
        if (Options.v().keep_line_number()) {
            host.addTag(new SourceLineNumberTag(sline, eline));
        }
    }

    public static void addLineTag(Host host, Node node) {
        if (Options.v().keep_line_number() && node.position() != null) {
            host.addTag(new SourceLineNumberTag(node.position().line(), node.position().line()));
        }
    }

    public static void addLineTag(Host host, int sLine, int eLine) {
        host.addTag(new SourceLineNumberTag(sLine, eLine));
    }

    public static Local getThis(Type sootType, Body body, HashMap getThisMap, LocalGenerator lg) {
        if (InitialResolver.v().hierarchy() == null) {
            InitialResolver.v().hierarchy(new FastHierarchy());
        }
        FastHierarchy fh = InitialResolver.v().hierarchy();
        Local specialThisLocal = body.getThisLocal();
        if (specialThisLocal.getType().equals(sootType)) {
            getThisMap.put(sootType, specialThisLocal);
            return specialThisLocal;
        }
        if (Util.bodyHasLocal(body, sootType)) {
            Local l = Util.getLocalOfType(body, sootType);
            getThisMap.put(sootType, l);
            return l;
        }
        SootClass classToInvoke = ((RefType)specialThisLocal.getType()).getSootClass();
        SootField outerThisField = classToInvoke.getFieldByName("this$0");
        Local t1 = lg.generateLocal(outerThisField.getType());
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(specialThisLocal, outerThisField.makeRef());
        AssignStmt fieldAssignStmt = Jimple.v().newAssignStmt(t1, fieldRef);
        body.getUnits().add(fieldAssignStmt);
        if (fh.canStoreType(t1.getType(), sootType)) {
            getThisMap.put(sootType, t1);
            return t1;
        }
        Local t2 = t1;
        return Util.getThisGivenOuter(sootType, getThisMap, body, lg, t2);
    }

    private static Local getLocalOfType(Body body, Type type) {
        FastHierarchy fh = InitialResolver.v().hierarchy();
        Iterator<Unit> stmtsIt = body.getUnits().iterator();
        Local correctLocal = null;
        while (stmtsIt.hasNext()) {
            Stmt s = (Stmt)stmtsIt.next();
            if (!(s instanceof IdentityStmt) || !s.hasTag("EnclosingTag") && !s.hasTag("QualifyingTag")) continue;
            for (ValueBox vb : s.getDefBoxes()) {
                if (!(vb.getValue() instanceof Local) || !fh.canStoreType(type, vb.getValue().getType())) continue;
                correctLocal = (Local)vb.getValue();
            }
        }
        return correctLocal;
    }

    private static boolean bodyHasLocal(Body body, Type type) {
        FastHierarchy fh = InitialResolver.v().hierarchy();
        for (Stmt stmt : body.getUnits()) {
            if (!(stmt instanceof IdentityStmt) || !stmt.hasTag("EnclosingTag") && !stmt.hasTag("QualifyingTag")) continue;
            for (ValueBox vb : stmt.getDefBoxes()) {
                if (!(vb.getValue() instanceof Local) || !fh.canStoreType(type, vb.getValue().getType())) continue;
                return true;
            }
        }
        return false;
    }

    public static Local getThisGivenOuter(Type sootType, HashMap getThisMap, Body body, LocalGenerator lg, Local t2) {
        if (InitialResolver.v().hierarchy() == null) {
            InitialResolver.v().hierarchy(new FastHierarchy());
        }
        FastHierarchy fh = InitialResolver.v().hierarchy();
        while (!fh.canStoreType(t2.getType(), sootType)) {
            SootClass classToInvoke = ((RefType)t2.getType()).getSootClass();
            SootMethod methToInvoke = Util.makeOuterThisAccessMethod(classToInvoke);
            Local t3 = lg.generateLocal(methToInvoke.getReturnType());
            ArrayList<Local> methParams = new ArrayList<Local>();
            methParams.add(t2);
            Local res = Util.getPrivateAccessFieldInvoke(methToInvoke.makeRef(), methParams, body, lg);
            AssignStmt assign = Jimple.v().newAssignStmt(t3, res);
            body.getUnits().add(assign);
            t2 = t3;
        }
        getThisMap.put(sootType, t2);
        return t2;
    }

    private static SootMethod makeOuterThisAccessMethod(SootClass classToInvoke) {
        String name = "access$" + InitialResolver.v().getNextPrivateAccessCounter() + "00";
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(classToInvoke.getType());
        SootMethod meth = new SootMethod(name, paramTypes, classToInvoke.getFieldByName("this$0").getType(), 8);
        classToInvoke.addMethod(meth);
        PrivateFieldAccMethodSource src = new PrivateFieldAccMethodSource(classToInvoke.getFieldByName("this$0").getType(), "this$0", classToInvoke.getFieldByName("this$0").isStatic());
        meth.setActiveBody(src.getBody(meth, null));
        meth.addTag(new SyntheticTag());
        return meth;
    }

    public static Local getPrivateAccessFieldInvoke(SootMethodRef toInvoke, ArrayList params, Body body, LocalGenerator lg) {
        StaticInvokeExpr invoke = Jimple.v().newStaticInvokeExpr(toInvoke, params);
        Local retLocal = lg.generateLocal(toInvoke.returnType());
        AssignStmt stmt = Jimple.v().newAssignStmt(retLocal, invoke);
        body.getUnits().add(stmt);
        return retLocal;
    }

    public static boolean isSubType(ClassType type, ClassType superType) {
        if (type.typeEquals((polyglot.types.Type)superType, null)) {
            return true;
        }
        if (type.superClass() == null) {
            return false;
        }
        return Util.isSubType((ClassType)type.superClass(), superType);
    }

    public static boolean isInstance(SootClass currentClass, SootClass typeClass) {
        while (!typeClass.getName().contentEquals(currentClass.getName())) {
            if (currentClass.hasSuperclass()) {
                currentClass = currentClass.getSuperclass();
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isInstance(SootClass currentClass, String typeClass) {
        return typeClass.equals(currentClass.getName());
    }

    public static SootField getFieldFromCH(SootClass sc, String name, Type type) {
        sc.checkLevel(2);
        for (SootField field : sc.getFields()) {
            if (!field.getName().equals(name) || !field.getType().equals(type)) continue;
            return field;
        }
        if (sc.hasSuperclass()) {
            return Util.getFieldFromCH(sc.getSuperclass(), name, type);
        }
        throw new RuntimeException("Class " + sc.getName() + " doesn't have field " + name + " type:" + type);
    }

    public static boolean declaresMainMethod(SootClass c) {
        SingletonList mainParamList = new SingletonList(ArrayType.v(RefType.v("java.lang.String"), 1));
        if (c.declaresMethod("main", mainParamList, VoidType.v())) {
            SootMethod m = c.getMethod("main", mainParamList, VoidType.v());
            return m.isStatic() && m.isPublic();
        }
        return false;
    }
}

