/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.Iterator;
import java.util.List;
import soot.SootMethodRef;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.VirtualInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.JimpleToBafContext;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.tagkit.Tag;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVirtualInvokeExpr
extends AbstractInstanceInvokeExpr
implements VirtualInvokeExpr,
ConvertToBaf {
    protected AbstractVirtualInvokeExpr(ValueBox baseBox, SootMethodRef methodRef, ValueBox[] argBoxes) {
        if (methodRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.baseBox = baseBox;
        this.methodRef = methodRef;
        this.argBoxes = argBoxes;
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractVirtualInvokeExpr) {
            AbstractVirtualInvokeExpr ie = (AbstractVirtualInvokeExpr)o;
            if (!this.baseBox.getValue().equivTo(ie.baseBox.getValue()) || !this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            int i = 0;
            for (ValueBox element : this.argBoxes) {
                if (!element.getValue().equivTo(ie.getArg(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.baseBox.getValue().equivHashCode() * 101 + this.getMethod().equivHashCode() * 17;
    }

    @Override
    public abstract Object clone();

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseVirtualInvokeExpr(this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("virtualinvoke " + this.baseBox.getValue().toString() + "." + this.methodRef.getSignature() + "(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("virtualinvoke");
        up.literal(" ");
        this.baseBox.toString(up);
        up.literal(".");
        up.methodRef(this.methodRef);
        up.literal("(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(")");
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ((ConvertToBaf)((Object)this.getBase())).convertToBaf(context, out);
        for (ValueBox element : this.argBoxes) {
            ((ConvertToBaf)((Object)element.getValue())).convertToBaf(context, out);
        }
        VirtualInvokeInst u = Baf.v().newVirtualInvokeInst(this.methodRef);
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator<Tag> it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }
}

