/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.Iterator;
import java.util.List;
import soot.IntType;
import soot.Local;
import soot.Unit;
import soot.UnitBoxOwner;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.ArrayWriteInst;
import soot.baf.Baf;
import soot.baf.FieldPutInst;
import soot.baf.IncInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AddExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.Constant;
import soot.jimple.ConvertToBaf;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StaticFieldRef;
import soot.jimple.StmtSwitch;
import soot.jimple.SubExpr;
import soot.jimple.internal.AbstractDefinitionStmt;
import soot.jimple.internal.RValueBox;
import soot.jimple.internal.VariableBox;
import soot.tagkit.Tag;
import soot.util.SingletonList;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAssignStmt
extends AbstractDefinitionStmt
implements AssignStmt {
    public JAssignStmt(Value variable, Value rvalue) {
        this.leftBox = new LinkedVariableBox(variable);
        this.rightBox = new LinkedRValueBox(rvalue);
        ((LinkedVariableBox)this.leftBox).setOtherBox(this.rightBox);
        ((LinkedRValueBox)this.rightBox).setOtherBox(this.leftBox);
        if (!this.leftBox.canContainValue(variable) || !this.rightBox.canContainValue(rvalue)) {
            throw new RuntimeException("Illegal assignment statement.  Make sure that either left side or right hand side has a local or constant.");
        }
        this.defBoxes = new SingletonList(this.leftBox);
    }

    protected JAssignStmt(ValueBox variableBox, ValueBox rvalueBox) {
        this.leftBox = variableBox;
        this.rightBox = rvalueBox;
        this.defBoxes = new SingletonList(this.leftBox);
    }

    @Override
    public boolean containsInvokeExpr() {
        return this.rightBox.getValue() instanceof InvokeExpr;
    }

    @Override
    public InvokeExpr getInvokeExpr() {
        if (!this.containsInvokeExpr()) {
            throw new RuntimeException("getInvokeExpr() called with no invokeExpr present!");
        }
        return (InvokeExpr)this.rightBox.getValue();
    }

    @Override
    public ValueBox getInvokeExprBox() {
        if (!this.containsInvokeExpr()) {
            throw new RuntimeException("getInvokeExpr() called with no invokeExpr present!");
        }
        return this.rightBox;
    }

    @Override
    public boolean containsArrayRef() {
        return this.leftBox.getValue() instanceof ArrayRef || this.rightBox.getValue() instanceof ArrayRef;
    }

    @Override
    public ArrayRef getArrayRef() {
        if (!this.containsArrayRef()) {
            throw new RuntimeException("getArrayRef() called with no ArrayRef present!");
        }
        if (this.leftBox.getValue() instanceof ArrayRef) {
            return (ArrayRef)this.leftBox.getValue();
        }
        return (ArrayRef)this.rightBox.getValue();
    }

    @Override
    public ValueBox getArrayRefBox() {
        if (!this.containsArrayRef()) {
            throw new RuntimeException("getArrayRefBox() called with no ArrayRef present!");
        }
        if (this.leftBox.getValue() instanceof ArrayRef) {
            return this.leftBox;
        }
        return this.rightBox;
    }

    @Override
    public boolean containsFieldRef() {
        return this.leftBox.getValue() instanceof FieldRef || this.rightBox.getValue() instanceof FieldRef;
    }

    @Override
    public FieldRef getFieldRef() {
        if (!this.containsFieldRef()) {
            throw new RuntimeException("getFieldRef() called with no FieldRef present!");
        }
        if (this.leftBox.getValue() instanceof FieldRef) {
            return (FieldRef)this.leftBox.getValue();
        }
        return (FieldRef)this.rightBox.getValue();
    }

    @Override
    public ValueBox getFieldRefBox() {
        if (!this.containsFieldRef()) {
            throw new RuntimeException("getFieldRefBox() called with no FieldRef present!");
        }
        if (this.leftBox.getValue() instanceof FieldRef) {
            return this.leftBox;
        }
        return this.rightBox;
    }

    @Override
    public List getUnitBoxes() {
        Value rValue = this.rightBox.getValue();
        if (rValue instanceof UnitBoxOwner) {
            return ((UnitBoxOwner)((Object)rValue)).getUnitBoxes();
        }
        return super.getUnitBoxes();
    }

    public String toString() {
        return this.leftBox.getValue().toString() + " = " + this.rightBox.getValue().toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        this.leftBox.toString(up);
        up.literal(" = ");
        this.rightBox.toString(up);
    }

    @Override
    public Object clone() {
        return new JAssignStmt(Jimple.v().cloneIfNecessary(this.getLeftOp()), Jimple.v().cloneIfNecessary(this.getRightOp()));
    }

    @Override
    public void setLeftOp(Value variable) {
        this.leftBox.setValue(variable);
    }

    @Override
    public void setRightOp(Value rvalue) {
        this.rightBox.setValue(rvalue);
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseAssignStmt(this);
    }

    @Override
    public void convertToBaf(final JimpleToBafContext context, final List<Unit> out) {
        Value lvalue = this.getLeftOp();
        final Value rvalue = this.getRightOp();
        if (lvalue instanceof Local && (rvalue instanceof AddExpr || rvalue instanceof SubExpr)) {
            Local l = (Local)lvalue;
            BinopExpr expr = (BinopExpr)rvalue;
            Value op1 = expr.getOp1();
            Value op2 = expr.getOp2();
            if (l.getType().equals(IntType.v())) {
                boolean isValidCase = false;
                int x = 0;
                if (op1 == l && op2 instanceof IntConstant) {
                    x = ((IntConstant)op2).value;
                    isValidCase = true;
                } else if (expr instanceof AddExpr && op2 == l && op1 instanceof IntConstant) {
                    x = ((IntConstant)op1).value;
                    isValidCase = true;
                }
                if (isValidCase && x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                    IncInst u = Baf.v().newIncInst(context.getBafLocalOfJimpleLocal(l), IntConstant.v(expr instanceof AddExpr ? x : -x));
                    out.add(u);
                    Iterator<Tag> it = this.getTags().iterator();
                    while (it.hasNext()) {
                        u.addTag(it.next());
                    }
                    return;
                }
            }
        }
        context.setCurrentUnit(this);
        lvalue.apply(new AbstractJimpleValueSwitch(){

            public void caseArrayRef(ArrayRef v) {
                ((ConvertToBaf)((Object)v.getBase())).convertToBaf(context, out);
                ((ConvertToBaf)((Object)v.getIndex())).convertToBaf(context, out);
                ((ConvertToBaf)((Object)rvalue)).convertToBaf(context, out);
                ArrayWriteInst u = Baf.v().newArrayWriteInst(v.getType());
                Iterator<Tag> it = JAssignStmt.this.getTags().iterator();
                while (it.hasNext()) {
                    u.addTag(it.next());
                }
                out.add(u);
            }

            public void caseInstanceFieldRef(InstanceFieldRef v) {
                ((ConvertToBaf)((Object)v.getBase())).convertToBaf(context, out);
                ((ConvertToBaf)((Object)rvalue)).convertToBaf(context, out);
                FieldPutInst u = Baf.v().newFieldPutInst(v.getFieldRef());
                Iterator<Tag> it = JAssignStmt.this.getTags().iterator();
                while (it.hasNext()) {
                    u.addTag(it.next());
                }
                out.add(u);
            }

            public void caseLocal(Local v) {
                ((ConvertToBaf)((Object)rvalue)).convertToBaf(context, out);
                StoreInst u = Baf.v().newStoreInst(v.getType(), context.getBafLocalOfJimpleLocal(v));
                Iterator<Tag> it = JAssignStmt.this.getTags().iterator();
                while (it.hasNext()) {
                    u.addTag(it.next());
                }
                out.add(u);
            }

            public void caseStaticFieldRef(StaticFieldRef v) {
                ((ConvertToBaf)((Object)rvalue)).convertToBaf(context, out);
                StaticPutInst u = Baf.v().newStaticPutInst(v.getFieldRef());
                Iterator<Tag> it = JAssignStmt.this.getTags().iterator();
                while (it.hasNext()) {
                    u.addTag(it.next());
                }
                out.add(u);
            }
        });
    }

    private class LinkedRValueBox
    extends RValueBox {
        ValueBox otherBox;

        private LinkedRValueBox(Value v) {
            super(v);
            this.otherBox = null;
        }

        public void setOtherBox(ValueBox otherBox) {
            this.otherBox = otherBox;
        }

        public boolean canContainValue(Value v) {
            if (this.otherBox == null) {
                return super.canContainValue(v);
            }
            Value other = this.otherBox.getValue();
            return super.canContainValue(v) && (v instanceof Local || v instanceof Constant || other instanceof Local || other instanceof Constant);
        }
    }

    private class LinkedVariableBox
    extends VariableBox {
        ValueBox otherBox;

        private LinkedVariableBox(Value v) {
            super(v);
            this.otherBox = null;
        }

        public void setOtherBox(ValueBox otherBox) {
            this.otherBox = otherBox;
        }

        public boolean canContainValue(Value v) {
            if (this.otherBox == null) {
                return super.canContainValue(v);
            }
            Value other = this.otherBox.getValue();
            return super.canContainValue(v) && (v instanceof Local || v instanceof Constant || other instanceof Local || other instanceof Constant);
        }
    }
}

