/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.IdentityInst;
import soot.baf.StoreInst;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.ParameterRef;
import soot.jimple.StmtSwitch;
import soot.jimple.ThisRef;
import soot.jimple.internal.AbstractDefinitionStmt;
import soot.tagkit.Tag;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIdentityStmt
extends AbstractDefinitionStmt
implements IdentityStmt {
    public JIdentityStmt(Value local, Value identityValue) {
        this(Jimple.v().newLocalBox(local), Jimple.v().newIdentityRefBox(identityValue));
    }

    protected JIdentityStmt(ValueBox localBox, ValueBox identityValueBox) {
        this.leftBox = localBox;
        this.rightBox = identityValueBox;
        this.defBoxes = Collections.singletonList(this.leftBox);
    }

    @Override
    public Object clone() {
        return new JIdentityStmt(Jimple.v().cloneIfNecessary(this.getLeftOp()), Jimple.v().cloneIfNecessary(this.getRightOp()));
    }

    public String toString() {
        return this.leftBox.getValue().toString() + " := " + this.rightBox.getValue().toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        this.leftBox.toString(up);
        up.literal(" := ");
        this.rightBox.toString(up);
    }

    public void setLeftOp(Value local) {
        this.leftBox.setValue(local);
    }

    public void setRightOp(Value identityRef) {
        this.rightBox.setValue(identityRef);
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseIdentityStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        IdentityRef newRhs;
        Value currentRhs = this.getRightOp();
        if (currentRhs instanceof ThisRef) {
            newRhs = Baf.v().newThisRef((RefType)((ThisRef)currentRhs).getType());
        } else if (currentRhs instanceof ParameterRef) {
            newRhs = Baf.v().newParameterRef(((ParameterRef)currentRhs).getType(), ((ParameterRef)currentRhs).getIndex());
        } else {
            if (currentRhs instanceof CaughtExceptionRef) {
                StoreInst u = Baf.v().newStoreInst(RefType.v(), context.getBafLocalOfJimpleLocal((Local)this.getLeftOp()));
                out.add(u);
                Iterator<Tag> it = this.getTags().iterator();
                while (it.hasNext()) {
                    u.addTag(it.next());
                }
                return;
            }
            throw new RuntimeException("Don't know how to convert unknown rhs");
        }
        IdentityInst u = Baf.v().newIdentityInst(context.getBafLocalOfJimpleLocal((Local)this.getLeftOp()), newRhs);
        out.add(u);
        Iterator<Tag> it = this.getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }
}

