/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.ThrowInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StmtSwitch;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.AbstractStmt;
import soot.tagkit.Tag;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JThrowStmt
extends AbstractStmt
implements ThrowStmt {
    ValueBox opBox;

    public JThrowStmt(Value op) {
        this(Jimple.v().newImmediateBox(op));
    }

    protected JThrowStmt(ValueBox opBox) {
        this.opBox = opBox;
    }

    @Override
    public Object clone() {
        return new JThrowStmt(Jimple.v().cloneIfNecessary(this.getOp()));
    }

    @Override
    public ValueBox getOpBox() {
        return this.opBox;
    }

    @Override
    public Value getOp() {
        return this.opBox.getValue();
    }

    @Override
    public void setOp(Value op) {
        this.opBox.setValue(op);
    }

    public String toString() {
        return "throw " + this.opBox.getValue().toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("throw");
        up.literal(" ");
        this.opBox.toString(up);
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.addAll(this.opBox.getValue().getUseBoxes());
        useBoxes.add(this.opBox);
        return useBoxes;
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseThrowStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ((ConvertToBaf)((Object)this.getOp())).convertToBaf(context, out);
        ThrowInst u = Baf.v().newThrowInst();
        out.add(u);
        JThrowStmt currentUnit = this;
        Iterator<Tag> it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public boolean branches() {
        return false;
    }
}

