/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.builder;

import soot.ArrayType;
import soot.Local;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.MethodPAG;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.Parm;
import soot.jimple.spark.pag.VarNode;
import soot.shimple.AbstractShimpleValueSwitch;
import soot.shimple.PhiExpr;
import soot.toolkits.scalar.Pair;

public class MethodNodeFactory
extends AbstractShimpleValueSwitch {
    protected PAG pag;
    protected MethodPAG mpag;
    protected SootMethod method;

    public MethodNodeFactory(PAG pag, MethodPAG mpag) {
        this.pag = pag;
        this.mpag = mpag;
        this.setCurrentMethod(mpag.getMethod());
    }

    private void setCurrentMethod(SootMethod m) {
        this.method = m;
        if (!m.isStatic()) {
            SootClass c = m.getDeclaringClass();
            if (c == null) {
                throw new RuntimeException("Method " + m + " has no declaring class");
            }
            this.caseThis();
        }
        for (int i = 0; i < m.getParameterCount(); ++i) {
            if (!(m.getParameterType(i) instanceof RefLikeType)) continue;
            this.caseParm(i);
        }
        Type retType = m.getReturnType();
        if (retType instanceof RefLikeType) {
            this.caseRet();
        }
    }

    public Node getNode(Value v) {
        v.apply(this);
        return this.getNode();
    }

    public final void handleStmt(Stmt s) {
        if (s.containsInvokeExpr()) {
            return;
        }
        s.apply(new AbstractStmtSwitch(){

            public final void caseAssignStmt(AssignStmt as) {
                Value l = as.getLeftOp();
                Value r = as.getRightOp();
                if (!(l.getType() instanceof RefLikeType)) {
                    return;
                }
                l.apply(MethodNodeFactory.this);
                Node dest = MethodNodeFactory.this.getNode();
                r.apply(MethodNodeFactory.this);
                Node src = MethodNodeFactory.this.getNode();
                if (l instanceof InstanceFieldRef) {
                    ((InstanceFieldRef)l).getBase().apply(MethodNodeFactory.this);
                    MethodNodeFactory.this.pag.addDereference((VarNode)MethodNodeFactory.this.getNode());
                }
                if (r instanceof InstanceFieldRef) {
                    ((InstanceFieldRef)r).getBase().apply(MethodNodeFactory.this);
                    MethodNodeFactory.this.pag.addDereference((VarNode)MethodNodeFactory.this.getNode());
                }
                if (r instanceof StaticFieldRef) {
                    StaticFieldRef sfr = (StaticFieldRef)r;
                    SootFieldRef s = sfr.getFieldRef();
                    if (MethodNodeFactory.this.pag.getOpts().empties_as_allocs()) {
                        if (s.declaringClass().getName().equals("java.util.Collections")) {
                            if (s.name().equals("EMPTY_SET")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(RefType.v("java.util.HashSet"), RefType.v("java.util.HashSet"), MethodNodeFactory.this.method);
                            } else if (s.name().equals("EMPTY_MAP")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(RefType.v("java.util.HashMap"), RefType.v("java.util.HashMap"), MethodNodeFactory.this.method);
                            } else if (s.name().equals("EMPTY_LIST")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(RefType.v("java.util.LinkedList"), RefType.v("java.util.LinkedList"), MethodNodeFactory.this.method);
                            }
                        } else if (s.declaringClass().getName().equals("java.util.Hashtable")) {
                            if (s.name().equals("emptyIterator")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(RefType.v("java.util.Hashtable$EmptyIterator"), RefType.v("java.util.Hashtable$EmptyIterator"), MethodNodeFactory.this.method);
                            } else if (s.name().equals("emptyEnumerator")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(RefType.v("java.util.Hashtable$EmptyEnumerator"), RefType.v("java.util.Hashtable$EmptyEnumerator"), MethodNodeFactory.this.method);
                            }
                        }
                    }
                }
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            public final void caseReturnStmt(ReturnStmt rs) {
                if (!(rs.getOp().getType() instanceof RefLikeType)) {
                    return;
                }
                rs.getOp().apply(MethodNodeFactory.this);
                Node retNode = MethodNodeFactory.this.getNode();
                MethodNodeFactory.this.mpag.addInternalEdge(retNode, MethodNodeFactory.this.caseRet());
            }

            public final void caseIdentityStmt(IdentityStmt is) {
                if (!(is.getLeftOp().getType() instanceof RefLikeType)) {
                    return;
                }
                is.getLeftOp().apply(MethodNodeFactory.this);
                Node dest = MethodNodeFactory.this.getNode();
                is.getRightOp().apply(MethodNodeFactory.this);
                Node src = MethodNodeFactory.this.getNode();
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            public final void caseThrowStmt(ThrowStmt ts) {
                ts.getOp().apply(MethodNodeFactory.this);
                MethodNodeFactory.this.mpag.addOutEdge(MethodNodeFactory.this.getNode(), MethodNodeFactory.this.pag.nodeFactory().caseThrow());
            }
        });
    }

    public final Node getNode() {
        return (Node)this.getResult();
    }

    public final Node caseThis() {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Pair<SootMethod, String>(this.method, "THIS_NODE"), this.method.getDeclaringClass().getType(), this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public final Node caseParm(int index) {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Pair<SootMethod, Integer>(this.method, new Integer(index)), this.method.getParameterType(index), this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public final void casePhiExpr(PhiExpr e) {
        Pair<PhiExpr, String> phiPair = new Pair<PhiExpr, String>(e, "PHI_NODE");
        LocalVarNode phiNode = this.pag.makeLocalVarNode(phiPair, e.getType(), this.method);
        for (Value op : e.getValues()) {
            op.apply(this);
            Node opNode = this.getNode();
            this.mpag.addInternalEdge(opNode, phiNode);
        }
        this.setResult(phiNode);
    }

    public final Node caseRet() {
        LocalVarNode ret = this.pag.makeLocalVarNode(Parm.v(this.method, -2), this.method.getReturnType(), this.method);
        ret.setInterProcSource();
        return ret;
    }

    public final Node caseArray(VarNode base) {
        return this.pag.makeFieldRefNode(base, ArrayElement.v());
    }

    public final void caseArrayRef(ArrayRef ar) {
        this.caseLocal((Local)ar.getBase());
        this.setResult(this.caseArray((VarNode)this.getNode()));
    }

    public final void caseCastExpr(CastExpr ce) {
        Pair<CastExpr, String> castPair = new Pair<CastExpr, String>(ce, "CAST_NODE");
        ce.getOp().apply(this);
        Node opNode = this.getNode();
        LocalVarNode castNode = this.pag.makeLocalVarNode(castPair, ce.getCastType(), this.method);
        this.mpag.addInternalEdge(opNode, castNode);
        this.setResult(castNode);
    }

    public final void caseCaughtExceptionRef(CaughtExceptionRef cer) {
        this.setResult(this.pag.nodeFactory().caseThrow());
    }

    public final void caseInstanceFieldRef(InstanceFieldRef ifr) {
        if (this.pag.getOpts().field_based() || this.pag.getOpts().vta()) {
            this.setResult(this.pag.makeGlobalVarNode(ifr.getField(), ifr.getField().getType()));
        } else {
            this.setResult(this.pag.makeLocalFieldRefNode(ifr.getBase(), ifr.getBase().getType(), ifr.getField(), this.method));
        }
    }

    public final void caseLocal(Local l) {
        this.setResult(this.pag.makeLocalVarNode(l, l.getType(), this.method));
    }

    public final void caseNewArrayExpr(NewArrayExpr nae) {
        this.setResult(this.pag.makeAllocNode(nae, nae.getType(), this.method));
    }

    private boolean isStringBuffer(Type t) {
        if (!(t instanceof RefType)) {
            return false;
        }
        RefType rt = (RefType)t;
        String s = rt.toString();
        if (s.equals("java.lang.StringBuffer")) {
            return true;
        }
        return s.equals("java.lang.StringBuilder");
    }

    public final void caseNewExpr(NewExpr ne) {
        if (this.pag.getOpts().merge_stringbuffer() && this.isStringBuffer(ne.getType())) {
            this.setResult(this.pag.makeAllocNode(ne.getType(), ne.getType(), null));
        } else {
            this.setResult(this.pag.makeAllocNode(ne, ne.getType(), this.method));
        }
    }

    public final void caseNewMultiArrayExpr(NewMultiArrayExpr nmae) {
        Type t;
        ArrayType type = (ArrayType)nmae.getType();
        AllocNode prevAn = this.pag.makeAllocNode(new Pair<NewMultiArrayExpr, Integer>(nmae, new Integer(type.numDimensions)), type, this.method);
        LocalVarNode prevVn = this.pag.makeLocalVarNode(prevAn, prevAn.getType(), this.method);
        this.mpag.addInternalEdge(prevAn, prevVn);
        this.setResult(prevAn);
        while ((t = type.getElementType()) instanceof ArrayType) {
            type = (ArrayType)t;
            AllocNode an = this.pag.makeAllocNode(new Pair<NewMultiArrayExpr, Integer>(nmae, new Integer(type.numDimensions)), type, this.method);
            LocalVarNode vn = this.pag.makeLocalVarNode(an, an.getType(), this.method);
            this.mpag.addInternalEdge(an, vn);
            this.mpag.addInternalEdge(vn, this.pag.makeFieldRefNode(prevVn, ArrayElement.v()));
            prevAn = an;
            prevVn = vn;
        }
    }

    public final void caseParameterRef(ParameterRef pr) {
        this.setResult(this.caseParm(pr.getIndex()));
    }

    public final void caseStaticFieldRef(StaticFieldRef sfr) {
        this.setResult(this.pag.makeGlobalVarNode(sfr.getField(), sfr.getField().getType()));
    }

    public final void caseStringConstant(StringConstant sc) {
        AllocNode stringConstant = this.pag.getOpts().string_constants() || Scene.v().containsClass(sc.value) || sc.value.length() > 0 && sc.value.charAt(0) == '[' ? this.pag.makeStringConstantNode(sc.value) : this.pag.makeAllocNode("STRING_NODE", RefType.v("java.lang.String"), null);
        GlobalVarNode stringConstantLocal = this.pag.makeGlobalVarNode(stringConstant, RefType.v("java.lang.String"));
        this.pag.addEdge(stringConstant, stringConstantLocal);
        this.setResult(stringConstantLocal);
    }

    public final void caseThisRef(ThisRef tr) {
        this.setResult(this.caseThis());
    }

    public final void caseNullConstant(NullConstant nr) {
        this.setResult(null);
    }

    public final void caseClassConstant(ClassConstant cc) {
        AllocNode classConstant = this.pag.makeClassConstantNode(cc);
        GlobalVarNode classConstantLocal = this.pag.makeGlobalVarNode(classConstant, RefType.v("java.lang.Class"));
        this.pag.addEdge(classConstant, classConstantLocal);
        this.setResult(classConstantLocal);
    }

    public final void defaultCase(Object v) {
        throw new RuntimeException("failed to handle " + v);
    }
}

