/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.AnySubType;
import soot.ArrayType;
import soot.Local;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.EvalHelper;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.Histogram;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.toolkits.callgraph.Edge;

public class GeomEvaluator {
    private GeomPointsTo ptsProvider;
    private PrintStream outputer;
    private boolean solved;

    public GeomEvaluator(GeomPointsTo gpts, PrintStream ps) {
        this.ptsProvider = gpts;
        this.outputer = ps;
    }

    private boolean is_legal_pointer(Node v) {
        SootClass sc;
        SootMethod sm = null;
        int method = 0;
        if (v.getType() instanceof RefType && !(sc = ((RefType)v.getType()).getSootClass()).isInterface() && Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(sc, GeomPointsTo.exeception_type.getSootClass())) {
            return false;
        }
        method = this.ptsProvider.getMappedMethodID(v);
        if (method == -1) {
            return false;
        }
        if (method == 0) {
            return true;
        }
        sm = this.ptsProvider.getSootMethodFromID(method);
        return !sm.isJavaLibraryMethod();
    }

    private void test_1cfa_call_graph(LocalVarNode vn, SootMethod caller, SootMethod callee_signature, Histogram ce_range) {
        IVarAbstraction pn = this.ptsProvider.getInternalNode(vn);
        HashSet<SootMethod> tgts = new HashSet<SootMethod>();
        Set<AllocNode> set = pn.get_all_points_to_objects();
        LinkedList<CgEdge> list = this.ptsProvider.getCallEdgesInto(this.ptsProvider.getIDFromSootMethod(caller));
        for (CgEdge p : list) {
            long l = p.map_offset;
            long r = l + this.ptsProvider.max_context_size_block[p.s];
            tgts.clear();
            for (AllocNode obj : set) {
                if (!pn.pointer_interval_points_to(l, r, obj)) continue;
                Type t = obj.getType();
                if (t instanceof AnySubType) {
                    t = ((AnySubType)t).getBase();
                } else if (t instanceof ArrayType) {
                    t = RefType.v("java.lang.Object");
                }
                try {
                    tgts.add(Scene.v().getOrMakeFastHierarchy().resolveConcreteDispatch(((RefType)t).getSootClass(), callee_signature));
                }
                catch (Exception e) {}
            }
            tgts.remove(null);
            ce_range.addNumber(tgts.size());
        }
    }

    public void reportBasicMetrics() {
        int n_legal_var = 0;
        int n_alloc_dot_fields = 0;
        long total_geom_ins_pts = 0L;
        long total_geom_sen_pts = 0L;
        long total_spark_pts = 0L;
        int max_pts_geom = 0;
        int max_pts_spark = 0;
        HashSet<Type> geom_types = new HashSet<Type>();
        final HashSet spark_types = new HashSet();
        int[] limits = new int[]{1, 5, 10, 25, 50, 75, 100};
        Histogram pts_size_bar_geom = new Histogram(limits);
        Histogram pts_size_bar_spark = new Histogram(limits);
        Histogram type_size_bar_geom = new Histogram(limits);
        Histogram type_size_bar_spark = new Histogram(limits);
        n_legal_var = 0;
        n_alloc_dot_fields = 0;
        total_geom_ins_pts = 0L;
        total_geom_sen_pts = 0L;
        max_pts_geom = 0;
        for (IVarAbstraction pn : this.ptsProvider.pointers) {
            Node v = (pn = pn.getRepresentative()).getWrappedNode();
            if (!this.is_legal_pointer(v)) continue;
            if (v instanceof AllocDotField) {
                ++n_alloc_dot_fields;
            }
            ++n_legal_var;
            int size = pn.num_of_diff_objs();
            pts_size_bar_geom.addNumber(size);
            total_geom_ins_pts += (long)size;
            if (size > max_pts_geom) {
                max_pts_geom = size;
            }
            size = pn.getWrappedNode().getP2Set().size();
            pts_size_bar_spark.addNumber(size);
            total_spark_pts += (long)size;
            if (size > max_pts_spark) {
                max_pts_spark = size;
            }
            geom_types.clear();
            Set<AllocNode> obj_set = pn.get_all_points_to_objects();
            for (AllocNode obj : obj_set) {
                if (obj.getType() instanceof AnySubType) {
                    SootClass rc = ((AnySubType)obj.getType()).getBase().getSootClass();
                    List<SootClass> list = null;
                    list = rc.isInterface() ? Scene.v().getActiveHierarchy().getImplementersOf(rc) : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(rc);
                    for (SootClass sc : list) {
                        geom_types.add(sc.getType());
                    }
                } else {
                    geom_types.add(obj.getType());
                }
                total_geom_sen_pts += (long)pn.count_pts_intervals(obj);
            }
            type_size_bar_geom.addNumber(geom_types.size());
            spark_types.clear();
            pn.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                public final void visit(Node n) {
                    AllocNode an = (AllocNode)n;
                    if (an.getType() instanceof AnySubType) {
                        SootClass rc = ((AnySubType)an.getType()).getBase().getSootClass();
                        List<SootClass> list = null;
                        list = rc.isInterface() ? Scene.v().getActiveHierarchy().getImplementersOf(rc) : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(rc);
                        for (SootClass sc : list) {
                            spark_types.add(sc.getType());
                        }
                    } else {
                        spark_types.add(an.getType());
                    }
                }
            });
            type_size_bar_spark.addNumber(spark_types.size());
        }
        this.outputer.println("");
        this.outputer.println("--------------------Points-to Analysis Basic Information-------------------");
        this.outputer.println("------>>>> Format:  Geometric Analysis (SPARK)");
        this.outputer.println("Legal pointers : " + n_legal_var + ", in which the #AllocDot Fields : " + n_alloc_dot_fields);
        this.outputer.println("All Pointers : " + this.ptsProvider.n_var);
        this.outputer.println("Reachable Methods : " + this.ptsProvider.n_reach_methods + " (" + (this.ptsProvider.n_func - 1) + ")");
        this.outputer.println("Reachable User Methods : " + this.ptsProvider.n_reach_user_methods);
        this.outputer.printf("Total/Average Projected Points-to Tuples : %d (%d) / %.3f (%.3f) \n", total_geom_ins_pts, total_spark_pts, (double)total_geom_ins_pts / (double)n_legal_var, (double)total_spark_pts / (double)n_legal_var);
        this.outputer.printf("Total/Average Context Sensitive Points-to Tuples : %d / %.3f \n", total_geom_sen_pts, (double)total_geom_sen_pts / (double)n_legal_var);
        this.outputer.println("The largest points-to set size : " + max_pts_geom + " (" + max_pts_spark + ")");
        this.outputer.println();
        pts_size_bar_geom.printResult(this.ptsProvider.ps, "Points-to Set Sizes Distribution :", pts_size_bar_spark);
        type_size_bar_geom.printResult(this.ptsProvider.ps, "Points-to Set Types Distribution :", type_size_bar_spark);
    }

    public void check_virtual_functions() {
        HashMap<Stmt, HashSet<SootMethod>> my_vir_tgts = new HashMap<Stmt, HashSet<SootMethod>>();
        int total_virtual_calls = 0;
        int geom_solved = 0;
        int spark_solved = 0;
        int n_func = this.ptsProvider.n_func;
        for (int i = 0; i < n_func; ++i) {
            if (!this.ptsProvider.isReachableMethod(i)) continue;
            CgEdge p = this.ptsProvider.getCallEgesOutFrom(i);
            while (p != null) {
                Stmt expr;
                if (p.sootEdge != null && !p.is_obsoleted && (expr = p.sootEdge.srcStmt()) != null) {
                    HashSet<SootMethod> tgts = (HashSet<SootMethod>)my_vir_tgts.get(expr);
                    if (tgts == null) {
                        tgts = new HashSet<SootMethod>();
                        my_vir_tgts.put(expr, tgts);
                    }
                    tgts.add(p.sootEdge.tgt().method());
                }
                p = p.next;
            }
        }
        int[] limits = new int[]{1, 2, 4, 8};
        Histogram total_call_edges = new Histogram(limits);
        System.gc();
        System.gc();
        System.gc();
        for (SootMethod sm : this.ptsProvider.getAllReachableMethods()) {
            if (sm.isJavaLibraryMethod() || !sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.ptsProvider.isValidMethod(sm)) continue;
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                InvokeExpr ie;
                if (!stmt.containsInvokeExpr() || !((ie = stmt.getInvokeExpr()) instanceof VirtualInvokeExpr)) continue;
                ++total_virtual_calls;
                Local l = (Local)((VirtualInvokeExpr)ie).getBase();
                LocalVarNode vn = this.ptsProvider.findLocalVarNode(l);
                this.solved = false;
                if (my_vir_tgts.containsKey(stmt)) {
                    Set tgts = (Set)my_vir_tgts.get(stmt);
                    if (tgts.size() == 1) {
                        ++geom_solved;
                        this.solved = true;
                    } else {
                        Histogram call_edges = new Histogram(limits);
                        this.test_1cfa_call_graph(vn, sm, ie.getMethod(), call_edges);
                        total_call_edges.merge(call_edges);
                    }
                } else {
                    ++geom_solved;
                    this.solved = true;
                }
                int count = 0;
                Iterator<Edge> it = Scene.v().getCallGraph().edgesOutOf(stmt);
                while (it.hasNext()) {
                    it.next();
                    ++count;
                }
                if (count <= 1) {
                    ++spark_solved;
                }
                if (count <= 1 || !this.solved || !this.ptsProvider.getOpts().verbose()) continue;
                this.outputer.println();
                this.outputer.println("<<<<<<<<<   Additional Solved Call   >>>>>>>>>>");
                this.outputer.println(sm.toString());
                this.outputer.println(ie.toString());
                EvalHelper.debug_succint_pointsto_info(vn, this.ptsProvider);
            }
        }
        this.ptsProvider.ps.println();
        this.ptsProvider.ps.println("Total virtual callsites : " + total_virtual_calls);
        this.ptsProvider.ps.println("Resolved virtual callsites : Geom = " + geom_solved + ", SPARK = " + spark_solved);
        total_call_edges.printResult(this.ptsProvider.ps, "Random testing of the context sensitive call graph : ");
        if (this.ptsProvider.getOpts().verbose()) {
            this.ptsProvider.outputNotEvaluatedMethods();
        }
    }

    public void check_alias_analysis() {
        HashSet<Node> access_expr = new HashSet<Node>();
        ArrayList<Node> al = new ArrayList<Node>();
        Value[] values = new Value[2];
        long cnt_all_interval = 0L;
        long cnt_hs_alias = 0L;
        long cnt_hi_alias = 0L;
        for (SootMethod sm : this.ptsProvider.getAllReachableMethods()) {
            IVarAbstraction pn;
            if (sm.isJavaLibraryMethod() || !sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.ptsProvider.isValidMethod(sm)) continue;
            access_expr.clear();
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                if (!(stmt instanceof AssignStmt)) continue;
                AssignStmt a = (AssignStmt)stmt;
                values[0] = a.getLeftOp();
                values[1] = a.getRightOp();
                for (Value v : values) {
                    VarNode vn;
                    if (v instanceof Local) {
                        Local l = (Local)v;
                        vn = this.ptsProvider.findLocalVarNode(l);
                        access_expr.add(vn);
                        continue;
                    }
                    if (v instanceof InstanceFieldRef) {
                        LocalVarNode vn2;
                        InstanceFieldRef ifr = (InstanceFieldRef)v;
                        SootField field = ifr.getField();
                        if (!(field.getType() instanceof RefType) || (vn2 = this.ptsProvider.findLocalVarNode((Local)ifr.getBase())) == null) continue;
                        access_expr.add(vn2);
                        pn = this.ptsProvider.getInternalNode(vn2);
                        for (AllocNode an : pn.get_all_points_to_objects()) {
                            AllocDotField adf = this.ptsProvider.makeAllocDotField(an, field);
                            access_expr.add(adf);
                        }
                        continue;
                    }
                    if (v instanceof StaticFieldRef) {
                        StaticFieldRef sfr = (StaticFieldRef)v;
                        vn = this.ptsProvider.findGlobalVarNode(sfr.getField());
                        access_expr.add(vn);
                        continue;
                    }
                    if (!(v instanceof ArrayRef)) continue;
                    ArrayRef ar = (ArrayRef)v;
                    vn = this.ptsProvider.findLocalVarNode((Local)ar.getBase());
                    access_expr.add(vn);
                }
            }
            access_expr.remove(null);
            al.clear();
            for (Node node : access_expr) {
                if (!this.is_legal_pointer(node)) continue;
                al.add(node);
            }
            for (int i = 0; i < al.size(); ++i) {
                Node node = (Node)al.get(i);
                pn = this.ptsProvider.getInternalNode(node);
                pn = pn.getRepresentative();
                for (int j = i + 1; j < al.size(); ++j) {
                    Node n2 = (Node)al.get(j);
                    IVarAbstraction qn = this.ptsProvider.getInternalNode(n2);
                    if (pn.heap_sensitive_intersection(qn = qn.getRepresentative())) {
                        ++cnt_hs_alias;
                    }
                    if (node.getP2Set().hasNonEmptyIntersection(n2.getP2Set())) {
                        ++cnt_hi_alias;
                    }
                    ++cnt_all_interval;
                }
            }
        }
        this.ptsProvider.ps.println();
        this.ptsProvider.ps.println("--------> Alias Pairs Evaluation <---------");
        this.ptsProvider.ps.println("All pointer pairs : " + cnt_all_interval);
        this.ptsProvider.ps.println("Heap sensitive alias pairs (by Geom) : " + cnt_hs_alias + ", Percentage = " + (double)cnt_hs_alias / (double)cnt_all_interval);
        this.ptsProvider.ps.println("Heap sensitive alias pairs (by SPARK) : " + cnt_hi_alias + ", Percentage = " + (double)cnt_hi_alias / (double)cnt_all_interval);
        this.ptsProvider.ps.println();
    }

    public void check_casts_safety() {
        int total_casts = 0;
        int geom_solved_casts = 0;
        int spark_solved_casts = 0;
        for (SootMethod sm : this.ptsProvider.getAllReachableMethods()) {
            if (sm.isJavaLibraryMethod() || !sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.ptsProvider.isValidMethod(sm)) continue;
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                if (!(stmt instanceof AssignStmt)) continue;
                Value rhs = ((AssignStmt)stmt).getRightOp();
                Value lhs = ((AssignStmt)stmt).getLeftOp();
                if (!(rhs instanceof CastExpr) || !(lhs.getType() instanceof RefLikeType)) continue;
                final RefLikeType targetType = (RefLikeType)((CastExpr)rhs).getCastType();
                Value v = ((CastExpr)rhs).getOp();
                LocalVarNode node = this.ptsProvider.findLocalVarNode(v);
                if (node == null) continue;
                ++total_casts;
                IVarAbstraction pn = this.ptsProvider.getInternalNode(node);
                this.solved = true;
                Set<AllocNode> set = pn.get_all_points_to_objects();
                for (AllocNode obj : set) {
                    this.solved = this.ptsProvider.castNeverFails(obj.getType(), targetType);
                    if (this.solved) continue;
                    break;
                }
                if (this.solved) {
                    ++geom_solved_casts;
                }
                this.solved = true;
                node.getP2Set().forall(new P2SetVisitor(){

                    public void visit(Node arg0) {
                        GeomEvaluator.this.solved = (byte)(GeomEvaluator.this.solved & (GeomEvaluator.this.ptsProvider.castNeverFails(arg0.getType(), targetType) ? 1 : 0));
                    }
                });
                if (!this.solved) continue;
                ++spark_solved_casts;
            }
        }
        this.ptsProvider.ps.println();
        this.ptsProvider.ps.println("-----------> Static Casts Safety Evaluation <------------");
        this.ptsProvider.ps.println("Total casts : " + total_casts);
        this.ptsProvider.ps.println("Safe casts: Geom = " + geom_solved_casts + ", SPARK = " + spark_solved_casts);
    }
}

