/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import soot.AnySubType;
import soot.ArrayType;
import soot.Context;
import soot.G;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.PointsToSet;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.spark.geom.geomE.FullSensitiveNodeGenerator;
import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.FIFO_Worklist;
import soot.jimple.spark.geom.geomPA.GeomEvaluator;
import soot.jimple.spark.geom.geomPA.IEncodingBroker;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.IWorklist;
import soot.jimple.spark.geom.geomPA.OfflineProcessor;
import soot.jimple.spark.geom.geomPA.PQ_Worklist;
import soot.jimple.spark.geom.geomPA.PlainConstraint;
import soot.jimple.spark.geom.geomPA.ZArrayNumberer;
import soot.jimple.spark.geom.heapinsE.HeapInsNodeGenerator;
import soot.jimple.spark.geom.ptinsE.PtInsNodeGenerator;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.Edge;
import soot.options.SparkOptions;
import soot.toolkits.scalar.Pair;
import soot.util.queue.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeomPointsTo
extends PAG {
    public static final int NEW_CONS = 0;
    public static final int ASSIGN_CONS = 1;
    public static final int LOAD_CONS = 2;
    public static final int STORE_CONS = 3;
    public static final int FIELD_ADDRESS = 4;
    public static final int Undefined_Mapping = -1;
    public static final int ONE_TO_ONE = 0;
    public static final int MANY_TO_MANY = 1;
    public static final int ALL_TO_MANY = 0;
    public static final int MANY_TO_ALL = 1;
    public static final int SUPER_MAIN = 0;
    public static final int UNKNOWN_FUNCTION = -1;
    public static final long MAX_CONTEXTS = 0x7FFFFFFFFFFFFFFEL;
    public static final RefType exeception_type = RefType.v("java.lang.Throwable");
    public static int max_cons_budget = 40;
    public static int max_pts_budget = 80;
    public static int cfa_blocks = Integer.MAX_VALUE;
    public static int cg_refine_times = 1;
    protected IWorklist worklist = null;
    protected IEncodingBroker nodeGenerator = null;
    protected TypeManager typeManager = null;
    protected OfflineProcessor offlineProcessor = null;
    public Map<Node, IVarAbstraction> consG = new HashMap<Node, IVarAbstraction>();
    public ZArrayNumberer<IVarAbstraction> pointers = new ZArrayNumberer();
    public ZArrayNumberer<IVarAbstraction> allocations = new ZArrayNumberer();
    public Vector<PlainConstraint> constraints = new Vector();
    public Set<Stmt> thread_run_callsites = new HashSet<Stmt>();
    public int mainID = -1;
    public long[] context_size;
    public long[] max_context_size_block;
    public int[] block_num;
    public int max_scc_size;
    public int max_scc_id;
    public int n_var;
    public int n_alloc_sites;
    public int n_func;
    public int n_calls;
    public int n_reach_methods;
    public int n_reach_user_methods;
    public String dump_file_name = null;
    public int solver_encoding;
    public PrintStream ps = null;
    protected Map<String, Boolean> validMethods = null;
    protected CgEdge[] call_graph;
    protected Vector<CgEdge> obsoletedEdges = new Vector();
    protected Map<Integer, LinkedList<CgEdge>> rev_call_graph;
    protected Deque<Integer> queue_cg = new LinkedList<Integer>();
    protected int[] vis_cg;
    protected int[] low_cg;
    protected int[] rep_cg;
    protected int[] indeg_cg;
    protected int[] scc_size;
    protected int pre_cnt;
    protected Map<SootMethod, Integer> func2int = new HashMap<SootMethod, Integer>(5011);
    protected Map<Integer, SootMethod> int2func = new HashMap<Integer, SootMethod>(5011);
    protected Map<Edge, CgEdge> edgeMapping = new HashMap<Edge, CgEdge>();
    private boolean hasTransformed = false;
    private boolean hasExecuted = false;

    public GeomPointsTo(SparkOptions opts) {
        super(opts);
    }

    public String toString() {
        return "Geometric Points-To Analysis";
    }

    public void parametrize() {
        this.solver_encoding = this.opts.geom_encoding();
        if (this.solver_encoding == 1) {
            this.nodeGenerator = new FullSensitiveNodeGenerator();
        } else if (this.solver_encoding == 2) {
            this.nodeGenerator = new HeapInsNodeGenerator();
        } else if (this.solver_encoding == 3) {
            this.nodeGenerator = new PtInsNodeGenerator();
        }
        if (this.nodeGenerator == null) {
            throw new RuntimeException("The encoding " + this.solver_encoding + " is unavailable for geometric points-to analysis.");
        }
        this.solver_encoding = this.nodeGenerator.getEncodingType();
        switch (this.opts.geom_worklist()) {
            case 2: {
                this.worklist = new FIFO_Worklist();
                break;
            }
            case 1: {
                this.worklist = new PQ_Worklist();
            }
        }
        this.dump_file_name = this.opts.geom_dump_verbose();
        if (!this.dump_file_name.isEmpty()) {
            File file = new File(this.dump_file_name + "_" + this.solver_encoding + "_log.txt");
            try {
                this.ps = new PrintStream(file);
            }
            catch (FileNotFoundException e) {
                System.err.println("The dump file: " + this.dump_file_name + " cannot be created.");
                System.exit(-1);
            }
        } else {
            this.ps = G.v().out;
        }
        String method_verify_file = this.opts.geom_verify_name();
        try {
            FileReader fr = new FileReader(method_verify_file);
            Scanner fin = new Scanner(fr);
            this.validMethods = new HashMap<String, Boolean>();
            while (fin.hasNextLine()) {
                this.validMethods.put(fin.nextLine(), Boolean.FALSE);
            }
        }
        catch (FileNotFoundException e) {
            this.validMethods = null;
        }
        max_cons_budget = this.opts.geom_frac_base();
        max_pts_budget = max_cons_budget * 2;
        cfa_blocks = this.opts.geom_blocking() ? Integer.MAX_VALUE : 1;
        cg_refine_times = this.opts.geom_runs();
        this.consG.clear();
        this.constraints.clear();
        this.func2int.clear();
        this.edgeMapping.clear();
        this.typeManager = this.getTypeManager();
        this.ps.println();
        this.ps.println(this.solver_encoding + " starts working on " + (this.dump_file_name.isEmpty() ? "untitled" : this.dump_file_name) + " benchmark.");
    }

    private Set<Node> preprocess() {
        IVarAbstraction q;
        PlainConstraint cons;
        Node[] succs;
        IVarAbstraction pn;
        Object p;
        HashSet<Node> virtualBases = new HashSet<Node>();
        this.n_func = Scene.v().getReachableMethods().size() + 1;
        this.call_graph = new CgEdge[this.n_func];
        this.n_calls = 0;
        int id = 1;
        QueueReader<MethodOrMethodContext> smList = Scene.v().getReachableMethods().listener();
        while (smList.hasNext()) {
            SootMethod func = (SootMethod)smList.next();
            this.func2int.put(func, id);
            this.int2func.put(id, func);
            if (Scene.v().getCallGraph().isEntryMethod(func) || func.isEntryMethod()) {
                CgEdge p2;
                this.call_graph[0] = p2 = new CgEdge(0, id, null, this.call_graph[0]);
                ++this.n_calls;
            }
            if (func.isMain()) {
                this.mainID = id;
            }
            ++id;
        }
        QueueReader<Edge> edgeList = Scene.v().getCallGraph().listener();
        while (edgeList.hasNext()) {
            Edge edge = edgeList.next();
            if (edge.isClinit()) continue;
            SootMethod src_func = edge.src();
            SootMethod tgt_func = edge.tgt();
            int s = this.func2int.get(src_func);
            int t = this.func2int.get(tgt_func);
            p = new CgEdge(s, t, edge, this.call_graph[s]);
            this.call_graph[s] = p;
            this.edgeMapping.put(edge, (CgEdge)p);
            if (edge.isVirtual()) {
                VirtualInvokeExpr expr = (VirtualInvokeExpr)edge.srcStmt().getInvokeExpr();
                ((CgEdge)p).base_var = this.findLocalVarNode(expr.getBase());
                if (!edge.src().isJavaLibraryMethod() || !edge.tgt().isJavaLibraryMethod()) {
                    virtualBases.add(((CgEdge)p).base_var);
                }
            }
            if (edge.tgt().getSignature().equals("<java.lang.Thread: void start()>")) {
                this.thread_run_callsites.add(((CgEdge)p).sootEdge.srcStmt());
            }
            ++this.n_calls;
        }
        Iterator it = this.getVarNodeNumberer().iterator();
        while (it.hasNext()) {
            VarNode vn = (VarNode)it.next();
            pn = this.getInternalNode(vn);
            this.pointers.add(pn);
        }
        it = this.getAllocDotFieldNodeNumberer().iterator();
        while (it.hasNext()) {
            AllocDotField adf = (AllocDotField)it.next();
            pn = this.getInternalNode(adf);
            this.pointers.add(pn);
        }
        it = this.getAllocNodeNumberer().iterator();
        while (it.hasNext()) {
            AllocNode obj = (AllocNode)it.next();
            pn = this.getInternalNode(obj);
            this.allocations.add(pn);
        }
        this.n_var = this.pointers.size();
        this.n_alloc_sites = this.allocations.size();
        for (Object object : this.allocSources()) {
            Node[] succs2;
            IVarAbstraction obj = this.getInternalNode((AllocNode)object);
            for (Node element0 : succs2 = this.allocLookup((AllocNode)object)) {
                PlainConstraint cons2 = new PlainConstraint();
                IVarAbstraction p3 = this.getInternalNode(element0);
                cons2.expr.setPair(obj, p3);
                cons2.type = 0;
                this.constraints.add(cons2);
            }
        }
        Pair<Node, Node> intercall = new Pair<Node, Node>();
        for (Object object : this.simpleSources()) {
            p = this.getInternalNode((VarNode)object);
            for (Node element0 : succs = this.simpleLookup((VarNode)object)) {
                cons = new PlainConstraint();
                IVarAbstraction q2 = this.getInternalNode(element0);
                cons.expr.setPair((IVarAbstraction)p, q2);
                cons.type = 1;
                intercall.setPair((VarNode)object, element0);
                cons.interCallEdges = this.lookupEdgesForAssignment(intercall);
                this.constraints.add(cons);
            }
        }
        intercall = null;
        this.assign2edges.clear();
        for (Object object : this.loadSources()) {
            Node[] succs3;
            FieldRefNode frn = (FieldRefNode)object;
            IVarAbstraction p4 = this.getInternalNode(frn.getBase());
            for (Node element0 : succs3 = this.loadLookup(frn)) {
                PlainConstraint cons3 = new PlainConstraint();
                q = this.getInternalNode(element0);
                cons3.f = frn.getField();
                cons3.expr.setPair(p4, q);
                cons3.type = 2;
                this.constraints.add(cons3);
            }
        }
        for (Object object : this.storeSources()) {
            p = this.getInternalNode((VarNode)object);
            for (Node element0 : succs = this.storeLookup((VarNode)object)) {
                cons = new PlainConstraint();
                FieldRefNode frn = (FieldRefNode)element0;
                q = this.getInternalNode(frn.getBase());
                cons.f = frn.getField();
                cons.expr.setPair((IVarAbstraction)p, q);
                cons.type = 3;
                this.constraints.add(cons);
            }
        }
        this.low_cg = new int[this.n_func];
        this.vis_cg = new int[this.n_func];
        this.rep_cg = new int[this.n_func];
        this.indeg_cg = new int[this.n_func];
        this.scc_size = new int[this.n_func];
        this.block_num = new int[this.n_func];
        this.context_size = new long[this.n_func];
        this.max_context_size_block = new long[this.n_func];
        return virtualBases;
    }

    private void callGraphDFS(int s) {
        int t;
        ++this.pre_cnt;
        this.vis_cg[s] = this.low_cg[s];
        this.queue_cg.addLast(s);
        CgEdge p = this.call_graph[s];
        while (p != null) {
            t = p.t;
            if (this.vis_cg[t] == 0) {
                this.callGraphDFS(t);
            }
            if (this.low_cg[t] < this.low_cg[s]) {
                this.low_cg[s] = this.low_cg[t];
            }
            p = p.next;
        }
        if (this.low_cg[s] < this.vis_cg[s]) {
            this.scc_size[s] = 1;
            return;
        }
        this.scc_size[s] = this.queue_cg.size();
        do {
            t = this.queue_cg.getLast();
            this.queue_cg.removeLast();
            this.rep_cg[t] = s;
            int n = t;
            this.low_cg[n] = this.low_cg[n] + this.n_func;
        } while (s != t);
        int n = s;
        this.scc_size[n] = this.scc_size[n] - this.queue_cg.size();
        if (this.scc_size[s] > this.max_scc_size) {
            this.max_scc_size = this.scc_size[s];
            this.max_scc_id = s;
        }
    }

    private void encodeContexts() {
        int j;
        CgEdge p;
        int i;
        int n_reachable = 0;
        int n_scc_reachable = 0;
        int n_full = 0;
        long max_contexts = Long.MIN_VALUE;
        this.pre_cnt = 1;
        this.max_scc_size = 1;
        for (i = 0; i < this.n_func; ++i) {
            this.vis_cg[i] = 0;
            this.indeg_cg[i] = 0;
            this.max_context_size_block[i] = 0L;
        }
        this.queue_cg.clear();
        this.callGraphDFS(0);
        for (i = 0; i < this.n_func; ++i) {
            if (this.vis_cg[i] == 0) continue;
            p = this.call_graph[i];
            while (p != null) {
                if (this.rep_cg[i] == this.rep_cg[p.t]) {
                    p.scc_edge = true;
                    p.map_offset = 1L;
                } else {
                    p.scc_edge = false;
                    int n = this.rep_cg[p.t];
                    this.indeg_cg[n] = this.indeg_cg[n] + 1;
                }
                p = p.next;
            }
            ++n_reachable;
            if (this.rep_cg[i] != i) continue;
            ++n_scc_reachable;
        }
        for (i = 0; i < this.n_func; ++i) {
            if (this.vis_cg[i] == 0 || this.rep_cg[i] == i) continue;
            p = this.call_graph[i];
            while (p.next != null) {
                p = p.next;
            }
            p.next = this.call_graph[this.rep_cg[i]];
            this.call_graph[this.rep_cg[i]] = this.call_graph[i];
        }
        this.max_context_size_block[0] = 1L;
        this.queue_cg.addLast(0);
        while (!this.queue_cg.isEmpty()) {
            i = this.queue_cg.getFirst();
            this.queue_cg.removeFirst();
            p = this.call_graph[i];
            while (p != null) {
                if (!p.scc_edge) {
                    j = this.rep_cg[p.t];
                    if (0x7FFFFFFFFFFFFFFEL - this.max_context_size_block[i] < this.max_context_size_block[j]) {
                        p.map_offset = 0x7FFFFFFFFFFFFFFEL - this.max_context_size_block[i] + 1L;
                        this.max_context_size_block[j] = 0x7FFFFFFFFFFFFFFEL;
                    } else {
                        p.map_offset = this.max_context_size_block[j] + 1L;
                        int n = j;
                        this.max_context_size_block[n] = this.max_context_size_block[n] + this.max_context_size_block[i];
                    }
                    int n = j;
                    this.indeg_cg[n] = this.indeg_cg[n] - 1;
                    if (this.indeg_cg[n] == 0) {
                        this.queue_cg.addLast(j);
                    }
                }
                p = p.next;
            }
            if (this.max_context_size_block[i] <= max_contexts) continue;
            max_contexts = this.max_context_size_block[i];
        }
        for (i = this.n_func - 1; i > -1; --i) {
            if (this.vis_cg[i] == 0) continue;
            if (this.rep_cg[i] != i) {
                this.max_context_size_block[i] = this.max_context_size_block[this.rep_cg[i]];
                p = this.call_graph[i];
                while (p.next.s == i) {
                    p = p.next;
                }
                this.call_graph[this.rep_cg[i]] = p.next;
                p.next = null;
            }
            if (this.max_context_size_block[i] == 0x7FFFFFFFFFFFFFFEL) {
                ++n_full;
            }
            this.context_size[i] = this.max_context_size_block[i];
            this.block_num[i] = 1;
        }
        if (cfa_blocks > 1) {
            for (i = 0; i < this.n_func; ++i) {
                if (this.vis_cg[i] == 0) continue;
                p = this.call_graph[i];
                while (p != null) {
                    j = p.t;
                    if (j != i && p.scc_edge) {
                        if (this.block_num[j] < cfa_blocks && this.context_size[j] <= 0x7FFFFFFFFFFFFFFEL - this.max_context_size_block[i]) {
                            p.map_offset = this.context_size[j] + 1L;
                            int n = j;
                            this.context_size[n] = this.context_size[n] + this.max_context_size_block[i];
                            int n2 = j;
                            this.block_num[n2] = this.block_num[n2] + 1;
                        } else {
                            if (this.block_num[j] < cfa_blocks) {
                                this.context_size[j] = 0x7FFFFFFFFFFFFFFEL;
                                int n = j;
                                this.block_num[n] = this.block_num[n] + 1;
                            }
                            p.map_offset = this.context_size[j] - this.max_context_size_block[i] + 1L;
                        }
                    }
                    p = p.next;
                }
            }
        }
        this.ps.printf("Reachable Methods = %d, in which #Condensed Nodes = %d, #Full Context Nodes = %d \n", n_reachable - 1, n_scc_reachable, n_full);
        this.ps.printf("Maximum SCC = %d \n", this.max_scc_size);
        this.ps.printf("The maximum context size = %e\n", max_contexts);
    }

    private void solveConstraints() {
        while (this.worklist.has_job()) {
            IVarAbstraction pn = this.worklist.next();
            pn.do_before_propagation();
            pn.propagate(this, this.worklist);
            pn.do_after_propagation();
        }
    }

    private int updateCallGraph() {
        int all_virtual_edges = 0;
        int n_obsoleted = 0;
        for (int i = 1; i < this.n_func; ++i) {
            CgEdge p = this.call_graph[i];
            CgEdge q = null;
            while (p != null) {
                if (this.vis_cg[i] == 0) {
                    p.is_obsoleted = true;
                } else if (this.vis_cg[i] != 0 && p.base_var != null && !this.thread_run_callsites.contains(p.sootEdge.srcStmt())) {
                    boolean keep_this_edge = false;
                    ++all_virtual_edges;
                    IVarAbstraction pn = this.consG.get(p.base_var).getRepresentative();
                    if (pn != null) {
                        SootMethod sm = p.sootEdge.tgt();
                        for (AllocNode an : pn.get_all_points_to_objects()) {
                            Type t = an.getType();
                            if (t instanceof AnySubType || t instanceof ArrayType) {
                                keep_this_edge = true;
                                break;
                            }
                            if (Scene.v().getOrMakeFastHierarchy().resolveConcreteDispatch(((RefType)t).getSootClass(), sm) != sm) continue;
                            keep_this_edge = true;
                            break;
                        }
                        if (!keep_this_edge) {
                            p.is_obsoleted = true;
                            if (!p.sootEdge.src().isJavaLibraryMethod()) {
                                ++n_obsoleted;
                            }
                        }
                    } else {
                        System.err.println();
                        throw new RuntimeException("In update_call_graph: oops, what's up?");
                    }
                }
                CgEdge temp = p.next;
                if (!p.is_obsoleted) {
                    p.next = q;
                    q = p;
                } else {
                    this.obsoletedEdges.add(p);
                }
                p = temp;
            }
            this.call_graph[i] = q;
        }
        this.ps.println("Totally " + all_virtual_edges + " virtual edges, " + "we find " + n_obsoleted + " of them are obsoleted.");
        return n_obsoleted;
    }

    private void prepareNextRun() {
        for (IVarAbstraction pn : this.pointers) {
            pn.reconstruct();
        }
        this.offlineProcessor.recleanConstraints();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    protected int countReachableMethods(int s) {
        SootMethod sm;
        int ans = 1;
        CgEdge p = this.call_graph[s];
        this.vis_cg[s] = 1;
        while (p != null) {
            if (this.vis_cg[p.t] == 0) {
                ans += this.countReachableMethods(p.t);
            }
            p = p.next;
        }
        if (s != 0 && !(sm = this.int2func.get(s)).isJavaLibraryMethod()) {
            ++this.n_reach_user_methods;
        }
        return ans;
    }

    private void postProcess() {
        int i;
        for (i = 0; i < this.n_func; ++i) {
            this.vis_cg[i] = 0;
        }
        this.n_reach_user_methods = 0;
        this.n_reach_methods = this.countReachableMethods(0);
        this.rev_call_graph = new HashMap<Integer, LinkedList<CgEdge>>();
        for (i = 0; i < this.n_func; ++i) {
            if (this.vis_cg[i] == 0) {
                this.func2int.remove(this.int2func.get(i));
                this.int2func.remove(i);
                continue;
            }
            CgEdge p = this.call_graph[i];
            while (p != null) {
                LinkedList<CgEdge> list = this.rev_call_graph.get(p.t);
                if (list == null) {
                    list = new LinkedList();
                    this.rev_call_graph.put(p.t, list);
                }
                list.add(p);
                p = p.next;
            }
        }
        HashSet<AllocNode> obs_objs = new HashSet<AllocNode>();
        LinkedList<IVarAbstraction> obs_pts = new LinkedList<IVarAbstraction>();
        LinkedList<AllocNode> temp_list = new LinkedList<AllocNode>();
        Iterator<IVarAbstraction> it = this.allocations.iterator();
        while (it.hasNext()) {
            AllocNode obj = (AllocNode)it.next().getWrappedNode();
            SootMethod sm = obj.getMethod();
            if (sm == null || this.func2int.containsKey(sm)) continue;
            obs_objs.add(obj);
        }
        for (IVarAbstraction pn : this.pointers) {
            Node node = pn.getWrappedNode();
            SootMethod sm = null;
            if (node instanceof LocalVarNode) {
                sm = ((LocalVarNode)node).getMethod();
            } else if (node instanceof AllocDotField) {
                sm = ((AllocDotField)node).getBase().getMethod();
            }
            if (sm != null && !this.func2int.containsKey(sm)) {
                obs_pts.add(pn);
                continue;
            }
            if (pn.getRepresentative() != pn) continue;
            temp_list.clear();
            for (AllocNode obj : pn.get_all_points_to_objects()) {
                if (!obs_objs.contains(obj)) continue;
                temp_list.add(obj);
            }
            for (AllocNode obj : temp_list) {
                pn.remove_points_to(obj);
            }
            pn.drop_duplicates();
        }
        for (IVarAbstraction pn : obs_pts) {
            this.pointers.remove(pn);
        }
        for (AllocNode an : obs_objs) {
            IVarAbstraction po = this.consG.get(an);
            this.allocations.remove(po);
        }
        obs_objs = null;
        temp_list = null;
    }

    public void transformToCIResult() {
        for (CgEdge p : this.obsoletedEdges) {
            Scene.v().getCallGraph().removeEdge(p.sootEdge);
        }
        Scene.v().releaseReachableMethods();
        Scene.v().getReachableMethods();
        for (IVarAbstraction pn : this.pointers) {
            Node node = pn.getWrappedNode();
            if (node.getP2Set() != EmptyPointsToSet.v()) continue;
            PointsToSetInternal ptSet = node.makeP2Set();
            for (AllocNode obj : pn.getRepresentative().get_all_points_to_objects()) {
                ptSet.add(obj);
            }
        }
        for (IVarAbstraction pn : this.pointers) {
            pn.discard();
        }
    }

    public void solve() {
        G.v().out.flush();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        Date begin = new Date();
        Set<Node> virtualBaseSet = this.preprocess();
        this.offlineProcessor = new OfflineProcessor(this.n_var, this);
        this.offlineProcessor.runOptimizations(virtualBaseSet);
        this.worklist.initialize(this.n_var);
        Date end = new Date();
        long time = end.getTime() - begin.getTime();
        this.ps.printf("Preprocess Time : %.3fs \n", (double)time / 1000.0);
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        begin = new Date();
        int rounds = 0;
        while (true) {
            this.ps.println("\nRound " + rounds + " : ");
            this.encodeContexts();
            this.nodeGenerator.initFlowGraph(this);
            this.solveConstraints();
            if (++rounds >= cg_refine_times) break;
            this.updateCallGraph();
            this.prepareNextRun();
        }
        end = new Date();
        time = end.getTime() - begin.getTime();
        long mem2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.updateCallGraph();
        this.postProcess();
        this.ps.printf("Current Reachable Methods = %d, Originally = %d \n", this.n_reach_methods, this.n_func - 1);
        this.ps.println();
        this.ps.printf("Geometric [Time] : %.3fs \n", (double)time / 1000.0);
        this.ps.printf("Geometric [Memory] : %.3fMB \n", (double)mem2 / 1024.0 / 1024.0);
        int evalLevel = this.opts.geom_eval();
        if (evalLevel > 0) {
            GeomEvaluator ge = new GeomEvaluator(this, this.ps);
            ge.reportBasicMetrics();
            if (evalLevel > 1) {
                ge.check_virtual_functions();
                ge.check_casts_safety();
                ge.check_alias_analysis();
            }
        }
        if (this.opts.geom_trans()) {
            this.transformToCIResult();
            this.hasTransformed = true;
        }
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        this.hasExecuted = true;
    }

    public int getIDFromSootMethod(SootMethod sm) {
        return this.func2int.get(sm);
    }

    public SootMethod getSootMethodFromID(int fid) {
        return this.int2func.get(fid);
    }

    public boolean isReachableMethod(int fid) {
        return this.vis_cg[fid] != 0;
    }

    public boolean isValidMethod(SootMethod sm) {
        if (this.validMethods != null) {
            String sig = sm.toString();
            if (!this.validMethods.containsKey(sig)) {
                return false;
            }
            this.validMethods.put(sig, Boolean.TRUE);
        }
        return true;
    }

    public void outputNotEvaluatedMethods() {
        if (this.validMethods != null) {
            this.ps.println("\nThe following methods are not evaluated because they are unreachable:");
            for (Map.Entry<String, Boolean> entry : this.validMethods.entrySet()) {
                if (!entry.getValue().equals(Boolean.FALSE)) continue;
                this.ps.println(entry.getKey());
            }
            this.ps.println();
        }
    }

    public Set<SootMethod> getAllReachableMethods() {
        return this.func2int.keySet();
    }

    public CgEdge getCallEgesOutFrom(int fid) {
        return this.call_graph[fid];
    }

    public LinkedList<CgEdge> getCallEdgesInto(int fid) {
        return this.rev_call_graph.get(fid);
    }

    public int getMappedMethodID(Node node) {
        SootMethod sm = null;
        int ret = 0;
        if (node instanceof AllocNode) {
            sm = ((AllocNode)node).getMethod();
        } else if (node instanceof LocalVarNode) {
            sm = ((LocalVarNode)node).getMethod();
        } else if (node instanceof AllocDotField) {
            sm = ((AllocDotField)node).getBase().getMethod();
        }
        if (sm != null && this.vis_cg[ret = this.func2int.get(sm).intValue()] == 0) {
            ret = -1;
        }
        return ret;
    }

    public IVarAbstraction getInternalNode(Node v) {
        IVarAbstraction ret = this.consG.get(v);
        if (ret == null) {
            ret = this.nodeGenerator.generateNode(v);
            this.consG.put(v, ret);
        }
        return ret;
    }

    public boolean castNeverFails(Type src, Type dst) {
        return this.typeManager.castNeverFails(src, dst);
    }

    public int getNumberOfPointers() {
        return this.pointers.size();
    }

    public int getNumberOfObjects() {
        return this.allocations.size();
    }

    public int getNumberOfFunctions() {
        return this.n_func;
    }

    public IWorklist getWorklist() {
        return this.worklist;
    }

    public IVarAbstraction findAndInsertInstanceField(AllocNode obj, SparkField field) {
        AllocDotField af = this.findAllocDotField(obj, field);
        assert (af != null);
        return this.consG.get(af);
    }

    public CgEdge getInternalEdgeFromSootEdge(Edge e) {
        return this.edgeMapping.get(e);
    }

    private PointsToSetInternal field_p2set(PointsToSet s, final SparkField f) {
        PointsToSetInternal bases = (PointsToSetInternal)s;
        final PointsToSetInternal ret = this.getSetFactory().newSet(f.getType(), this);
        bases.forall(new P2SetVisitor(){

            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF != null) {
                    PointsToSetInternal temp = nDotF.getP2Set();
                    ret.addAll(temp, null);
                }
            }
        });
        return ret;
    }

    @Override
    public PointsToSet reachingObjects(Local l) {
        if (!this.hasExecuted) {
            return super.reachingObjects(l);
        }
        LocalVarNode vn = this.findLocalVarNode(l);
        IVarAbstraction pn = this.consG.get(vn);
        if (vn == null || pn == null) {
            return EmptyPointsToSet.v();
        }
        if (this.hasTransformed || vn.getP2Set() != EmptyPointsToSet.v()) {
            return vn.getP2Set();
        }
        pn = pn.getRepresentative();
        PointsToSetInternal ptSet = vn.makeP2Set();
        for (AllocNode obj : pn.getRepresentative().get_all_points_to_objects()) {
            ptSet.add(obj);
        }
        return ptSet;
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l) {
        if (!this.hasExecuted) {
            return super.reachingObjects(c, l);
        }
        if (this.hasTransformed || !(c instanceof Unit)) {
            return G.v().soot_jimple_toolkits_pointer_FullObjectSet();
        }
        LocalVarNode vn = this.findLocalVarNode(l);
        ContextVarNode cvn = vn.context(c);
        if (cvn != null) {
            return cvn.getP2Set();
        }
        cvn = this.makeContextVarNode(vn, c);
        IVarAbstraction pn = this.consG.get(vn);
        if ((pn = pn.getRepresentative()) == null) {
            return EmptyPointsToSet.v();
        }
        SootMethod callee = vn.getMethod();
        Edge e = Scene.v().getCallGraph().findEdge((Unit)c, callee);
        if (e == null) {
            return EmptyPointsToSet.v();
        }
        CgEdge myEdge = this.edgeMapping.get(e);
        long low = myEdge.map_offset;
        long high = low + this.max_context_size_block[myEdge.s];
        PointsToSetInternal ptset = cvn.makeP2Set();
        for (AllocNode an : pn.get_all_points_to_objects()) {
            if (!pn.pointer_interval_points_to(low, high, an)) continue;
            ptset.add(an);
        }
        return ptset;
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        if (!this.hasExecuted) {
            return super.reachingObjects(f);
        }
        if (!f.isStatic()) {
            throw new RuntimeException("The parameter f must be a *static* field.");
        }
        GlobalVarNode vn = this.findGlobalVarNode(f);
        IVarAbstraction pn = this.consG.get(f);
        if (vn == null || pn == null) {
            return EmptyPointsToSet.v();
        }
        if (this.hasTransformed || vn.getP2Set() != EmptyPointsToSet.v()) {
            return vn.getP2Set();
        }
        pn = pn.getRepresentative();
        PointsToSetInternal ptSet = vn.makeP2Set();
        for (AllocNode obj : pn.getRepresentative().get_all_points_to_objects()) {
            ptSet.add(obj);
        }
        return ptSet;
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s, SootField f) {
        if (!this.hasExecuted) {
            return super.reachingObjects(s, f);
        }
        return this.field_p2set(s, f);
    }

    @Override
    public PointsToSet reachingObjects(Local l, SootField f) {
        if (!this.hasExecuted) {
            return super.reachingObjects(l, f);
        }
        return this.reachingObjects(this.reachingObjects(l), f);
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l, SootField f) {
        if (!this.hasExecuted) {
            return super.reachingObjects(c, l, f);
        }
        return this.reachingObjects(this.reachingObjects(c, l), f);
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s) {
        if (!this.hasExecuted) {
            return super.reachingObjectsOfArrayElement(s);
        }
        return this.field_p2set(s, ArrayElement.v());
    }

    public PointsToSet reachingObjects(AllocNode an, SootField f) {
        AllocDotField adf = an.dot(f);
        IVarAbstraction pn = this.consG.get(adf);
        if (adf == null || pn == null) {
            return EmptyPointsToSet.v();
        }
        if (this.hasTransformed || adf.getP2Set() != EmptyPointsToSet.v()) {
            return adf.getP2Set();
        }
        pn = pn.getRepresentative();
        PointsToSetInternal ptSet = adf.makeP2Set();
        for (AllocNode obj : pn.getRepresentative().get_all_points_to_objects()) {
            ptSet.add(obj);
        }
        return ptSet;
    }
}

