/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.PlainConstraint;
import soot.jimple.spark.geom.geomPA.ZArrayNumberer;
import soot.jimple.spark.geom.geomPA.off_graph_edge;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineProcessor {
    private boolean visitedFlag;
    GeomPointsTo ptAnalyzer;
    ZArrayNumberer<IVarAbstraction> int2var;
    ArrayList<off_graph_edge> varGraph;
    int[] pre;
    int[] low;
    int[] count;
    int[] rep;
    int[] repsize;
    boolean[] usefulVar;
    Deque<Integer> queue;
    int pre_cnt;
    int n_var;

    public OfflineProcessor(int size, GeomPointsTo pta) {
        this.ptAnalyzer = pta;
        this.int2var = this.ptAnalyzer.pointers;
        this.n_var = size;
        this.varGraph = new ArrayList(size);
        this.queue = new LinkedList<Integer>();
        this.pre = new int[size];
        this.low = new int[size];
        this.count = new int[size];
        this.rep = new int[size];
        this.repsize = new int[size];
        this.usefulVar = new boolean[this.n_var];
        for (int i = 0; i < size; ++i) {
            this.varGraph.add(null);
            this.rep[i] = i;
            this.repsize[i] = 1;
        }
    }

    public void runOptimizations(Set<Node> virtualBaseSet) {
        this.buildInstanceAssignmentGraph();
        this.setAllUserCodeVariablesUseful(virtualBaseSet);
        this.eliminateUselessConstraints();
        this.cleanSparkResults();
        this.buildSymbolicAssignmentGraph();
        this.makeTopologicalOrder();
        this.mergeLocalVariables();
        this.destroy();
    }

    public void recleanConstraints() {
        for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            int sm_int;
            if (!cons.isViable) continue;
            Node lhs = cons.expr.getO1().getWrappedNode();
            Node rhs = cons.expr.getO2().getWrappedNode();
            SootMethod sm = null;
            boolean deleted = false;
            if (lhs instanceof LocalVarNode) {
                sm = ((LocalVarNode)lhs).getMethod();
            }
            if (rhs instanceof LocalVarNode) {
                sm = ((LocalVarNode)rhs).getMethod();
            }
            if (sm != null && !this.ptAnalyzer.isReachableMethod(sm_int = this.ptAnalyzer.getIDFromSootMethod(sm))) {
                deleted = true;
            }
            if (!deleted) continue;
            cons.isViable = false;
        }
    }

    protected void buildInstanceAssignmentGraph() {
        for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            final IVarAbstraction lhs = cons.expr.getO1();
            final IVarAbstraction rhs = cons.expr.getO2();
            final SparkField field = cons.f;
            switch (cons.type) {
                case 1: {
                    this.add_graph_edge(rhs.id, lhs.id);
                    break;
                }
                case 2: {
                    lhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                        public void visit(Node n) {
                            AllocDotField adf = OfflineProcessor.this.ptAnalyzer.findAllocDotField((AllocNode)n, field);
                            IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.getInternalNode(adf);
                            off_graph_edge e = OfflineProcessor.this.add_graph_edge(rhs.id, padf.id);
                            e.base_var = lhs.id;
                        }
                    });
                    break;
                }
                case 3: {
                    rhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                        public void visit(Node n) {
                            AllocDotField adf = OfflineProcessor.this.ptAnalyzer.findAllocDotField((AllocNode)n, field);
                            IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.getInternalNode(adf);
                            off_graph_edge e = OfflineProcessor.this.add_graph_edge(padf.id, lhs.id);
                            e.base_var = rhs.id;
                        }
                    });
                }
            }
        }
    }

    protected void destroy() {
        this.pre = null;
        this.low = null;
        this.count = null;
        this.usefulVar = null;
        this.rep = null;
        this.repsize = null;
        this.varGraph = null;
        this.queue = null;
    }

    protected void setUsefulVariables(Set<Node> initVars) {
        this.queue.clear();
        for (int i = 0; i < this.n_var; ++i) {
            this.usefulVar[i] = false;
            IVarAbstraction node = (IVarAbstraction)this.int2var.get(i);
            if (!initVars.contains(node.getWrappedNode())) continue;
            this.queue.add(i);
        }
    }

    protected void setAllUserCodeVariablesUseful(Set<Node> virtualBaseSet) {
        this.queue.clear();
        for (int i = 0; i < this.n_var; ++i) {
            this.usefulVar[i] = false;
            Node node = ((IVarAbstraction)this.int2var.get(i)).getWrappedNode();
            if (!(node instanceof VarNode)) continue;
            boolean defined_in_lib = false;
            if (node instanceof LocalVarNode) {
                defined_in_lib = ((LocalVarNode)node).getMethod().isJavaLibraryMethod();
            } else if (node instanceof GlobalVarNode) {
                SootClass sc = ((GlobalVarNode)node).getDeclaringClass();
                if (sc != null) {
                    defined_in_lib = sc.isJavaLibraryClass();
                }
            } else if (!virtualBaseSet.contains(node)) {
                defined_in_lib = true;
            }
            if (defined_in_lib) continue;
            this.queue.add(i);
            this.usefulVar[i] = true;
        }
    }

    protected void eliminateUselessConstraints() {
        while (!this.queue.isEmpty()) {
            int i = this.queue.getFirst();
            this.queue.removeFirst();
            off_graph_edge p = this.varGraph.get(i);
            while (p != null) {
                if (!this.usefulVar[p.t]) {
                    this.usefulVar[p.t] = true;
                    this.queue.add(p.t);
                }
                if (p.base_var != -1 && !this.usefulVar[p.base_var]) {
                    this.usefulVar[p.base_var] = true;
                    this.queue.add(p.base_var);
                }
                p = p.next;
            }
        }
        for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            IVarAbstraction rhs = cons.expr.getO2();
            final SparkField field = cons.f;
            this.visitedFlag = false;
            switch (cons.type) {
                case 0: 
                case 1: 
                case 2: {
                    this.visitedFlag = this.usefulVar[rhs.id];
                    break;
                }
                case 3: {
                    this.visitedFlag = false;
                    rhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                        public void visit(Node n) {
                            if (!OfflineProcessor.this.visitedFlag) {
                                AllocDotField adf = OfflineProcessor.this.ptAnalyzer.findAllocDotField((AllocNode)n, field);
                                IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.getInternalNode(adf);
                                OfflineProcessor.this.visitedFlag = OfflineProcessor.this.visitedFlag || OfflineProcessor.this.usefulVar[padf.id];
                            }
                        }
                    });
                }
            }
            cons.isViable = this.visitedFlag;
        }
    }

    protected void cleanSparkResults() {
        if (this.ptAnalyzer.getOpts().geom_eval() > 0) {
            return;
        }
        for (int i = 0; i < this.n_var; ++i) {
            if (!this.usefulVar[i]) continue;
            IVarAbstraction node = (IVarAbstraction)this.int2var.get(i);
            node.getWrappedNode().discardP2Set();
        }
        this.ptAnalyzer.cleanPAG();
    }

    protected void buildSymbolicAssignmentGraph() {
        for (int i = 0; i < this.n_var; ++i) {
            this.varGraph.set(i, null);
        }
        this.queue.clear();
        for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            if (!cons.isViable) continue;
            final IVarAbstraction lhs = cons.expr.getO1();
            final IVarAbstraction rhs = cons.expr.getO2();
            final SparkField field = cons.f;
            switch (cons.type) {
                case 0: {
                    this.queue.add(rhs.id);
                    break;
                }
                case 1: {
                    this.add_graph_edge(lhs.id, rhs.id);
                    break;
                }
                case 2: {
                    lhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                        public void visit(Node n) {
                            AllocDotField adf = OfflineProcessor.this.ptAnalyzer.findAllocDotField((AllocNode)n, field);
                            IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.getInternalNode(adf);
                            OfflineProcessor.this.add_graph_edge(padf.id, rhs.id);
                        }
                    });
                    break;
                }
                case 3: {
                    rhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                        public void visit(Node n) {
                            AllocDotField adf = OfflineProcessor.this.ptAnalyzer.findAllocDotField((AllocNode)n, field);
                            IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.getInternalNode(adf);
                            OfflineProcessor.this.add_graph_edge(lhs.id, padf.id);
                        }
                    });
                }
            }
        }
    }

    protected void makeTopologicalOrder() {
        IVarAbstraction node;
        int t;
        int s;
        off_graph_edge p;
        int i;
        this.pre_cnt = 0;
        for (i = 0; i < this.n_var; ++i) {
            this.pre[i] = -1;
            this.count[i] = 0;
        }
        for (i = 0; i < this.n_var; ++i) {
            if (this.pre[i] != -1) continue;
            this.tarjan_scc(i);
        }
        for (i = 0; i < this.n_var; ++i) {
            p = this.varGraph.get(i);
            s = this.find_parent(i);
            while (p != null) {
                t = this.find_parent(p.t);
                if (t != s) {
                    int n = t;
                    this.count[n] = this.count[n] + 1;
                }
                p = p.next;
            }
        }
        for (i = 0; i < this.n_var; ++i) {
            p = this.varGraph.get(i);
            if (p == null || this.rep[i] == i) continue;
            t = this.find_parent(i);
            while (p.next != null) {
                p = p.next;
            }
            p.next = this.varGraph.get(t);
            this.varGraph.set(t, this.varGraph.get(i));
            this.varGraph.set(i, null);
        }
        this.queue.clear();
        for (i = 0; i < this.n_var; ++i) {
            if (this.rep[i] != i || this.count[i] != 0) continue;
            this.queue.addLast(i);
        }
        i = 0;
        while (!this.queue.isEmpty()) {
            s = this.queue.getFirst();
            this.queue.removeFirst();
            node = (IVarAbstraction)this.int2var.get(s);
            node.top_value = i;
            i += this.repsize[s];
            p = this.varGraph.get(s);
            while (p != null) {
                t = this.find_parent(p.t);
                if (t != s) {
                    int n = t;
                    this.count[n] = this.count[n] - 1;
                    if (this.count[n] == 0) {
                        this.queue.addLast(t);
                    }
                }
                p = p.next;
            }
        }
        for (i = this.n_var - 1; i > -1; --i) {
            if (this.rep[i] == i) continue;
            node = (IVarAbstraction)this.int2var.get(this.find_parent(i));
            IVarAbstraction me = (IVarAbstraction)this.int2var.get(i);
            me.top_value = node.top_value + this.repsize[node.id] - 1;
            int n = node.id;
            this.repsize[n] = this.repsize[n] - 1;
        }
    }

    protected void mergeLocalVariables() {
        for (int i = 0; i < this.n_var; ++i) {
            off_graph_edge p = this.varGraph.get(i);
            while (p != null) {
                int n = p.t;
                this.count[n] = this.count[n] + 1;
                p = p.next;
            }
        }
        while (!this.queue.isEmpty()) {
            int id;
            int n = id = this.queue.removeFirst().intValue();
            this.count[n] = this.count[n] + 1;
        }
        for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            SootMethod sm2;
            SootMethod sm1;
            if (!cons.isViable || cons.type != 1) continue;
            IVarAbstraction my_lhs = cons.expr.getO1();
            IVarAbstraction my_rhs = cons.expr.getO2();
            Node lhs = my_lhs.getWrappedNode();
            Node rhs = my_rhs.getWrappedNode();
            if (!(lhs instanceof LocalVarNode) || !(rhs instanceof LocalVarNode) || (sm1 = ((LocalVarNode)lhs).getMethod()) != (sm2 = ((LocalVarNode)rhs).getMethod()) || this.count[my_rhs.id] != 1 || lhs.getType() != rhs.getType()) continue;
            my_rhs.merge(my_lhs);
            cons.isViable = false;
        }
    }

    private off_graph_edge add_graph_edge(int s, int t) {
        off_graph_edge e = new off_graph_edge();
        e.s = s;
        e.t = t;
        e.next = this.varGraph.get(s);
        this.varGraph.set(s, e);
        return e;
    }

    private void tarjan_scc(int s) {
        int t;
        ++this.pre_cnt;
        this.pre[s] = this.low[s];
        this.queue.addLast(s);
        off_graph_edge p = this.varGraph.get(s);
        while (p != null) {
            t = p.t;
            if (this.pre[t] == -1) {
                this.tarjan_scc(t);
            }
            if (this.low[t] < this.low[s]) {
                this.low[s] = this.low[t];
            }
            p = p.next;
        }
        if (this.low[s] < this.pre[s]) {
            return;
        }
        int w = s;
        do {
            t = this.queue.getLast();
            this.queue.removeLast();
            int n = t;
            this.low[n] = this.low[n] + this.n_var;
            w = this.merge_nodes(w, t);
        } while (t != s);
    }

    private int find_parent(int v) {
        return v == this.rep[v] ? v : this.find_parent(this.rep[v]);
    }

    private int merge_nodes(int v1, int v2) {
        if ((v1 = this.find_parent(v1)) != (v2 = this.find_parent(v2))) {
            if (this.repsize[v1] < this.repsize[v2]) {
                int t = v1;
                v1 = v2;
                v2 = t;
            }
            this.rep[v2] = v1;
            int n = v1;
            this.repsize[n] = this.repsize[n] + this.repsize[v2];
        }
        return v1;
    }
}

