/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import soot.SootMethod;
import soot.jimple.spark.geom.geomPA.CallsiteContextVar;
import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.ZArrayNumberer;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;

public class PointsToDumper {
    public static void dump_spark_result(GeomPointsTo ptsProvider) {
        try {
            final PrintWriter file = new PrintWriter(new FileOutputStream(new File("pags", ptsProvider.dump_file_name + ".txt")));
            file.println(ptsProvider.pointers.size() + " " + ptsProvider.getAllocNodeNumberer().size());
            for (IVarAbstraction pn : ptsProvider.pointers) {
                pn = pn.getRepresentative();
                Node node = pn.getWrappedNode();
                PointsToSetInternal p2set = node.getP2Set();
                p2set.flushNew();
                file.print(p2set.size());
                p2set.forall(new P2SetVisitor(){

                    public final void visit(Node n) {
                        file.print(" " + (((AllocNode)n).getNumber() - 1));
                    }
                });
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public static void dump_context_insensitive_mapped_result(GeomPointsTo ptsProvider) {
        try {
            PrintWriter file = new PrintWriter(new FileOutputStream(new File("pags", ptsProvider.dump_file_name + ".ptm")));
            file.println(ptsProvider.getNumberOfPointers() + " " + ptsProvider.getNumberOfObjects());
            for (IVarAbstraction pn : ptsProvider.pointers) {
                pn = pn.getRepresentative();
                file.print(pn.get_all_points_to_objects().size());
                for (AllocNode obj : pn.get_all_points_to_objects()) {
                    file.print(" " + (obj.getNumber() - 1));
                }
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public static void dump_pointer_1cfa_object_insensitive_mapped_result(GeomPointsTo ptsProvider) {
        ArrayList<AllocNode> list = new ArrayList<AllocNode>();
        try {
            int sm_int;
            SootMethod sm;
            LocalVarNode lvn;
            Node v;
            PrintWriter file = new PrintWriter(new FileOutputStream(new File("pags", ptsProvider.dump_file_name + ".ptm")));
            int var_num = 0;
            for (IVarAbstraction pn : ptsProvider.pointers) {
                v = (pn = pn.getRepresentative()).getWrappedNode();
                if (v instanceof LocalVarNode) {
                    lvn = (LocalVarNode)v;
                    sm = lvn.getMethod();
                    sm_int = ptsProvider.getIDFromSootMethod(sm);
                    var_num += ptsProvider.getCallEdgesInto(sm_int).size();
                    continue;
                }
                ++var_num;
            }
            file.println(var_num + " " + ptsProvider.getNumberOfObjects());
            for (IVarAbstraction pn : ptsProvider.pointers) {
                v = (pn = pn.getRepresentative()).getWrappedNode();
                if (v instanceof LocalVarNode) {
                    lvn = (LocalVarNode)v;
                    sm = lvn.getMethod();
                    sm_int = ptsProvider.getIDFromSootMethod(sm);
                    LinkedList<CgEdge> edges = ptsProvider.getCallEdgesInto(sm_int);
                    for (CgEdge p : edges) {
                        long l = p.map_offset;
                        long r = l + ptsProvider.max_context_size_block[p.s];
                        list.clear();
                        for (AllocNode obj : pn.get_all_points_to_objects()) {
                            if (!pn.pointer_interval_points_to(l, r, obj)) continue;
                            list.add(obj);
                        }
                        file.print(list.size());
                        Iterator obj_it = list.iterator();
                        while (obj_it.hasNext()) {
                            file.print(" " + (((AllocNode)obj_it.next()).getNumber() - 1));
                        }
                        file.println();
                    }
                    continue;
                }
                file.print(pn.get_all_points_to_objects().size());
                Iterator<AllocNode> it = pn.get_all_points_to_objects().iterator();
                while (it.hasNext()) {
                    file.print(" " + (it.next().getNumber() - 1));
                }
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public static void dump_pointer_insensitive_object_1cfa_mapped_result(GeomPointsTo ptsProvider) {
        ZArrayNumberer<CallsiteContextVar> ct_sens_objs = new ZArrayNumberer<CallsiteContextVar>();
        Vector<CallsiteContextVar> outList = new Vector<CallsiteContextVar>();
        CallsiteContextVar context_obj = null;
        try {
            PrintWriter file = new PrintWriter(new FileOutputStream(new File("pags", ptsProvider.dump_file_name + ".ptm")));
            int var_num = 0;
            int obj_num = 0;
            for (IVarAbstraction pn : ptsProvider.pointers) {
                if (pn != pn.getRepresentative()) continue;
                ++var_num;
            }
            for (IVarAbstraction pobj : ptsProvider.allocations) {
                AllocNode obj = (AllocNode)pobj.getWrappedNode();
                SootMethod sm = obj.getMethod();
                if (sm == null) {
                    ++obj_num;
                    context_obj = new CallsiteContextVar(null, obj);
                    ct_sens_objs.add(context_obj);
                    continue;
                }
                int sm_int = ptsProvider.getIDFromSootMethod(sm);
                if (!ptsProvider.isReachableMethod(sm_int)) continue;
                LinkedList<CgEdge> edges = ptsProvider.getCallEdgesInto(sm_int);
                obj_num += edges.size();
                for (CgEdge ce : edges) {
                    context_obj = new CallsiteContextVar(ce, obj);
                    ct_sens_objs.add(context_obj);
                }
            }
            file.println(1);
            file.println(var_num + " " + obj_num);
            for (IVarAbstraction pn : ptsProvider.pointers) {
                if (pn != pn.getRepresentative()) continue;
                file.print(pn.get_all_context_sensitive_objects(1L, 0x7FFFFFFFFFFFFFFEL, ct_sens_objs, outList));
                for (CallsiteContextVar cobj : outList) {
                    cobj.inQ = false;
                    file.print(" " + cobj.getNumber());
                }
                file.println();
            }
            obj_num = ptsProvider.getNumberOfObjects();
            file.println(obj_num);
            int i = 1;
            int j = 0;
            do {
                CallsiteContextVar first_obj = (CallsiteContextVar)ct_sens_objs.get(j);
                while (i < obj_num) {
                    CallsiteContextVar cobj;
                    cobj = (CallsiteContextVar)ct_sens_objs.get(i);
                    if (cobj.var != first_obj.var) break;
                    ++i;
                }
                file.print(i - j);
                while (j < i) {
                    file.print(" " + j);
                    ++j;
                }
                file.println();
            } while (i != obj_num);
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public static void dump_pointer_object_1cfa_mapped_result(GeomPointsTo ptsProvider) {
        ZArrayNumberer<CallsiteContextVar> ct_sens_objs = new ZArrayNumberer<CallsiteContextVar>();
        Vector<CallsiteContextVar> outList = new Vector<CallsiteContextVar>();
        CallsiteContextVar context_obj = null;
        try {
            int sm_int;
            SootMethod sm;
            LocalVarNode lvn;
            Node v;
            PrintWriter file = new PrintWriter(new FileOutputStream(new File("pags", ptsProvider.dump_file_name + ".ptm")));
            int var_num = 0;
            int obj_num = 0;
            for (IVarAbstraction pn : ptsProvider.pointers) {
                if (pn != pn.getRepresentative()) continue;
                v = pn.getWrappedNode();
                if (v instanceof LocalVarNode) {
                    lvn = (LocalVarNode)v;
                    sm = lvn.getMethod();
                    sm_int = ptsProvider.getIDFromSootMethod(sm);
                    var_num += ptsProvider.getCallEdgesInto(sm_int).size();
                    continue;
                }
                ++var_num;
            }
            for (IVarAbstraction pobj : ptsProvider.allocations) {
                AllocNode obj = (AllocNode)pobj.getWrappedNode();
                SootMethod sm2 = obj.getMethod();
                if (sm2 == null) {
                    ++obj_num;
                    context_obj = new CallsiteContextVar(null, obj);
                    ct_sens_objs.add(context_obj);
                    continue;
                }
                sm_int = ptsProvider.getIDFromSootMethod(sm2);
                if (!ptsProvider.isReachableMethod(sm_int)) continue;
                LinkedList<CgEdge> edges = ptsProvider.getCallEdgesInto(sm_int);
                obj_num += edges.size();
                for (CgEdge ce : edges) {
                    context_obj = new CallsiteContextVar(ce, obj);
                    ct_sens_objs.add(context_obj);
                }
            }
            file.println(var_num + " " + obj_num);
            for (IVarAbstraction pn : ptsProvider.pointers) {
                if (pn != pn.getRepresentative()) continue;
                v = pn.getWrappedNode();
                if (v instanceof LocalVarNode) {
                    lvn = (LocalVarNode)v;
                    sm = lvn.getMethod();
                    sm_int = ptsProvider.getIDFromSootMethod(sm);
                    LinkedList<CgEdge> edges = ptsProvider.getCallEdgesInto(sm_int);
                    for (CgEdge p : edges) {
                        long l = p.map_offset;
                        long r = l + ptsProvider.max_context_size_block[p.s];
                        file.print(pn.get_all_context_sensitive_objects(l, r, ct_sens_objs, outList));
                        for (CallsiteContextVar cobj : outList) {
                            cobj.inQ = false;
                            file.print(" " + cobj.getNumber());
                        }
                        file.println();
                    }
                    continue;
                }
                file.print(pn.get_all_context_sensitive_objects(1L, 0x7FFFFFFFFFFFFFFEL, ct_sens_objs, outList));
                for (CallsiteContextVar cobj : outList) {
                    cobj.inQ = false;
                    file.print(" " + cobj.getNumber());
                }
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }
}

