/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.util.IterableNumberer;
import soot.util.Numberable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZArrayNumberer<E extends Numberable>
implements IterableNumberer<E>,
Iterable<E> {
    Numberable[] numberToObj = new Numberable[1024];
    Map<E, E> objContainer = new HashMap<E, E>();
    int lastNumber = 0;
    int filledCells = 0;

    @Override
    public void add(E o) {
        if (o.getNumber() != -1 && this.numberToObj[o.getNumber()] == o) {
            return;
        }
        this.numberToObj[this.lastNumber] = o;
        o.setNumber(this.lastNumber);
        this.objContainer.put(o, o);
        ++this.lastNumber;
        ++this.filledCells;
        if (this.lastNumber >= this.numberToObj.length) {
            Numberable[] newnto = new Numberable[this.numberToObj.length * 2];
            System.arraycopy(this.numberToObj, 0, newnto, 0, this.numberToObj.length);
            this.numberToObj = newnto;
        }
    }

    public void clear() {
        for (int i = 0; i < this.lastNumber; ++i) {
            this.numberToObj[i] = null;
        }
        this.lastNumber = 0;
        this.filledCells = 0;
        this.objContainer.clear();
    }

    @Override
    public long get(E o) {
        if (o == null) {
            return -1L;
        }
        return o.getNumber();
    }

    @Override
    public E get(long number) {
        Numberable ret = this.numberToObj[(int)number];
        return (E)ret;
    }

    public E searchFor(E o) {
        return (E)((Numberable)this.objContainer.get(o));
    }

    public boolean remove(E o) {
        int id = o.getNumber();
        if (id < 0) {
            return false;
        }
        if (this.numberToObj[id] != o) {
            return false;
        }
        this.numberToObj[id] = null;
        o.setNumber(-1);
        --this.filledCells;
        return true;
    }

    @Override
    public int size() {
        return this.filledCells;
    }

    @Override
    public Iterator<E> iterator() {
        return new NumbererIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class NumbererIterator
    implements Iterator<E> {
        int cur = 0;

        NumbererIterator() {
        }

        @Override
        public final boolean hasNext() {
            while (this.cur < ZArrayNumberer.this.lastNumber && ZArrayNumberer.this.numberToObj[this.cur] == null) {
                ++this.cur;
            }
            return this.cur < ZArrayNumberer.this.lastNumber;
        }

        @Override
        public final E next() {
            return ZArrayNumberer.this.numberToObj[this.cur++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

