/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.heapinsE;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import soot.Type;
import soot.jimple.spark.geom.geomPA.CallsiteContextVar;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.IWorklist;
import soot.jimple.spark.geom.geomPA.PlainConstraint;
import soot.jimple.spark.geom.geomPA.SegmentNode;
import soot.jimple.spark.geom.geomPA.ZArrayNumberer;
import soot.jimple.spark.geom.heapinsE.HeapInsIntervalManager;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.StringConstantNode;
import soot.util.Numberable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapInsNode
extends IVarAbstraction {
    public HashMap<HeapInsNode, HeapInsIntervalManager> flowto;
    public HashMap<AllocNode, HeapInsIntervalManager> pt_objs;
    public Map<AllocNode, HeapInsIntervalManager> new_pts;
    public Vector<PlainConstraint> complex_cons = null;
    public int compact_budget_rep;

    public HeapInsNode(Node thisVar) {
        this.me = thisVar;
        this.flowto = new HashMap();
        this.pt_objs = new HashMap();
        this.new_pts = new HashMap<AllocNode, HeapInsIntervalManager>();
        int size = this.me.getP2Set().size();
        this.compact_budget_rep = size <= 10 ? GeomPointsTo.max_pts_budget / 3 : (size <= 50 ? GeomPointsTo.max_pts_budget * 2 / 3 : GeomPointsTo.max_cons_budget);
    }

    @Override
    public void reconstruct() {
        this.new_pts = new HashMap<AllocNode, HeapInsIntervalManager>();
        if (this.complex_cons != null) {
            this.complex_cons.clear();
        }
        if (this.flowto != null) {
            for (HeapInsIntervalManager him : this.flowto.values()) {
                him.clear();
            }
        }
        if (this.pt_objs != null) {
            for (HeapInsIntervalManager him : this.pt_objs.values()) {
                him.clear();
            }
        }
    }

    @Override
    public void do_before_propagation() {
        if (this.complex_cons == null) {
            this.do_pts_interval_merge();
        }
        if (!(this.me instanceof LocalVarNode)) {
            this.do_flow_edge_interval_merge();
        }
    }

    @Override
    public void do_after_propagation() {
        for (HeapInsIntervalManager im : this.new_pts.values()) {
            im.flush();
        }
        this.new_pts = new HashMap<AllocNode, HeapInsIntervalManager>();
    }

    @Override
    public boolean is_empty() {
        return this.pt_objs.size() == 0;
    }

    @Override
    public boolean has_new_pts() {
        return this.new_pts.size() != 0;
    }

    @Override
    public int num_of_diff_objs() {
        return this.pt_objs.size();
    }

    @Override
    public int num_of_diff_edges() {
        return this.flowto.size();
    }

    @Override
    public boolean add_points_to_3(AllocNode obj, long I1, long I2, long L) {
        SegmentNode p;
        HeapInsIntervalManager im = this.pt_objs.get(obj);
        if (im == null) {
            im = new HeapInsIntervalManager();
            this.pt_objs.put(obj, im);
        }
        if ((p = im.add_new_interval(I1, I2, L)) != null) {
            this.new_pts.put(obj, im);
            return true;
        }
        return false;
    }

    @Override
    public boolean add_points_to_4(AllocNode obj, long I1, long I2, long L1, long L2) {
        return false;
    }

    @Override
    public boolean add_simple_constraint_3(IVarAbstraction qv, long I1, long I2, long L) {
        HeapInsIntervalManager im = this.flowto.get(qv);
        if (im == null) {
            im = new HeapInsIntervalManager();
            this.flowto.put((HeapInsNode)qv, im);
        }
        return im.add_new_interval(I1, I2, L) != null;
    }

    @Override
    public boolean add_simple_constraint_4(IVarAbstraction qv, long I1, long I2, long L1, long L2) {
        return false;
    }

    @Override
    public void put_complex_constraint(PlainConstraint cons) {
        if (this.complex_cons == null) {
            this.complex_cons = new Vector();
        }
        this.complex_cons.add(cons);
    }

    @Override
    public void drop_duplicates() {
        Iterator<AllocNode> it = this.pt_objs.keySet().iterator();
        while (it.hasNext()) {
            HeapInsIntervalManager im = this.pt_objs.get(it.next());
            im.remove_useless_intervals();
        }
    }

    @Override
    public void propagate(GeomPointsTo ptAnalyzer, IWorklist worklist) {
        SegmentNode pts;
        int i;
        HeapInsNode qn;
        SegmentNode[] int_entry1;
        AllocNode obj;
        if (this.complex_cons != null) {
            for (Map.Entry<Numberable, HeapInsIntervalManager> entry : this.new_pts.entrySet()) {
                obj = (AllocNode)entry.getKey();
                int_entry1 = entry.getValue().get_intervals();
                for (PlainConstraint pcons : this.complex_cons) {
                    HeapInsNode objn = (HeapInsNode)ptAnalyzer.findAndInsertInstanceField(obj, pcons.f);
                    qn = (HeapInsNode)pcons.otherSide;
                    for (i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                        pts = int_entry1[i];
                        while (pts != null && pts.is_new) {
                            switch (pcons.type) {
                                case 3: {
                                    if (!qn.add_simple_constraint_3(objn, pcons.code == 0 ? pts.I1 : 0L, pts.I2, pts.L < 0L ? -pts.L : pts.L)) break;
                                    worklist.push(qn);
                                    break;
                                }
                                case 2: {
                                    if (!objn.add_simple_constraint_3(qn, pts.I2, pcons.code == 0 ? pts.I1 : 0L, pts.L < 0L ? -pts.L : pts.L)) break;
                                    worklist.push(objn);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("Wrong Complex Constraint");
                                }
                            }
                            pts = pts.next;
                        }
                    }
                }
            }
        }
        for (Map.Entry<Numberable, HeapInsIntervalManager> entry : this.flowto.entrySet()) {
            boolean added = false;
            qn = (HeapInsNode)entry.getKey();
            HeapInsIntervalManager him = entry.getValue();
            SegmentNode[] int_entry2 = him.get_intervals();
            boolean has_new_edges = him.isThereUnprocessedObject();
            Map<AllocNode, HeapInsIntervalManager> objs = has_new_edges ? this.pt_objs : this.new_pts;
            for (Map.Entry<AllocNode, HeapInsIntervalManager> entry2 : objs.entrySet()) {
                obj = entry2.getKey();
                if (!ptAnalyzer.castNeverFails(obj.getType(), qn.getWrappedNode().getType())) continue;
                int_entry1 = entry2.getValue().get_intervals();
                for (i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                    pts = int_entry1[i];
                    while (pts != null && (has_new_edges || pts.is_new)) {
                        for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
                            SegmentNode pe = int_entry2[j];
                            while (pe != null && (pts.is_new || pe.is_new)) {
                                if (this.add_new_points_to_tuple(pts, pe, obj, qn)) {
                                    added = true;
                                }
                                pe = pe.next;
                            }
                        }
                        pts = pts.next;
                    }
                }
            }
            if (added) {
                worklist.push(qn);
            }
            if (!has_new_edges) continue;
            him.flush();
        }
    }

    @Override
    public int count_pts_intervals(AllocNode obj) {
        int ret = 0;
        SegmentNode[] int_entry = this.find_points_to(obj);
        for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
            SegmentNode p = int_entry[j];
            while (p != null) {
                ++ret;
                p = p.next;
            }
        }
        return ret;
    }

    @Override
    public int count_flow_intervals(IVarAbstraction qv) {
        int ret = 0;
        SegmentNode[] int_entry = this.find_flowto((HeapInsNode)qv);
        for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
            SegmentNode p = int_entry[j];
            while (p != null) {
                ++ret;
                p = p.next;
            }
        }
        return ret;
    }

    @Override
    public boolean heap_sensitive_intersection(IVarAbstraction qv) {
        HeapInsNode qn = (HeapInsNode)qv;
        for (AllocNode an : this.pt_objs.keySet()) {
            SegmentNode[] qt;
            if (an instanceof StringConstantNode || (qt = qn.find_points_to(an)) == null) continue;
            SegmentNode[] pt = this.find_points_to(an);
            for (int i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                SegmentNode p = pt[i];
                while (p != null) {
                    for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
                        SegmentNode q = qt[j];
                        while (q != null) {
                            if (this.quick_intersecting_test(p, q)) {
                                return true;
                            }
                            q = q.next;
                        }
                    }
                    p = p.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean pointer_sensitive_points_to(long context, AllocNode obj) {
        SegmentNode[] int_entry = this.find_points_to(obj);
        if (int_entry[0] != null) {
            return true;
        }
        for (int i = 1; i < HeapInsIntervalManager.Divisions; ++i) {
            SegmentNode p = int_entry[i];
            while (p != null) {
                if (p.I1 <= context && p.I1 + p.L > context) {
                    return true;
                }
                p = p.next;
            }
        }
        return false;
    }

    @Override
    public boolean test_points_to_has_types(Set<Type> types) {
        for (AllocNode an : this.pt_objs.keySet()) {
            if (!types.contains(an.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<AllocNode> get_all_points_to_objects() {
        return this.pt_objs.keySet();
    }

    @Override
    public void print_context_sensitive_points_to(PrintStream outPrintStream) {
        for (AllocNode obj : this.pt_objs.keySet()) {
            SegmentNode[] int_entry = this.find_points_to(obj);
            for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
                SegmentNode p = int_entry[j];
                while (p != null) {
                    outPrintStream.println("(" + obj.toString() + ", " + p.I1 + ", " + p.I2 + ", " + p.L + ")");
                    p = p.next;
                }
            }
        }
    }

    private SegmentNode[] find_flowto(HeapInsNode qv) {
        HeapInsIntervalManager im = this.flowto.get(qv);
        if (im == null) {
            return null;
        }
        return im.get_intervals();
    }

    private SegmentNode[] find_points_to(AllocNode obj) {
        HeapInsIntervalManager im = this.pt_objs.get(obj);
        if (im == null) {
            return null;
        }
        return im.get_intervals();
    }

    private void do_pts_interval_merge() {
        for (HeapInsIntervalManager him : this.new_pts.values()) {
            him.merge_points_to_tuples(this.compact_budget_rep);
        }
    }

    private void do_flow_edge_interval_merge() {
        for (HeapInsIntervalManager him : this.flowto.values()) {
            if (!him.isThereUnprocessedObject()) continue;
            him.merge_flow_edges();
        }
    }

    private boolean add_new_points_to_tuple(SegmentNode pts, SegmentNode pe, AllocNode obj, HeapInsNode qn) {
        long interJ;
        long eL;
        long L = pts.L < 0L ? -pts.L : pts.L;
        long l = eL = pe.L < 0L ? -pe.L : pe.L;
        if (pts.I1 == 0L || pe.I1 == 0L) {
            if (pe.I2 != 0L) {
                if (pts.I2 != 0L && eL == L) {
                    return qn.add_points_to_3(obj, pe.I2, pts.I2, L == 1L ? 1L : -L);
                }
                return qn.add_points_to_3(obj, pe.I2, 0L, eL);
            }
            return qn.add_points_to_3(obj, 0L, pts.I2, L);
        }
        long interI = pe.I1 < pts.I1 ? pts.I1 : pe.I1;
        long l2 = interJ = pe.I1 + eL < pts.I1 + L ? pe.I1 + eL : pts.I1 + L;
        if (interI < interJ) {
            long Iqv = pe.I2 == 0L ? 0L : interI - pe.I1 + pe.I2;
            long Io = pts.I2 == 0L ? 0L : interI - pts.I1 + pts.I2;
            L = Iqv != 0L && Io != 0L && (pts.L < 0L || pe.L < 0L) ? interI - interJ : interJ - interI;
            return qn.add_points_to_3(obj, Iqv, Io, L);
        }
        return false;
    }

    private boolean quick_intersecting_test(SegmentNode p, SegmentNode q) {
        if (p.I2 == 0L || q.I2 == 0L) {
            return true;
        }
        if (p.I2 >= q.I2) {
            return p.I2 < q.I2 + (q.L < 0L ? -q.L : q.L);
        }
        return q.I2 < p.I2 + (p.L < 0L ? -p.L : p.L);
    }

    public void add_shapes_to_set(TreeSet<SegmentNode>[] ts) {
        SegmentNode p;
        int i;
        SegmentNode[] int_entry;
        Iterator<AllocNode> it_pts = this.pt_objs.keySet().iterator();
        while (it_pts.hasNext()) {
            int_entry = this.find_points_to(it_pts.next());
            for (i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                p = int_entry[i];
                while (p != null) {
                    ts[0].add(p);
                    p = p.next;
                }
            }
        }
        Iterator<HeapInsNode> it_flow = this.flowto.keySet().iterator();
        while (it_flow.hasNext()) {
            int_entry = this.find_flowto(it_flow.next());
            for (i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                p = int_entry[i];
                while (p != null) {
                    ts[0].add(p);
                    p = p.next;
                }
            }
        }
    }

    @Override
    public boolean pointer_interval_points_to(long l, long r, AllocNode obj) {
        return false;
    }

    @Override
    public void remove_points_to(AllocNode obj) {
    }

    @Override
    public void discard() {
        this.flowto = null;
        this.pt_objs = null;
        this.new_pts = null;
        this.complex_cons = null;
    }

    @Override
    public int count_new_pts_intervals() {
        return 0;
    }

    @Override
    public int get_all_context_sensitive_objects(long l, long r, ZArrayNumberer<CallsiteContextVar> all_objs, Vector<CallsiteContextVar> outList) {
        return 0;
    }
}

