/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.heapinsE;

import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.DummyNode;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IEncodingBroker;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.PlainConstraint;
import soot.jimple.spark.geom.heapinsE.HeapInsNode;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.toolkits.callgraph.Edge;

public class HeapInsNodeGenerator
extends IEncodingBroker {
    private static final int[] full_convertor = new int[]{0, 1, 1, 1};

    public IVarAbstraction generateNode(Node vNode) {
        IVarAbstraction ret = null;
        ret = vNode instanceof AllocNode || vNode instanceof FieldRefNode ? new DummyNode(vNode) : new HeapInsNode(vNode);
        return ret;
    }

    public int getEncodingType() {
        return 2;
    }

    public void initFlowGraph(GeomPointsTo ptAnalyzer) {
        int n_legal_cons = 0;
        for (PlainConstraint cons : ptAnalyzer.constraints) {
            if (!cons.isViable) continue;
            IVarAbstraction my_lhs = cons.expr.getO1().getRepresentative();
            IVarAbstraction my_rhs = cons.expr.getO2().getRepresentative();
            int nf1 = ptAnalyzer.getMappedMethodID(my_lhs.getWrappedNode());
            int nf2 = ptAnalyzer.getMappedMethodID(my_rhs.getWrappedNode());
            if (nf1 == -1 || nf2 == -1) {
                cons.isViable = false;
                continue;
            }
            int code = (nf1 == 0 ? 1 : 0) << 1 | (nf2 == 0 ? 1 : 0);
            switch (cons.type) {
                case 0: {
                    my_rhs.add_points_to_3((AllocNode)my_lhs.getWrappedNode(), (code & 1) == 1 ? 0L : 1L, code >> 1 == 1 ? 0L : 1L, (code & 1) == 1 ? ptAnalyzer.context_size[nf1] : ptAnalyzer.context_size[nf2]);
                    ptAnalyzer.getWorklist().push(my_rhs);
                    break;
                }
                case 1: {
                    if (cons.interCallEdges != null) {
                        for (Edge sEdge : cons.interCallEdges) {
                            int k;
                            CgEdge q = ptAnalyzer.getInternalEdgeFromSootEdge(sEdge);
                            if (q.is_obsoleted) continue;
                            if (nf2 == q.t) {
                                if (nf1 == 0) {
                                    my_lhs.add_simple_constraint_3(my_rhs, 0L, q.map_offset, ptAnalyzer.max_context_size_block[q.s]);
                                    continue;
                                }
                                if (q.s == q.t) {
                                    my_lhs.add_simple_constraint_3(my_rhs, 1L, 1L, ptAnalyzer.context_size[nf1]);
                                    continue;
                                }
                                for (k = 0; k < ptAnalyzer.block_num[nf1]; ++k) {
                                    my_lhs.add_simple_constraint_3(my_rhs, (long)k * ptAnalyzer.max_context_size_block[nf1] + 1L, q.map_offset, ptAnalyzer.max_context_size_block[nf1]);
                                }
                                continue;
                            }
                            if (q.s == q.t) {
                                my_lhs.add_simple_constraint_3(my_rhs, 1L, 1L, ptAnalyzer.context_size[nf2]);
                                continue;
                            }
                            for (k = 0; k < ptAnalyzer.block_num[nf2]; ++k) {
                                my_lhs.add_simple_constraint_3(my_rhs, q.map_offset, (long)k * ptAnalyzer.max_context_size_block[nf2] + 1L, ptAnalyzer.max_context_size_block[nf2]);
                            }
                        }
                        break;
                    }
                    my_lhs.add_simple_constraint_3(my_rhs, nf1 == 0 ? 0L : 1L, nf2 == 0 ? 0L : 1L, nf1 == 0 ? ptAnalyzer.context_size[nf2] : ptAnalyzer.context_size[nf1]);
                    break;
                }
                case 2: {
                    cons.code = full_convertor[code];
                    cons.otherSide = my_rhs;
                    my_lhs.put_complex_constraint(cons);
                    break;
                }
                case 3: {
                    cons.code = full_convertor[code];
                    cons.otherSide = my_lhs;
                    my_rhs.put_complex_constraint(cons);
                    break;
                }
                default: {
                    System.exit(-1);
                }
            }
            ++n_legal_cons;
        }
        ptAnalyzer.ps.println("We have " + n_legal_cons + " legal constraints at the beginning," + " occupies " + (double)n_legal_cons / (double)ptAnalyzer.constraints.size() + " of the total.");
    }
}

