/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand;

import java.util.Set;
import soot.Local;
import soot.PointsToSet;
import soot.Type;
import soot.jimple.ClassConstant;
import soot.jimple.spark.ondemand.DemandCSPointsTo;
import soot.jimple.spark.sets.EqualsSupportingPointsToSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyContextSensitivePointsToSet
implements EqualsSupportingPointsToSet {
    private EqualsSupportingPointsToSet delegate;
    private final DemandCSPointsTo demandCSPointsTo;
    private final Local local;
    private boolean isContextSensitive;

    public boolean isContextSensitive() {
        return this.isContextSensitive;
    }

    public LazyContextSensitivePointsToSet(Local l, EqualsSupportingPointsToSet contextInsensitiveSet, DemandCSPointsTo demandCSPointsTo) {
        this.local = l;
        this.delegate = contextInsensitiveSet;
        this.demandCSPointsTo = demandCSPointsTo;
        this.isContextSensitive = false;
    }

    @Override
    public boolean hasNonEmptyIntersection(PointsToSet other) {
        PointsToSet otherInner = other instanceof LazyContextSensitivePointsToSet ? ((LazyContextSensitivePointsToSet)other).delegate : other;
        if (this.delegate.hasNonEmptyIntersection(otherInner)) {
            if (other instanceof LazyContextSensitivePointsToSet) {
                ((LazyContextSensitivePointsToSet)other).computeContextSensitiveInfo();
                otherInner = ((LazyContextSensitivePointsToSet)other).delegate;
            }
            this.computeContextSensitiveInfo();
            return this.delegate.hasNonEmptyIntersection(otherInner);
        }
        return false;
    }

    public void computeContextSensitiveInfo() {
        if (!this.isContextSensitive) {
            this.delegate = (EqualsSupportingPointsToSet)this.demandCSPointsTo.doReachingObjects(this.local);
            this.isContextSensitive = true;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<ClassConstant> possibleClassConstants() {
        return this.delegate.possibleClassConstants();
    }

    @Override
    public Set<String> possibleStringConstants() {
        return this.delegate.possibleStringConstants();
    }

    @Override
    public Set<Type> possibleTypes() {
        return this.delegate.possibleTypes();
    }

    @Override
    public boolean pointsToSetEquals(Object other) {
        if (!(other instanceof LazyContextSensitivePointsToSet)) {
            return false;
        }
        return ((LazyContextSensitivePointsToSet)other).delegate.equals(this.delegate);
    }

    @Override
    public int pointsToSetHashCode() {
        return this.delegate.pointsToSetHashCode();
    }

    public EqualsSupportingPointsToSet getDelegate() {
        return this.delegate;
    }
}

