/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.factory.SootFactory;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.base.Zonation;
import soot.jimple.toolkits.base.Zone;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.UnitValueBoxPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregator
extends BodyTransformer {
    public Aggregator(Singletons.Global g) {
    }

    public static Aggregator v() {
        return SootFactory.v().getAggregator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map options) {
        StmtBody body = (StmtBody)b;
        boolean onlyStackVars = PhaseOptions.getBoolean(options, "only-stack-locals");
        int aggregateCount = 1;
        if (Options.v().time()) {
            Timers.v().aggregationTimer.start();
        }
        boolean changed = false;
        HashMap<ValueBox, Zone> boxToZone = new HashMap<ValueBox, Zone>(body.getUnits().size() * 2 + 1, 0.7f);
        Zonation zonation = new Zonation(body);
        for (Unit u : body.getUnits()) {
            Zone zone = zonation.getZoneOf(u);
            for (ValueBox box : u.getUseBoxes()) {
                boxToZone.put(box, zone);
            }
            for (ValueBox box : u.getDefBoxes()) {
                boxToZone.put(box, zone);
            }
        }
        do {
            if (Options.v().verbose()) {
                G.v().out.println("[" + body.getMethod().getName() + "] Aggregating iteration " + aggregateCount + "...");
            }
            changed = this.internalAggregate(body, boxToZone, onlyStackVars);
            ++aggregateCount;
        } while (changed);
        if (Options.v().time()) {
            Timers.v().aggregationTimer.end();
        }
    }

    protected boolean internalAggregate(StmtBody body, Map<ValueBox, Zone> boxToZone, boolean onlyStackVars) {
        boolean hadAggregation = false;
        PatchingChain<Unit> units = body.getUnits();
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body);
        SmartLocalDefs localDefs = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        SimpleLocalUses localUses = new SimpleLocalUses(graph, (LocalDefs)localDefs);
        for (Stmt stmt : new PseudoTopologicalOrderer<Unit>().newList(graph, false)) {
            Value aggregatee;
            List lu;
            Value lhs;
            if (!(stmt instanceof AssignStmt) || !((lhs = ((AssignStmt)stmt).getLeftOp()) instanceof Local) || onlyStackVars && !((Local)lhs).getName().startsWith("$") || (lu = localUses.getUsesOf(stmt)).size() != 1) continue;
            UnitValueBoxPair usepair = (UnitValueBoxPair)lu.get(0);
            Unit use = usepair.unit;
            ValueBox useBox = usepair.valueBox;
            List<Unit> ld = localDefs.getDefsOfAt((Local)lhs, use);
            if (ld.size() != 1 || boxToZone.get(((AssignStmt)stmt).getRightOpBox()) != boxToZone.get(usepair.valueBox)) continue;
            boolean cantAggr = false;
            boolean propagatingInvokeExpr = false;
            boolean propagatingFieldRef = false;
            boolean propagatingArrayRef = false;
            ArrayList<Value> fieldRefList = new ArrayList<Value>();
            LinkedList<Value> localsUsed = new LinkedList<Value>();
            Iterator<ValueBox> useIt = stmt.getUseBoxes().iterator();
            while (useIt.hasNext()) {
                Value v = useIt.next().getValue();
                if (v instanceof Local) {
                    localsUsed.add(v);
                    continue;
                }
                if (v instanceof InvokeExpr) {
                    propagatingInvokeExpr = true;
                    continue;
                }
                if (v instanceof ArrayRef) {
                    propagatingArrayRef = true;
                    continue;
                }
                if (!(v instanceof FieldRef)) continue;
                propagatingFieldRef = true;
                fieldRefList.add(v);
            }
            List<Unit> path = graph.getExtendedBasicBlockPathBetween(stmt, use);
            if (path == null) continue;
            Iterator<Unit> pathIt = path.iterator();
            if (pathIt.hasNext()) {
                pathIt.next();
            }
            block2: while (pathIt.hasNext() && !cantAggr) {
                Stmt between = (Stmt)pathIt.next();
                if (between != use) {
                    Iterator<ValueBox> it = between.getDefBoxes().iterator();
                    block3: while (it.hasNext()) {
                        Value v = it.next().getValue();
                        if (localsUsed.contains(v)) {
                            cantAggr = true;
                            break;
                        }
                        if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                        if (v instanceof FieldRef) {
                            if (propagatingInvokeExpr) {
                                cantAggr = true;
                                break;
                            }
                            if (!propagatingFieldRef) continue;
                            for (FieldRef fieldRef : fieldRefList) {
                                if (((FieldRef)v).getField() != fieldRef.getField()) continue;
                                cantAggr = true;
                                continue block3;
                            }
                            continue;
                        }
                        if (!(v instanceof ArrayRef)) continue;
                        if (propagatingInvokeExpr) {
                            cantAggr = true;
                            break;
                        }
                        if (!propagatingArrayRef) continue;
                        cantAggr = true;
                        break;
                    }
                    if (propagatingInvokeExpr && between instanceof MonitorStmt) {
                        cantAggr = true;
                    }
                }
                if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                for (ValueBox box : between.getUseBoxes()) {
                    if (between == use && box == useBox) continue block2;
                    Value v = box.getValue();
                    if (!(v instanceof InvokeExpr) && (!propagatingInvokeExpr || !(v instanceof FieldRef) && !(v instanceof ArrayRef))) continue;
                    cantAggr = true;
                    continue block2;
                }
            }
            if (cantAggr || !usepair.valueBox.canContainValue(aggregatee = ((AssignStmt)stmt).getRightOp())) continue;
            boolean wasSimpleCopy = this.isSimpleCopy(usepair.unit);
            usepair.valueBox.setValue(aggregatee);
            units.remove(stmt);
            hadAggregation = true;
            if (!wasSimpleCopy) continue;
            usepair.unit.addAllTagsOf(stmt);
        }
        return hadAggregation;
    }

    protected boolean isSimpleCopy(Unit u) {
        if (!(u instanceof DefinitionStmt)) {
            return false;
        }
        DefinitionStmt defstmt = (DefinitionStmt)u;
        if (!(defstmt.getRightOp() instanceof Local)) {
            return false;
        }
        return defstmt.getLeftOp() instanceof Local;
    }
}

