/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp.findobject;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.thread.mhp.TargetMethodsFinder;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRunStatementsFinder
extends ForwardFlowAnalysis<Unit, BitSet> {
    Set<Unit> multiRunStatements = new HashSet<Unit>();
    protected Map<Object, Integer> nodeToIndex = new HashMap<Object, Integer>();
    protected int lastIndex = 0;

    public MultiRunStatementsFinder(UnitGraph g, SootMethod sm, Set<SootMethod> multiCalledMethods, CallGraph cg) {
        super(g);
        this.doAnalysis();
        this.findMultiCalledMethodsIntra(multiCalledMethods, cg);
    }

    private void findMultiCalledMethodsIntra(Set<SootMethod> multiCalledMethods, CallGraph callGraph) {
        for (Stmt stmt : this.multiRunStatements) {
            if (!stmt.containsInvokeExpr()) continue;
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            List<SootMethod> targetList = new ArrayList<SootMethod>();
            SootMethod method = invokeExpr.getMethod();
            if (invokeExpr instanceof StaticInvokeExpr) {
                targetList.add(method);
            } else if (invokeExpr instanceof InstanceInvokeExpr && method.isConcrete() && !method.getDeclaringClass().isLibraryClass()) {
                TargetMethodsFinder tmd = new TargetMethodsFinder();
                targetList = tmd.find(stmt, callGraph, true, true);
            }
            if (targetList == null) continue;
            for (SootMethod obj : targetList) {
                if (obj.isNative()) continue;
                multiCalledMethods.add(obj);
            }
        }
    }

    @Override
    protected void merge(BitSet in1, BitSet in2, BitSet out) {
        out.clear();
        out.or(in1);
        out.or(in2);
    }

    @Override
    protected void flowThrough(BitSet in, Unit unit, BitSet out) {
        out.clear();
        out.or(in);
        if (!out.get(this.indexOf(unit))) {
            out.set(this.indexOf(unit));
        } else {
            this.multiRunStatements.add(unit);
        }
    }

    @Override
    protected void copy(BitSet source, BitSet dest) {
        dest.clear();
        dest.or(source);
    }

    @Override
    protected BitSet entryInitialFlow() {
        return new BitSet();
    }

    @Override
    protected BitSet newInitialFlow() {
        return new BitSet();
    }

    public FlowSet getMultiRunStatements() {
        ArraySparseSet res = new ArraySparseSet();
        for (Unit u : this.multiRunStatements) {
            res.add(u);
        }
        return res;
    }

    protected int indexOf(Object o) {
        Integer index = this.nodeToIndex.get(o);
        if (index == null) {
            index = this.lastIndex;
            this.nodeToIndex.put(o, index);
            ++this.lastIndex;
        }
        return index;
    }
}

