/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import soot.Body;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.PointsToAnalysis;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.HashPointsToSet;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.infoflow.ClassInfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.FakeJimpleLocal;
import soot.jimple.toolkits.infoflow.SmartMethodInfoFlowAnalysis;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.thread.ThreadLocalObjectsAnalysis;
import soot.jimple.toolkits.thread.mhp.MhpTester;
import soot.jimple.toolkits.thread.mhp.SynchObliviousMhpAnalysis;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionAwareSideEffectAnalysis;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionDataDependency;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionGroup;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionInterferenceGraph;
import soot.jimple.toolkits.thread.synchronization.DeadlockDetector;
import soot.jimple.toolkits.thread.synchronization.LockAllocationBodyTransformer;
import soot.jimple.toolkits.thread.synchronization.LockableReferenceAnalysis;
import soot.jimple.toolkits.thread.synchronization.NewStaticLock;
import soot.jimple.toolkits.thread.synchronization.SynchronizedRegionFinder;
import soot.jimple.toolkits.thread.synchronization.SynchronizedRegionFlowPair;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.HashMutableEdgeLabelledDirectedGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockAllocator
extends SceneTransformer {
    List<CriticalSection> criticalSections = null;
    CriticalSectionInterferenceGraph interferenceGraph = null;
    DirectedGraph deadlockGraph = null;
    boolean optionOneGlobalLock = false;
    boolean optionStaticLocks = false;
    boolean optionUseLocksets = false;
    boolean optionLeaveOriginalLocks = false;
    boolean optionIncludeEmptyPossibleEdges = false;
    boolean optionAvoidDeadlock = true;
    boolean optionOpenNesting = true;
    boolean optionDoMHP = false;
    boolean optionDoTLO = false;
    boolean optionOnFlyTLO = false;
    boolean optionPrintMhpSummary = true;
    boolean optionPrintGraph = false;
    boolean optionPrintTable = false;
    boolean optionPrintDebug = false;

    public LockAllocator(Singletons.Global g) {
    }

    public static LockAllocator v() {
        return G.v().soot_jimple_toolkits_thread_synchronization_LockAllocator();
    }

    @Override
    protected void internalTransform(String phaseName, Map options) {
        CriticalSectionInterferenceGraph ig;
        String lockingScheme = PhaseOptions.getString(options, "locking-scheme");
        if (lockingScheme.equals("fine-grained")) {
            this.optionOneGlobalLock = false;
            this.optionStaticLocks = false;
            this.optionUseLocksets = true;
            this.optionLeaveOriginalLocks = false;
        }
        if (lockingScheme.equals("medium-grained")) {
            this.optionOneGlobalLock = false;
            this.optionStaticLocks = false;
            this.optionUseLocksets = false;
            this.optionLeaveOriginalLocks = false;
        }
        if (lockingScheme.equals("coarse-grained")) {
            this.optionOneGlobalLock = false;
            this.optionStaticLocks = true;
            this.optionUseLocksets = false;
            this.optionLeaveOriginalLocks = false;
        }
        if (lockingScheme.equals("single-static")) {
            this.optionOneGlobalLock = true;
            this.optionStaticLocks = true;
            this.optionUseLocksets = false;
            this.optionLeaveOriginalLocks = false;
        }
        if (lockingScheme.equals("leave-original")) {
            this.optionOneGlobalLock = false;
            this.optionStaticLocks = false;
            this.optionUseLocksets = false;
            this.optionLeaveOriginalLocks = true;
        }
        this.optionAvoidDeadlock = PhaseOptions.getBoolean(options, "avoid-deadlock");
        this.optionOpenNesting = PhaseOptions.getBoolean(options, "open-nesting");
        this.optionDoMHP = PhaseOptions.getBoolean(options, "do-mhp");
        this.optionDoTLO = PhaseOptions.getBoolean(options, "do-tlo");
        this.optionPrintGraph = PhaseOptions.getBoolean(options, "print-graph");
        this.optionPrintTable = PhaseOptions.getBoolean(options, "print-table");
        this.optionPrintDebug = PhaseOptions.getBoolean(options, "print-debug");
        SynchObliviousMhpAnalysis mhp = null;
        if (this.optionDoMHP && Scene.v().getPointsToAnalysis() instanceof PAG) {
            G.v().out.println("[wjtp.tn] *** Build May-Happen-in-Parallel Info *** " + new Date());
            mhp = new SynchObliviousMhpAnalysis();
            if (this.optionPrintMhpSummary) {
                mhp.printMhpSummary();
            }
        }
        ThreadLocalObjectsAnalysis tlo = null;
        if (this.optionDoTLO) {
            G.v().out.println("[wjtp.tn] *** Find Thread-Local Objects *** " + new Date());
            tlo = mhp != null ? new ThreadLocalObjectsAnalysis(mhp) : new ThreadLocalObjectsAnalysis(new SynchObliviousMhpAnalysis());
            if (!this.optionOnFlyTLO) {
                tlo.precompute();
                G.v().out.println("[wjtp.tn] TLO totals (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
            } else {
                G.v().out.println("[wjtp.tn] TLO so far (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
            }
        }
        Date start = new Date();
        G.v().out.println("[wjtp.tn] *** Find and Name Transactions *** " + start);
        HashMap<SootMethod, FlowSet> methodToFlowSet = new HashMap<SootMethod, FlowSet>();
        HashMap<SootMethod, ExceptionalUnitGraph> methodToExcUnitGraph = new HashMap<SootMethod, ExceptionalUnitGraph>();
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            for (SootMethod method : appClass.getMethods()) {
                if (!method.isConcrete()) continue;
                Body b = method.retrieveActiveBody();
                ExceptionalUnitGraph eug = new ExceptionalUnitGraph(b);
                methodToExcUnitGraph.put(method, eug);
                SynchronizedRegionFinder ta = new SynchronizedRegionFinder(eug, b, this.optionPrintDebug, this.optionOpenNesting, tlo);
                PatchingChain<Unit> units = b.getUnits();
                Unit lastUnit = (Unit)units.getLast();
                FlowSet fs = (FlowSet)ta.getFlowBefore(lastUnit);
                methodToFlowSet.put(method, fs);
            }
        }
        this.criticalSections = new Vector<CriticalSection>();
        for (FlowSet fs : methodToFlowSet.values()) {
            List fList = fs.toList();
            for (int i = 0; i < fList.size(); ++i) {
                this.criticalSections.add(((SynchronizedRegionFlowPair)fList.get((int)i)).tn);
            }
        }
        this.assignNamesToTransactions(this.criticalSections);
        if (this.optionOnFlyTLO) {
            G.v().out.println("[wjtp.tn] TLO so far (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
        }
        G.v().out.println("[wjtp.tn] *** Find Transitive Read/Write Sets *** " + new Date());
        PointsToAnalysis pta = Scene.v().getPointsToAnalysis();
        CriticalSectionAwareSideEffectAnalysis tasea = null;
        tasea = new CriticalSectionAwareSideEffectAnalysis(pta, Scene.v().getCallGraph(), this.optionOpenNesting ? this.criticalSections : null, tlo);
        for (CriticalSection tn : this.criticalSections) {
            for (Unit unit : tn.invokes) {
                RWSet stmtWrite;
                HashSet uses;
                Stmt stmt = (Stmt)unit;
                RWSet stmtRead = tasea.readSet(tn.method, stmt, tn, uses = new HashSet());
                if (stmtRead != null) {
                    tn.read.union(stmtRead);
                }
                if ((stmtWrite = tasea.writeSet(tn.method, stmt, tn, uses)) == null) continue;
                tn.write.union(stmtWrite);
            }
        }
        long longTime = (new Date().getTime() - start.getTime()) / 100L;
        float time = (float)longTime / 10.0f;
        if (this.optionOnFlyTLO) {
            G.v().out.println("[wjtp.tn] TLO totals (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
            G.v().out.println("[wjtp.tn] Time for stages utilizing on-fly TLO: " + time + "s");
        }
        G.v().out.println("[wjtp.tn] *** Calculate Locking Groups *** " + new Date());
        this.interferenceGraph = ig = new CriticalSectionInterferenceGraph(this.criticalSections, mhp, this.optionOneGlobalLock, this.optionLeaveOriginalLocks, this.optionIncludeEmptyPossibleEdges);
        G.v().out.println("[wjtp.tn] *** Detect the Possibility of Deadlock *** " + new Date());
        DeadlockDetector dd = new DeadlockDetector(this.optionPrintDebug, this.optionAvoidDeadlock, true, this.criticalSections);
        if (!this.optionUseLocksets) {
            this.deadlockGraph = dd.detectComponentBasedDeadlock();
        }
        G.v().out.println("[wjtp.tn] *** Calculate Locking Objects *** " + new Date());
        if (!this.optionStaticLocks) {
            for (CriticalSection tn : this.criticalSections) {
                if (tn.setNumber <= 0) continue;
                for (CriticalSectionDataDependency tdd : tn.edges) {
                    tn.group.rwSet.union(tdd.rw);
                }
            }
        }
        HashMap<Value, Integer> lockToLockNum = null;
        ArrayList<PointsToSetInternal> lockPTSets = null;
        if (this.optionLeaveOriginalLocks) {
            this.analyzeExistingLocks(this.criticalSections, ig);
        } else if (this.optionStaticLocks) {
            this.setFlagsForStaticAllocations(ig);
        } else {
            this.setFlagsForDynamicAllocations(ig);
            lockPTSets = new ArrayList<PointsToSetInternal>();
            lockToLockNum = new HashMap<Value, Integer>();
            this.findLockableReferences(this.criticalSections, pta, tasea, lockToLockNum, lockPTSets);
            if (this.optionUseLocksets) {
                for (CriticalSection tn : this.criticalSections) {
                    if (tn.group == null) continue;
                    G.v().out.println("[wjtp.tn] " + tn.name + " lockset: " + LockAllocator.locksetToLockNumString(tn.lockset, lockToLockNum) + (tn.group.useLocksets ? "" : " (placeholder)"));
                }
            }
        }
        if (this.optionUseLocksets) {
            G.v().out.println("[wjtp.tn] *** Detect " + (this.optionAvoidDeadlock ? "and Correct " : "") + "the Possibility of Deadlock for Locksets *** " + new Date());
            this.deadlockGraph = dd.detectLocksetDeadlock(lockToLockNum, lockPTSets);
            if (this.optionPrintDebug) {
                ((HashMutableEdgeLabelledDirectedGraph)this.deadlockGraph).printGraph();
            }
            G.v().out.println("[wjtp.tn] *** Reorder Locksets to Avoid Deadlock *** " + new Date());
            dd.reorderLocksets(lockToLockNum, (HashMutableEdgeLabelledDirectedGraph)this.deadlockGraph);
        }
        G.v().out.println("[wjtp.tn] *** Print Output and Transform Program *** " + new Date());
        if (this.optionPrintGraph) {
            this.printGraph(this.criticalSections, ig, lockToLockNum);
        }
        if (this.optionPrintTable) {
            this.printTable(this.criticalSections, mhp);
            this.printGroups(this.criticalSections, ig);
        }
        if (!this.optionLeaveOriginalLocks) {
            boolean[] insertedGlobalLock = new boolean[ig.groupCount()];
            insertedGlobalLock[0] = false;
            for (int i = 1; i < ig.groupCount(); ++i) {
                CriticalSectionGroup tnGroup = ig.groups().get(i);
                insertedGlobalLock[i] = !this.optionOneGlobalLock && (tnGroup.useDynamicLock || tnGroup.useLocksets);
            }
            for (SootClass appClass : Scene.v().getApplicationClasses()) {
                for (SootMethod method : appClass.getMethods()) {
                    FlowSet fs;
                    if (!method.isConcrete() || (fs = (FlowSet)methodToFlowSet.get(method)) == null) continue;
                    LockAllocationBodyTransformer.v().internalTransform(method.getActiveBody(), fs, ig.groups(), insertedGlobalLock);
                }
            }
        }
    }

    protected void findLockableReferences(List<CriticalSection> AllTransactions, PointsToAnalysis pta, CriticalSectionAwareSideEffectAnalysis tasea, Map<Value, Integer> lockToLockNum, List<PointsToSetInternal> lockPTSets) {
        for (CriticalSection tn : AllTransactions) {
            int group = tn.setNumber - 1;
            if (group < 0 || !tn.group.useDynamicLock && !tn.group.useLocksets) continue;
            G.v().out.println("[wjtp.tn] * " + tn.name + " *");
            LockableReferenceAnalysis la = new LockableReferenceAnalysis(new BriefUnitGraph(tn.method.retrieveActiveBody()));
            tn.lockset = la.getLocksetOf(tasea, tn.group.rwSet, tn);
            if (this.optionUseLocksets) {
                if (tn.lockset == null || tn.lockset.size() <= 0) {
                    tn.group.useLocksets = false;
                    NewStaticLock newStaticLock = new NewStaticLock(tn.method.getDeclaringClass());
                    EquivalentValue newStaticLockEqVal = new EquivalentValue(newStaticLock);
                    for (CriticalSection groupTn : tn.group) {
                        groupTn.lockset = new ArrayList<EquivalentValue>();
                        groupTn.lockset.add(newStaticLockEqVal);
                    }
                    Integer lockNum = new Integer(-lockPTSets.size());
                    G.v().out.println("[wjtp.tn] Lock: num " + lockNum + " type " + newStaticLock.getType() + " obj " + newStaticLock);
                    lockToLockNum.put(newStaticLockEqVal, lockNum);
                    lockToLockNum.put(newStaticLock, lockNum);
                    HashPointsToSet dummyLockPT = new HashPointsToSet(newStaticLock.getType(), (PAG)pta);
                    lockPTSets.add(dummyLockPT);
                    continue;
                }
                for (EquivalentValue lockEqVal : tn.lockset) {
                    Integer lockNum;
                    Local base;
                    Value lock = lockEqVal.getValue();
                    PointsToSetInternal lockPT = lock instanceof Local ? (PointsToSetInternal)pta.reachingObjects((Local)lock) : (lock instanceof StaticFieldRef ? null : (lock instanceof InstanceFieldRef ? ((base = (Local)((InstanceFieldRef)lock).getBase()) instanceof FakeJimpleLocal ? (PointsToSetInternal)pta.reachingObjects(((FakeJimpleLocal)base).getRealLocal(), ((FieldRef)lock).getField()) : (PointsToSetInternal)pta.reachingObjects(base, ((FieldRef)lock).getField())) : (lock instanceof NewStaticLock ? null : null)));
                    if (lockPT != null) {
                        boolean foundLock = false;
                        for (int i = 0; i < lockPTSets.size(); ++i) {
                            PointsToSetInternal otherLockPT = lockPTSets.get(i);
                            if (!lockPT.hasNonEmptyIntersection(otherLockPT)) continue;
                            G.v().out.println("[wjtp.tn] Lock: num " + i + " type " + lock.getType() + " obj " + lock);
                            lockToLockNum.put(lock, new Integer(i));
                            otherLockPT.addAll(lockPT, null);
                            foundLock = true;
                            break;
                        }
                        if (foundLock) continue;
                        G.v().out.println("[wjtp.tn] Lock: num " + lockPTSets.size() + " type " + lock.getType() + " obj " + lock);
                        lockToLockNum.put(lock, new Integer(lockPTSets.size()));
                        HashPointsToSet otherLockPT = new HashPointsToSet(lockPT.getType(), (PAG)pta);
                        lockPTSets.add(otherLockPT);
                        ((PointsToSetInternal)otherLockPT).addAll(lockPT, null);
                        continue;
                    }
                    if (lockToLockNum.get(lockEqVal) != null) {
                        lockNum = lockToLockNum.get(lockEqVal);
                        G.v().out.println("[wjtp.tn] Lock: num " + lockNum + " type " + lock.getType() + " obj " + lock);
                        lockToLockNum.put(lock, lockNum);
                        continue;
                    }
                    lockNum = new Integer(-lockPTSets.size());
                    G.v().out.println("[wjtp.tn] Lock: num " + lockNum + " type " + lock.getType() + " obj " + lock);
                    lockToLockNum.put(lockEqVal, lockNum);
                    lockToLockNum.put(lock, lockNum);
                    HashPointsToSet dummyLockPT = new HashPointsToSet(lock.getType(), (PAG)pta);
                    lockPTSets.add(dummyLockPT);
                }
                continue;
            }
            if (tn.lockset == null || tn.lockset.size() != 1) {
                tn.lockObject = null;
                tn.group.useDynamicLock = false;
                tn.group.lockObject = null;
                continue;
            }
            tn.lockObject = tn.lockset.get(0);
            if (tn.group.lockObject != null && !(tn.lockObject instanceof Ref)) continue;
            tn.group.lockObject = tn.lockObject;
        }
        if (this.optionUseLocksets) {
            for (int i = 0; i < lockPTSets.size(); ++i) {
                PointsToSetInternal pts = lockPTSets.get(i);
                if (pts.size() != 1) continue;
            }
        }
    }

    public void setFlagsForDynamicAllocations(CriticalSectionInterferenceGraph ig) {
        for (int group = 0; group < ig.groupCount() - 1; ++group) {
            CriticalSectionGroup tnGroup = ig.groups().get(group + 1);
            if (this.optionUseLocksets) {
                tnGroup.useLocksets = true;
            } else {
                tnGroup.isDynamicLock = tnGroup.rwSet.getGlobals().size() == 0;
                tnGroup.useDynamicLock = true;
                tnGroup.lockObject = null;
            }
            if (tnGroup.rwSet.size() > 0) continue;
            if (this.optionUseLocksets) {
                tnGroup.useLocksets = false;
                continue;
            }
            tnGroup.isDynamicLock = false;
            tnGroup.useDynamicLock = false;
        }
    }

    public void setFlagsForStaticAllocations(CriticalSectionInterferenceGraph ig) {
        for (int group = 0; group < ig.groupCount() - 1; ++group) {
            CriticalSectionGroup tnGroup = ig.groups().get(group + 1);
            tnGroup.isDynamicLock = false;
            tnGroup.useDynamicLock = false;
            tnGroup.lockObject = null;
        }
    }

    private void analyzeExistingLocks(List<CriticalSection> AllTransactions, CriticalSectionInterferenceGraph ig) {
        this.setFlagsForStaticAllocations(ig);
        for (CriticalSection tn : AllTransactions) {
            List<Unit> rDefs;
            if (tn.setNumber <= 0) continue;
            ExceptionalUnitGraph egraph = new ExceptionalUnitGraph(tn.method.retrieveActiveBody());
            SmartLocalDefs sld = new SmartLocalDefs(egraph, new SimpleLiveLocals(egraph));
            if (tn.origLock == null || !(tn.origLock instanceof Local) || (rDefs = sld.getDefsOfAt((Local)tn.origLock, tn.entermonitor)) == null) continue;
            for (Stmt stmt : rDefs) {
                if (stmt instanceof DefinitionStmt) {
                    Value rightOp = ((DefinitionStmt)stmt).getRightOp();
                    if (rightOp instanceof FieldRef) {
                        if (((FieldRef)rightOp).getField().isStatic()) {
                            tn.group.lockObject = rightOp;
                            continue;
                        }
                        tn.group.isDynamicLock = true;
                        tn.group.useDynamicLock = true;
                        tn.group.lockObject = tn.origLock;
                        continue;
                    }
                    tn.group.isDynamicLock = true;
                    tn.group.useDynamicLock = true;
                    tn.group.lockObject = tn.origLock;
                    continue;
                }
                tn.group.isDynamicLock = true;
                tn.group.useDynamicLock = true;
                tn.group.lockObject = tn.origLock;
            }
        }
    }

    public static String locksetToLockNumString(List<EquivalentValue> lockset, Map<Value, Integer> lockToLockNum) {
        if (lockset == null) {
            return "null";
        }
        String ret = "[";
        boolean first = true;
        for (EquivalentValue lockEqVal : lockset) {
            if (!first) {
                ret = ret + " ";
            }
            first = false;
            ret = ret + lockToLockNum.get(lockEqVal.getValue());
        }
        return ret + "]";
    }

    public void assignNamesToTransactions(List<CriticalSection> AllTransactions) {
        ArrayList<String> methodNamesTemp = new ArrayList<String>();
        for (CriticalSection tn1 : AllTransactions) {
            String mname = tn1.method.getSignature();
            if (methodNamesTemp.contains(mname)) continue;
            methodNamesTemp.add(mname);
        }
        Object[] methodNames = new String[1];
        methodNames = methodNamesTemp.toArray(methodNames);
        Arrays.sort(methodNames);
        int[][] identMatrix = new int[methodNames.length][CriticalSection.nextIDNum - methodNames.length + 2];
        for (int i = 0; i < methodNames.length; ++i) {
            identMatrix[i][0] = 0;
            for (int j = 1; j < CriticalSection.nextIDNum - methodNames.length + 1; ++j) {
                identMatrix[i][j] = 50000;
            }
        }
        for (CriticalSection tn1 : AllTransactions) {
            int methodNum = Arrays.binarySearch(methodNames, tn1.method.getSignature());
            int[] nArray = identMatrix[methodNum];
            nArray[0] = nArray[0] + 1;
            identMatrix[methodNum][identMatrix[methodNum][0]] = tn1.IDNum;
        }
        for (int j = 0; j < methodNames.length; ++j) {
            identMatrix[j][0] = 0;
            Arrays.sort(identMatrix[j]);
        }
        for (CriticalSection tn1 : AllTransactions) {
            int methodNum = Arrays.binarySearch(methodNames, tn1.method.getSignature());
            int tnNum = Arrays.binarySearch(identMatrix[methodNum], tn1.IDNum) - 1;
            tn1.name = "m" + (methodNum < 10 ? "00" : (methodNum < 100 ? "0" : "")) + methodNum + "n" + (tnNum < 10 ? "0" : "") + tnNum;
        }
    }

    public void printGraph(Collection<CriticalSection> AllTransactions, CriticalSectionInterferenceGraph ig, Map<Value, Integer> lockToLockNum) {
        String[] colors = new String[]{"black", "blue", "blueviolet", "chartreuse", "crimson", "darkgoldenrod1", "darkseagreen", "darkslategray", "deeppink", "deepskyblue1", "firebrick1", "forestgreen", "gold", "gray80", "navy", "pink", "red", "sienna", "turquoise1", "yellow"};
        HashMap<Integer, String> lockColors = new HashMap<Integer, String>();
        int colorNum = 0;
        HashSet<CriticalSection> visited = new HashSet<CriticalSection>();
        G.v().out.println("[transaction-graph]" + (this.optionUseLocksets ? "" : " strict") + " graph transactions {");
        for (int group = 0; group < ig.groups().size(); ++group) {
            boolean printedHeading = false;
            for (CriticalSection tn : AllTransactions) {
                if (tn.setNumber != group + 1) continue;
                if (!printedHeading) {
                    if (tn.group.useDynamicLock && tn.group.lockObject != null) {
                        String typeString = "";
                        typeString = tn.group.lockObject.getType() instanceof RefType ? ((RefType)tn.group.lockObject.getType()).getSootClass().getShortName() : tn.group.lockObject.getType().toString();
                        G.v().out.println("[transaction-graph] subgraph cluster_" + (group + 1) + " {\n[transaction-graph] color=blue;\n[transaction-graph] label=\"Lock: a \\n" + typeString + " object\";");
                    } else if (tn.group.useLocksets) {
                        G.v().out.println("[transaction-graph] subgraph cluster_" + (group + 1) + " {\n[transaction-graph] color=blue;\n[transaction-graph] label=\"Locksets\";");
                    } else {
                        String objString = "";
                        if (tn.group.lockObject == null) {
                            objString = "lockObj" + (group + 1);
                        } else if (tn.group.lockObject instanceof FieldRef) {
                            SootField field = ((FieldRef)tn.group.lockObject).getField();
                            objString = field.getDeclaringClass().getShortName() + "." + field.getName();
                        } else {
                            objString = tn.group.lockObject.toString();
                        }
                        G.v().out.println("[transaction-graph] subgraph cluster_" + (group + 1) + " {\n[transaction-graph] color=blue;\n[transaction-graph] label=\"Lock: \\n" + objString + "\";");
                    }
                    printedHeading = true;
                }
                if (Scene.v().getReachableMethods().contains(tn.method)) {
                    G.v().out.println("[transaction-graph] " + tn.name + " [name=\"" + tn.method.toString() + "\" style=\"setlinewidth(3)\"];");
                } else {
                    G.v().out.println("[transaction-graph] " + tn.name + " [name=\"" + tn.method.toString() + "\" color=cadetblue1 style=\"setlinewidth(1)\"];");
                }
                if (tn.group.useLocksets) {
                    for (EquivalentValue lockEqVal : tn.lockset) {
                        Integer lockNum = lockToLockNum.get(lockEqVal.getValue());
                        for (CriticalSection tn2 : tn.group) {
                            if (visited.contains(tn2) || !ig.mayHappenInParallel(tn, tn2)) continue;
                            for (EquivalentValue lock2EqVal : tn2.lockset) {
                                Integer lock2Num = lockToLockNum.get(lock2EqVal.getValue());
                                if (lockNum.intValue() != lock2Num.intValue()) continue;
                                if (!lockColors.containsKey(lockNum)) {
                                    lockColors.put(lockNum, colors[colorNum % colors.length]);
                                    ++colorNum;
                                }
                                String color = (String)lockColors.get(lockNum);
                                G.v().out.println("[transaction-graph] " + tn.name + " -- " + tn2.name + " [color=" + color + " style=" + (lockNum >= 0 ? "dashed" : "solid") + " exactsize=1 style=\"setlinewidth(3)\"];");
                            }
                        }
                        visited.add(tn);
                    }
                    continue;
                }
                for (CriticalSectionDataDependency edge : tn.edges) {
                    CriticalSection tnedge = edge.other;
                    if (tnedge.setNumber != group + 1) continue;
                    G.v().out.println("[transaction-graph] " + tn.name + " -- " + tnedge.name + " [color=" + (edge.size > 0 ? "black" : "cadetblue1") + " style=" + (tn.setNumber > 0 && tn.group.useDynamicLock ? "dashed" : "solid") + " exactsize=" + edge.size + " style=\"setlinewidth(3)\"];");
                }
            }
            if (!printedHeading) continue;
            G.v().out.println("[transaction-graph] }");
        }
        boolean printedHeading = false;
        for (CriticalSection tn : AllTransactions) {
            if (tn.setNumber != -1) continue;
            if (!printedHeading) {
                G.v().out.println("[transaction-graph] subgraph lone {\n[transaction-graph] rank=source;");
                printedHeading = true;
            }
            if (Scene.v().getReachableMethods().contains(tn.method)) {
                G.v().out.println("[transaction-graph] " + tn.name + " [name=\"" + tn.method.toString() + "\" style=\"setlinewidth(3)\"];");
            } else {
                G.v().out.println("[transaction-graph] " + tn.name + " [name=\"" + tn.method.toString() + "\" color=cadetblue1 style=\"setlinewidth(1)\"];");
            }
            for (CriticalSectionDataDependency edge : tn.edges) {
                CriticalSection tnedge = edge.other;
                if (tnedge.setNumber == tn.setNumber && tnedge.setNumber != -1) continue;
                G.v().out.println("[transaction-graph] " + tn.name + " -- " + tnedge.name + " [color=" + (edge.size > 0 ? "black" : "cadetblue1") + " style=" + (tn.setNumber > 0 && tn.group.useDynamicLock ? "dashed" : "solid") + " exactsize=" + edge.size + " style=\"setlinewidth(1)\"];");
            }
        }
        if (printedHeading) {
            G.v().out.println("[transaction-graph] }");
        }
        G.v().out.println("[transaction-graph] }");
    }

    public void printTable(Collection<CriticalSection> AllTransactions, MhpTester mhp) {
        G.v().out.println("[transaction-table] ");
        for (CriticalSection tn : AllTransactions) {
            boolean reachable = false;
            boolean mhpself = false;
            ReachableMethods rm = Scene.v().getReachableMethods();
            reachable = rm.contains(tn.method);
            if (mhp != null) {
                mhpself = mhp.mayHappenInParallel(tn.method, tn.method);
            }
            G.v().out.println("[transaction-table] Transaction " + tn.name + (reachable ? " reachable" : " dead") + (mhpself ? " [called from >= 2 threads]" : " [called from <= 1 thread]"));
            G.v().out.println("[transaction-table] Where: " + tn.method.getDeclaringClass().toString() + ":" + tn.method.toString() + ":  ");
            G.v().out.println("[transaction-table] Orig : " + tn.origLock);
            G.v().out.println("[transaction-table] Prep : " + tn.prepStmt);
            G.v().out.println("[transaction-table] Begin: " + tn.entermonitor);
            G.v().out.print("[transaction-table] End  : early:" + tn.earlyEnds.toString() + " exc:" + tn.exceptionalEnd + " through:" + tn.end + " \n");
            G.v().out.println("[transaction-table] Size : " + tn.units.size());
            if (tn.read.size() < 100) {
                G.v().out.print("[transaction-table] Read : " + tn.read.size() + "\n[transaction-table] " + tn.read.toString().replaceAll("\\[", "     : [").replaceAll("\n", "\n[transaction-table] "));
            } else {
                G.v().out.print("[transaction-table] Read : " + tn.read.size() + "  \n[transaction-table] ");
            }
            if (tn.write.size() < 100) {
                G.v().out.print("Write: " + tn.write.size() + "\n[transaction-table] " + tn.write.toString().replaceAll("\\[", "     : [").replaceAll("\n", "\n[transaction-table] "));
            } else {
                G.v().out.print("Write: " + tn.write.size() + "\n[transaction-table] ");
            }
            G.v().out.print("Edges: (" + tn.edges.size() + ") ");
            Iterator<CriticalSectionDataDependency> tnedgeit = tn.edges.iterator();
            while (tnedgeit.hasNext()) {
                G.v().out.print(tnedgeit.next().other.name + " ");
            }
            if (tn.group != null && tn.group.useLocksets) {
                G.v().out.println("\n[transaction-table] Locks: " + tn.lockset);
            } else {
                G.v().out.println("\n[transaction-table] Lock : " + (tn.setNumber == -1 ? "-" : (tn.lockObject == null ? "Global" : tn.lockObject.toString() + (tn.lockObjectArrayIndex == null ? "" : "[" + tn.lockObjectArrayIndex + "]"))));
            }
            G.v().out.println("[transaction-table] Group: " + tn.setNumber + "\n[transaction-table] ");
        }
    }

    public void printGroups(Collection<CriticalSection> AllTransactions, CriticalSectionInterferenceGraph ig) {
        G.v().out.print("[transaction-groups] Group Summaries\n[transaction-groups] ");
        for (int group = 0; group < ig.groupCount() - 1; ++group) {
            CriticalSectionGroup tnGroup = ig.groups().get(group + 1);
            if (tnGroup.size() <= 0) continue;
            G.v().out.print("Group " + (group + 1) + " ");
            G.v().out.print("Locking: " + (tnGroup.useLocksets ? "using " : (tnGroup.isDynamicLock && tnGroup.useDynamicLock ? "Dynamic on " : "Static on ")) + (tnGroup.useLocksets ? "locksets" : (tnGroup.lockObject == null ? "null" : tnGroup.lockObject.toString())));
            G.v().out.print("\n[transaction-groups]      : ");
            for (CriticalSection tn : AllTransactions) {
                if (tn.setNumber != group + 1) continue;
                G.v().out.print(tn.name + " ");
            }
            G.v().out.print("\n[transaction-groups] " + tnGroup.rwSet.toString().replaceAll("\\[", "     : [").replaceAll("\n", "\n[transaction-groups] "));
        }
        G.v().out.print("Erasing \n[transaction-groups]      : ");
        for (CriticalSection tn : AllTransactions) {
            if (tn.setNumber != -1) continue;
            G.v().out.print(tn.name + " ");
        }
        G.v().out.println("\n[transaction-groups] ");
    }

    public CriticalSectionInterferenceGraph getInterferenceGraph() {
        return this.interferenceGraph;
    }

    public DirectedGraph getDeadlockGraph() {
        return this.deadlockGraph;
    }

    public List<CriticalSection> getCriticalSections() {
        return this.criticalSections;
    }
}

