/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.JimpleBody;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.JNopStmt;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.Union;
import soot.jimple.toolkits.pointer.UnionFactory;
import soot.jimple.toolkits.thread.ThreadLocalObjectsAnalysis;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionAwareSideEffectAnalysis;
import soot.jimple.toolkits.thread.synchronization.SynchronizedRegionFlowPair;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.Pair;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedRegionFinder
extends ForwardFlowAnalysis<Unit, FlowSet> {
    FlowSet emptySet = new ArraySparseSet();
    Map unitToGenerateSet;
    Body body;
    Chain units;
    SootMethod method;
    ExceptionalUnitGraph egraph;
    LocalUses slu;
    CriticalSectionAwareSideEffectAnalysis tasea;
    List<Object> prepUnits;
    CriticalSection methodTn;
    public boolean optionPrintDebug = false;
    public boolean optionOpenNesting = true;

    SynchronizedRegionFinder(UnitGraph graph, Body b, boolean optionPrintDebug, boolean optionOpenNesting, ThreadLocalObjectsAnalysis tlo) {
        super(graph);
        this.optionPrintDebug = optionPrintDebug;
        this.optionOpenNesting = optionOpenNesting;
        this.body = b;
        this.units = b.getUnits();
        this.method = this.body.getMethod();
        this.egraph = graph instanceof ExceptionalUnitGraph ? (ExceptionalUnitGraph)graph : new ExceptionalUnitGraph(b);
        this.slu = new SimpleLocalUses(this.egraph, (LocalDefs)new SmartLocalDefs(this.egraph, new SimpleLiveLocals(this.egraph)));
        if (G.v().Union_factory == null) {
            G.v().Union_factory = new UnionFactory(){

                public Union newUnion() {
                    return FullObjectSet.v();
                }
            };
        }
        this.tasea = new CriticalSectionAwareSideEffectAnalysis(Scene.v().getPointsToAnalysis(), Scene.v().getCallGraph(), null, tlo);
        this.prepUnits = new ArrayList<Object>();
        this.methodTn = null;
        if (this.method.isSynchronized()) {
            this.methodTn = new CriticalSection(true, this.method, 1);
            this.methodTn.beginning = ((JimpleBody)this.body).getFirstNonIdentityStmt();
        }
        this.doAnalysis();
        if (this.method.isSynchronized() && this.methodTn != null) {
            for (Stmt stmt : graph.getTails()) {
                this.methodTn.earlyEnds.add(new Pair<Stmt, Object>(stmt, null));
            }
        }
    }

    @Override
    protected FlowSet newInitialFlow() {
        FlowSet ret = this.emptySet.clone();
        if (this.method.isSynchronized() && this.methodTn != null) {
            ret.add(new SynchronizedRegionFlowPair(this.methodTn, true));
        }
        return ret;
    }

    @Override
    protected FlowSet entryInitialFlow() {
        FlowSet ret = this.emptySet.clone();
        if (this.method.isSynchronized() && this.methodTn != null) {
            ret.add(new SynchronizedRegionFlowPair(this.methodTn, true));
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void flowThrough(FlowSet in, Unit unit, FlowSet out) {
        Stmt stmt = (Stmt)unit;
        this.copy(in, out);
        if (unit instanceof AssignStmt) {
            boolean isPrep = true;
            Iterator uses = this.slu.getUsesOf(unit).iterator();
            if (!uses.hasNext()) {
                isPrep = false;
            }
            while (uses.hasNext()) {
                UnitValueBoxPair use = (UnitValueBoxPair)uses.next();
                Unit useStmt = use.getUnit();
                if (useStmt instanceof EnterMonitorStmt || useStmt instanceof ExitMonitorStmt) continue;
                isPrep = false;
                break;
            }
            if (isPrep) {
                this.prepUnits.add(unit);
                if (this.optionPrintDebug) {
                    G.v().out.println("prep: " + unit.toString());
                }
                return;
            }
        }
        boolean addSelf = unit instanceof EnterMonitorStmt;
        int nestLevel = 0;
        Iterator outIt0 = out.iterator();
        while (outIt0.hasNext()) {
            SynchronizedRegionFlowPair srfp = (SynchronizedRegionFlowPair)outIt0.next();
            if (srfp.tn.nestLevel <= nestLevel || !srfp.inside) continue;
            nestLevel = srfp.tn.nestLevel;
        }
        RWSet stmtRead = null;
        RWSet stmtWrite = null;
        Iterator outIt = out.iterator();
        boolean printed = false;
        while (outIt.hasNext()) {
            SynchronizedRegionFlowPair srfp = (SynchronizedRegionFlowPair)outIt.next();
            CriticalSection tn = srfp.tn;
            if (tn.entermonitor == stmt) {
                srfp.inside = true;
                addSelf = false;
            }
            if (!srfp.inside || tn.nestLevel != nestLevel && this.optionOpenNesting) continue;
            printed = true;
            if (!tn.units.contains(unit)) {
                tn.units.add(unit);
            }
            if (stmt.containsInvokeExpr()) {
                String string = stmt.getInvokeExpr().getMethod().getSubSignature();
                if ((string.equals("void notify()") || string.equals("void notifyAll()")) && tn.nestLevel == nestLevel) {
                    if (!tn.notifys.contains(unit)) {
                        tn.notifys.add(unit);
                    }
                    if (this.optionPrintDebug) {
                        G.v().out.print("{x,x} ");
                    }
                } else if ((string.equals("void wait()") || string.equals("void wait(long)") || string.equals("void wait(long,int)")) && tn.nestLevel == nestLevel) {
                    if (!tn.waits.contains(unit)) {
                        tn.waits.add(unit);
                    }
                    if (this.optionPrintDebug) {
                        G.v().out.print("{x,x} ");
                    }
                }
                if (tn.invokes.contains(unit)) continue;
                tn.invokes.add(unit);
                if (!this.optionPrintDebug) continue;
                stmtRead = this.tasea.readSet(tn.method, stmt, tn, new HashSet());
                stmtWrite = this.tasea.writeSet(tn.method, stmt, tn, new HashSet());
                G.v().out.print("{");
                if (stmtRead != null) {
                    G.v().out.print((stmtRead.getGlobals() != null ? stmtRead.getGlobals().size() : 0) + (stmtRead.getFields() != null ? stmtRead.getFields().size() : 0));
                } else {
                    G.v().out.print("0");
                }
                G.v().out.print(",");
                if (stmtWrite != null) {
                    G.v().out.print((stmtWrite.getGlobals() != null ? stmtWrite.getGlobals().size() : 0) + (stmtWrite.getFields() != null ? stmtWrite.getFields().size() : 0));
                } else {
                    G.v().out.print("0");
                }
                G.v().out.print("} ");
                continue;
            }
            if (unit instanceof ExitMonitorStmt && tn.nestLevel == nestLevel) {
                void var14_18;
                Stmt stmt2;
                srfp.inside = false;
                Stmt stmt3 = stmt;
                while ((stmt2 = (Stmt)this.units.getSuccOf(var14_18)) instanceof JNopStmt) {
                }
                if (stmt2 instanceof ReturnStmt || stmt2 instanceof ReturnVoidStmt || stmt2 instanceof ExitMonitorStmt) {
                    tn.earlyEnds.add(new Pair<Stmt, Stmt>(stmt2, stmt));
                } else if (stmt2 instanceof GotoStmt) {
                    tn.end = new Pair<Stmt, Stmt>(stmt2, stmt);
                    tn.after = (Stmt)((GotoStmt)stmt2).getTarget();
                } else if (stmt2 instanceof ThrowStmt) {
                    tn.exceptionalEnd = new Pair<Stmt, Stmt>(stmt2, stmt);
                } else {
                    throw new RuntimeException("Unknown bytecode pattern: exitmonitor not followed by return, exitmonitor, goto, or throw");
                }
                if (!this.optionPrintDebug) continue;
                G.v().out.print("[0,0] ");
                continue;
            }
            HashSet hashSet = new HashSet();
            stmtRead = this.tasea.readSet(this.method, stmt, tn, hashSet);
            stmtWrite = this.tasea.writeSet(this.method, stmt, tn, hashSet);
            tn.read.union(stmtRead);
            tn.write.union(stmtWrite);
            if (!this.optionPrintDebug) continue;
            G.v().out.print("[");
            if (stmtRead != null) {
                G.v().out.print((stmtRead.getGlobals() != null ? stmtRead.getGlobals().size() : 0) + (stmtRead.getFields() != null ? stmtRead.getFields().size() : 0));
            } else {
                G.v().out.print("0");
            }
            G.v().out.print(",");
            if (stmtWrite != null) {
                G.v().out.print((stmtWrite.getGlobals() != null ? stmtWrite.getGlobals().size() : 0) + (stmtWrite.getFields() != null ? stmtWrite.getFields().size() : 0));
            } else {
                G.v().out.print("0");
            }
            G.v().out.print("] ");
        }
        if (this.optionPrintDebug) {
            if (!printed) {
                G.v().out.print("[0,0] ");
            }
            G.v().out.println(unit.toString());
            if (stmt.containsInvokeExpr() && stmt.getInvokeExpr().getMethod().getDeclaringClass().toString().startsWith("java.") && stmtRead != null && stmtWrite != null && stmtRead.size() < 25 && stmtWrite.size() < 25) {
                G.v().out.println("        Read/Write Set for LibInvoke:");
                G.v().out.println("Read Set:(" + stmtRead.size() + ")" + stmtRead.toString().replaceAll("\n", "\n        "));
                G.v().out.println("Write Set:(" + stmtWrite.size() + ")" + stmtWrite.toString().replaceAll("\n", "\n        "));
            }
        }
        if (addSelf) {
            CriticalSection newTn = new CriticalSection(false, this.method, nestLevel + 1);
            newTn.entermonitor = stmt;
            newTn.beginning = this.units.getSuccOf(stmt);
            if (stmt instanceof EnterMonitorStmt) {
                newTn.origLock = ((EnterMonitorStmt)stmt).getOp();
            }
            if (this.optionPrintDebug) {
                G.v().out.println("Transaction found in method: " + newTn.method.toString());
            }
            out.add(new SynchronizedRegionFlowPair(newTn, true));
            for (Unit unit2 : this.prepUnits) {
                for (UnitValueBoxPair use : this.slu.getUsesOf(unit2)) {
                    if (use.getUnit() != unit) continue;
                    newTn.prepStmt = (Stmt)unit2;
                }
            }
        }
    }

    @Override
    protected void merge(FlowSet inSet1, FlowSet inSet2, FlowSet outSet) {
        inSet1.union(inSet2, outSet);
    }

    @Override
    protected void copy(FlowSet sourceSet, FlowSet destSet) {
        destSet.clear();
        Iterator it = sourceSet.iterator();
        while (it.hasNext()) {
            SynchronizedRegionFlowPair tfp = (SynchronizedRegionFlowPair)it.next();
            destSet.add(tfp.clone());
        }
    }
}

