/*
 * Decompiled with CFR 0.152.
 */
package soot.options;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import soot.HasPhaseOptions;
import soot.Pack;
import soot.PackManager;
import soot.PhaseOptions;

public abstract class OptionsBase {
    private final LinkedList<String> options = new LinkedList();
    protected LinkedList classes = new LinkedList();

    private String pad(int initial, String opts, int tab, String desc) {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < initial; ++i) {
            b.append(" ");
        }
        b.append(opts);
        if (tab <= opts.length()) {
            b.append("\n");
            i = 0;
        } else {
            i = opts.length() + initial;
        }
        while (i <= tab) {
            b.append(" ");
            ++i;
        }
        StringTokenizer t = new StringTokenizer(desc);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (i + s.length() > 78) {
                b.append("\n");
                for (i = 0; i <= tab; ++i) {
                    b.append(" ");
                }
            }
            b.append(s);
            b.append(" ");
            i += s.length() + 1;
        }
        b.append("\n");
        return b.toString();
    }

    protected String padOpt(String opts, String desc) {
        return this.pad(1, opts, 30, desc);
    }

    protected String padVal(String vals, String desc) {
        return this.pad(4, vals, 32, desc);
    }

    protected String getPhaseUsage() {
        StringBuffer b = new StringBuffer();
        b.append("\nPhases and phase options:\n");
        for (Pack p : PackManager.v().allPacks()) {
            b.append(this.padOpt(p.getPhaseName(), p.getDeclaredOptions()));
            Iterator phIt = p.iterator();
            while (phIt.hasNext()) {
                HasPhaseOptions ph = (HasPhaseOptions)phIt.next();
                b.append(this.padVal(ph.getPhaseName(), ph.getDeclaredOptions()));
            }
        }
        return b.toString();
    }

    protected void pushOptions(String s) {
        this.options.addFirst(s);
    }

    protected boolean hasMoreOptions() {
        return !this.options.isEmpty();
    }

    protected String nextOption() {
        return this.options.removeFirst();
    }

    public LinkedList classes() {
        return this.classes;
    }

    public boolean setPhaseOption(String phase, String option) {
        return PhaseOptions.v().processPhaseOptions(phase, option);
    }
}

