/*
 * Decompiled with CFR 0.152.
 */
package soot.rtlib.tamiflex;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import soot.rtlib.tamiflex.SootSig;
import soot.rtlib.tamiflex.UnexpectedReflectiveCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveCalls {
    private static final Set<String> classForName = new HashSet<String>();
    private static final Set<String> classNewInstance = new HashSet<String>();
    private static final Set<String> constructorNewInstance = new HashSet<String>();
    private static final Set<String> methodInvoke = new HashSet<String>();
    private static final Set<String> fieldSet = new HashSet<String>();
    private static final Set<String> fieldGet = new HashSet<String>();

    public static void knownClassForName(int contextId, String className) {
        if (!classForName.contains(contextId + className)) {
            UnexpectedReflectiveCall.classForName(className);
        }
    }

    public static void knownClassNewInstance(int contextId, Class<?> c) {
        if (!classNewInstance.contains(contextId + c.getName())) {
            UnexpectedReflectiveCall.classNewInstance(c);
        }
    }

    public static void knownConstructorNewInstance(int contextId, Constructor<?> c) {
        if (!constructorNewInstance.contains(contextId + SootSig.sootSignature(c))) {
            UnexpectedReflectiveCall.constructorNewInstance(c);
        }
    }

    public static void knownMethodInvoke(int contextId, Object o, Method m) {
        if (!methodInvoke.contains(contextId + SootSig.sootSignature(o, m))) {
            UnexpectedReflectiveCall.methodInvoke(o, m);
        }
    }

    public static void knownFieldSet(int contextId, Object o, Field f) {
        if (!fieldSet.contains(contextId + SootSig.sootSignature(f))) {
            UnexpectedReflectiveCall.fieldSet(o, f);
        }
    }

    public static void knownFieldGet(int contextId, Object o, Field f) {
        if (!fieldGet.contains(contextId + SootSig.sootSignature(f))) {
            UnexpectedReflectiveCall.fieldGet(o, f);
        }
    }
}

