/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import soot.PatchingChain;
import soot.Timers;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.options.Options;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.interaction.FlowInfo;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.BranchedFlowAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ForwardBranchedFlowAnalysis<A>
extends BranchedFlowAnalysis<Unit, A> {
    public ForwardBranchedFlowAnalysis(UnitGraph graph) {
        super(graph);
    }

    @Override
    protected boolean isForward() {
        return true;
    }

    private void accumulateAfterFlowSets(Unit s, A[] flowRepositories, List<Object> previousAfterFlows) {
        int repCount = 0;
        previousAfterFlows.clear();
        if (s.fallsThrough()) {
            this.copy(((ArrayList)this.unitToAfterFallFlow.get(s)).get(0), flowRepositories[repCount]);
            previousAfterFlows.add(flowRepositories[repCount++]);
        }
        if (s.branches()) {
            List l = (List)this.unitToAfterBranchFlow.get(s);
            for (Object fs : l) {
                this.copy(fs, flowRepositories[repCount]);
                previousAfterFlows.add(flowRepositories[repCount++]);
            }
        }
    }

    @Override
    protected void doAnalysis() {
        final HashMap<Unit, Integer> numbers = new HashMap<Unit, Integer>();
        List orderedUnits = new PseudoTopologicalOrderer().newList(this.graph, false);
        int i = 1;
        for (Unit u : orderedUnits) {
            numbers.put(u, new Integer(i));
            ++i;
        }
        TreeSet<Unit> changedUnits = new TreeSet<Unit>(new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer i1 = (Integer)numbers.get(o1);
                Integer i2 = (Integer)numbers.get(o2);
                return i1 - i2;
            }
        });
        HashMap unitToIncomingFlowSets = new HashMap(this.graph.size() * 2 + 1, 0.7f);
        List heads = this.graph.getHeads();
        int numNodes = this.graph.size();
        int numComputations = 0;
        int maxBranchSize = 0;
        for (Unit s : this.graph) {
            unitToIncomingFlowSets.put(s, new ArrayList());
        }
        PatchingChain<Unit> sl = ((UnitGraph)this.graph).getBody().getUnits();
        for (Unit s : this.graph) {
            changedUnits.add(s);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            if (s.fallsThrough()) {
                ArrayList fl = new ArrayList();
                fl.add(this.newInitialFlow());
                this.unitToAfterFallFlow.put(s, fl);
                Unit succ = sl.getSuccOf(s);
                if (succ != null) {
                    List l = (List)unitToIncomingFlowSets.get(sl.getSuccOf(s));
                    l.addAll(fl);
                }
            } else {
                this.unitToAfterFallFlow.put(s, new ArrayList());
            }
            if (s.branches()) {
                ArrayList l = new ArrayList();
                Iterator<UnitBox> boxIt = s.getUnitBoxes().iterator();
                while (boxIt.hasNext()) {
                    Object f = this.newInitialFlow();
                    l.add(f);
                    Unit ss = boxIt.next().getUnit();
                    List incList = (List)unitToIncomingFlowSets.get(ss);
                    incList.add(f);
                }
                this.unitToAfterBranchFlow.put(s, l);
            } else {
                this.unitToAfterBranchFlow.put(s, new ArrayList());
            }
            if (s.getUnitBoxes().size() <= maxBranchSize) continue;
            maxBranchSize = s.getUnitBoxes().size();
        }
        for (Unit s : heads) {
            this.unitToBeforeFlow.put(s, this.entryInitialFlow());
        }
        if (this.treatTrapHandlersAsEntries()) {
            for (Trap trap : ((UnitGraph)this.graph).getBody().getTraps()) {
                Unit handler = trap.getHandlerUnit();
                this.unitToBeforeFlow.put(handler, this.entryInitialFlow());
            }
        }
        ArrayList<Object> previousAfterFlows = new ArrayList<Object>();
        ArrayList<Object> afterFlows = new ArrayList<Object>();
        Object[] flowRepositories = new Object[maxBranchSize + 1];
        for (int i2 = 0; i2 < maxBranchSize + 1; ++i2) {
            flowRepositories[i2] = this.newInitialFlow();
        }
        Object[] previousFlowRepositories = new Object[maxBranchSize + 1];
        for (int i3 = 0; i3 < maxBranchSize + 1; ++i3) {
            previousFlowRepositories[i3] = this.newInitialFlow();
        }
        while (!changedUnits.isEmpty()) {
            FlowInfo fi;
            Unit s = (Unit)changedUnits.first();
            changedUnits.remove(s);
            boolean isHead = heads.contains(s);
            this.accumulateAfterFlowSets(s, previousFlowRepositories, previousAfterFlows);
            List preds = (List)unitToIncomingFlowSets.get(s);
            Object beforeFlow = this.unitToBeforeFlow.get(s);
            if (preds.size() == 1) {
                this.copy(preds.get(0), beforeFlow);
            } else if (preds.size() != 0) {
                Iterator predIt = preds.iterator();
                this.copy(predIt.next(), beforeFlow);
                while (predIt.hasNext()) {
                    Object otherBranchFlow = predIt.next();
                    Object newBeforeFlow = this.newInitialFlow();
                    this.merge(s, beforeFlow, otherBranchFlow, newBeforeFlow);
                    this.copy(newBeforeFlow, beforeFlow);
                }
            }
            if (isHead && preds.size() != 0) {
                this.mergeInto(s, beforeFlow, this.entryInitialFlow());
            }
            ArrayList afterFallFlow = (ArrayList)this.unitToAfterFallFlow.get(s);
            ArrayList afterBranchFlow = (ArrayList)this.unitToAfterBranchFlow.get(s);
            if (Options.v().interactive_mode()) {
                Object savedFlow = this.newInitialFlow();
                this.copy(beforeFlow, savedFlow);
                fi = new FlowInfo(savedFlow, s, true);
                if (InteractionHandler.v().getStopUnitList() != null && InteractionHandler.v().getStopUnitList().contains(s)) {
                    InteractionHandler.v().handleStopAtNodeEvent(s);
                }
                InteractionHandler.v().handleBeforeAnalysisEvent(fi);
            }
            this.flowThrough(beforeFlow, s, afterFallFlow, afterBranchFlow);
            if (Options.v().interactive_mode()) {
                ArrayList l = new ArrayList();
                if (!afterFallFlow.isEmpty()) {
                    l.addAll(afterFallFlow);
                }
                if (!afterBranchFlow.isEmpty()) {
                    l.addAll(afterBranchFlow);
                }
                fi = new FlowInfo(l, s, false);
                InteractionHandler.v().handleAfterAnalysisEvent(fi);
            }
            ++numComputations;
            this.accumulateAfterFlowSets(s, flowRepositories, afterFlows);
            if (((Object)afterFlows).equals(previousAfterFlows)) continue;
            for (Unit succ : this.graph.getSuccsOf(s)) {
                changedUnits.add(succ);
            }
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }
}

