/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import soot.Timers;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.interaction.FlowInfo;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.FlowAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ForwardFlowAnalysis<N, A>
extends FlowAnalysis<N, A> {
    public ForwardFlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
    }

    @Override
    protected boolean isForward() {
        return true;
    }

    @Override
    protected void doAnalysis() {
        HashMap numbers = new HashMap();
        List orderedUnits = this.constructOrderer().newList(this.graph, false);
        int i = 1;
        for (Object u : orderedUnits) {
            numbers.put(u, new Integer(i));
            ++i;
        }
        Collection changedUnits = this.constructWorklist(numbers);
        List heads = this.graph.getHeads();
        int numNodes = this.graph.size();
        int numComputations = 0;
        for (Object s : this.graph) {
            changedUnits.add(s);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            this.unitToAfterFlow.put(s, this.newInitialFlow());
        }
        for (Object s : heads) {
            this.unitToBeforeFlow.put(s, this.entryInitialFlow());
        }
        Object previousAfterFlow = this.newInitialFlow();
        while (!changedUnits.isEmpty()) {
            FlowInfo fi;
            Object s = changedUnits.iterator().next();
            changedUnits.remove(s);
            boolean isHead = heads.contains(s);
            this.copy(this.unitToAfterFlow.get(s), previousAfterFlow);
            List preds = this.graph.getPredsOf(s);
            Object beforeFlow = this.unitToBeforeFlow.get(s);
            if (preds.size() == 1) {
                this.copy(this.unitToAfterFlow.get(preds.get(0)), beforeFlow);
            } else if (preds.size() != 0) {
                Iterator predIt = preds.iterator();
                this.copy(this.unitToAfterFlow.get(predIt.next()), beforeFlow);
                while (predIt.hasNext()) {
                    Object otherBranchFlow = this.unitToAfterFlow.get(predIt.next());
                    this.mergeInto(s, beforeFlow, otherBranchFlow);
                }
            }
            if (isHead && preds.size() != 0) {
                this.mergeInto(s, beforeFlow, this.entryInitialFlow());
            }
            Object afterFlow = this.unitToAfterFlow.get(s);
            if (Options.v().interactive_mode()) {
                Object savedInfo = this.newInitialFlow();
                if (this.filterUnitToBeforeFlow != null) {
                    savedInfo = this.filterUnitToBeforeFlow.get(s);
                    this.copy(this.filterUnitToBeforeFlow.get(s), savedInfo);
                } else {
                    this.copy(beforeFlow, savedInfo);
                }
                fi = new FlowInfo(savedInfo, s, true);
                if (InteractionHandler.v().getStopUnitList() != null && InteractionHandler.v().getStopUnitList().contains(s)) {
                    InteractionHandler.v().handleStopAtNodeEvent(s);
                }
                InteractionHandler.v().handleBeforeAnalysisEvent(fi);
            }
            this.flowThrough(beforeFlow, s, afterFlow);
            if (Options.v().interactive_mode()) {
                Object aSavedInfo = this.newInitialFlow();
                if (this.filterUnitToAfterFlow != null) {
                    aSavedInfo = this.filterUnitToAfterFlow.get(s);
                    this.copy(this.filterUnitToAfterFlow.get(s), aSavedInfo);
                } else {
                    this.copy(afterFlow, aSavedInfo);
                }
                fi = new FlowInfo(aSavedInfo, s, false);
                InteractionHandler.v().handleAfterAnalysisEvent(fi);
            }
            ++numComputations;
            if (afterFlow.equals(previousAfterFlow)) continue;
            for (Object succ : this.graph.getSuccsOf(s)) {
                changedUnits.add(succ);
            }
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }

    protected Collection<N> constructWorklist(final Map<N, Integer> numbers) {
        return new TreeSet(new Comparator<N>(){

            @Override
            public int compare(N o1, N o2) {
                Integer i1 = (Integer)numbers.get(o1);
                Integer i2 = (Integer)numbers.get(o2);
                return i1 - i2;
            }
        });
    }
}

