/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.lang.reflect.Field;
import kilim.Pausable;
import kilim.State;
import kilim.Task;

public final class Fiber {
    public State curState;
    public int pc;
    private State[] stateStack = new State[10];
    private int iStack = -1;
    boolean isPausing;
    boolean isDone;
    public Task task;
    private static final State PAUSE_STATE = new State();
    public static final int NOT_PAUSING__NO_STATE = 0;
    public static final int NOT_PAUSING__HAS_STATE = 1;
    public static final int PAUSING__NO_STATE = 2;
    public static final int PAUSING__HAS_STATE = 3;

    public Fiber(Task t) {
        this.task = t;
    }

    public Task task() {
        return this.task;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public static void pause() throws Pausable {
        throw new IllegalStateException("pause() called without weaving");
    }

    public static void pause(Fiber f) {
        f.togglePause();
    }

    public int up() {
        int d = this.iStack;
        this.iStack = --d;
        if (this.isPausing) {
            return this.stateStack[d] == null ? 2 : 3;
        }
        State[] stack = this.stateStack;
        this.curState = stack[d];
        State cs = this.curState;
        if (cs == null) {
            this.pc = 0;
            return 0;
        }
        stack[d] = null;
        this.pc = cs.pc;
        return 1;
    }

    public final Fiber begin() {
        return this.down();
    }

    public final boolean end() {
        boolean isDone;
        assert (this.iStack == 0) : "Reset: Expected iStack == 0, not " + this.iStack + "\n" + this;
        boolean bl = isDone = !this.isPausing;
        if (isDone) {
            this.stateStack[0] = null;
        }
        this.isPausing = false;
        this.iStack = -1;
        return isDone;
    }

    public Fiber down() {
        int d;
        if ((d = ++this.iStack) >= this.stateStack.length) {
            this.ensureSize(d * 2);
            this.pc = 0;
            this.curState = null;
        } else {
            State s;
            this.curState = s = this.stateStack[d];
            this.pc = s == null ? 0 : s.pc;
        }
        return this;
    }

    static void ds() {
        for (StackTraceElement ste : new Exception().getStackTrace()) {
            String cl = ste.getClassName();
            String meth = ste.getMethodName();
            if (cl.startsWith("kilim.Worker") || meth.equals("go") || meth.equals("ds")) continue;
            String line = ste.getLineNumber() < 0 ? "" : ":" + ste.getLineNumber();
            System.out.println('\t' + cl + '.' + ste.getMethodName() + '(' + ste.getFileName() + line + ')');
        }
    }

    public int upEx() {
        int is = this.task.getStackDepth() - 2;
        State cs = this.stateStack[is];
        for (int i = this.iStack; i >= is; --i) {
            this.stateStack[i] = null;
        }
        this.iStack = is;
        this.curState = cs;
        return cs == null ? 0 : cs.pc;
    }

    public Object getCallee() {
        assert (this.stateStack[this.iStack] != PAUSE_STATE) : "No callee: this state is the pause state";
        assert (this.stateStack[this.iStack] != null) : "Callee is null";
        return this.stateStack[this.iStack + 1].self;
    }

    private State[] ensureSize(int newsize) {
        State[] newStack = new State[newsize];
        System.arraycopy(this.stateStack, 0, newStack, 0, this.stateStack.length);
        this.stateStack = newStack;
        return newStack;
    }

    public void setState(State state) {
        this.stateStack[this.iStack] = state;
        this.isPausing = true;
    }

    public State getState() {
        return this.stateStack[this.iStack];
    }

    void togglePause() {
        if (this.curState == null) {
            this.setState(PAUSE_STATE);
        } else {
            assert (this.curState == PAUSE_STATE) : "togglePause: Expected PAUSE_STATE, instead got: iStack == " + this.iStack + ", state = " + this.curState;
            this.stateStack[this.iStack] = null;
            this.isPausing = false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("iStack = ").append(this.iStack).append(", pc = ").append(this.pc);
        if (this.isPausing) {
            sb.append(" pausing");
        }
        sb.append('\n');
        for (int i = 0; i < this.stateStack.length; ++i) {
            State st = this.stateStack[i];
            if (st == null) continue;
            sb.append(st.getClass().getName()).append('[').append(i).append("]: ");
            Fiber.stateToString(sb, this.stateStack[i]);
        }
        return sb.toString();
    }

    public void wrongPC() {
        throw new IllegalStateException("Wrong pc: " + this.pc);
    }

    private static void stateToString(StringBuilder sb, State s) {
        if (s == PAUSE_STATE) {
            sb.append("PAUSE\n");
            return;
        }
        Field[] fs = s.getClass().getFields();
        for (int i = 0; i < fs.length; ++i) {
            Object v;
            Field f = fs[i];
            sb.append(f.getName()).append(" = ");
            try {
                v = f.get(s);
            }
            catch (IllegalAccessException iae) {
                v = "?";
            }
            sb.append(' ').append(v).append(' ');
        }
        sb.append('\n');
    }

    void clearPausing() {
        this.isPausing = false;
    }

    static {
        Fiber.PAUSE_STATE.pc = 1;
    }
}

