/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.util.concurrent.TimeUnit;
import kilim.Task;
import kilim.WorkerThread;

public class ReentrantLock
extends java.util.concurrent.locks.ReentrantLock {
    private static final long serialVersionUID = 1L;
    Thread locker = null;

    public ReentrantLock() {
        super(false);
    }

    public ReentrantLock(boolean fair) {
        super(fair);
    }

    @Override
    public Thread getOwner() {
        return super.getOwner();
    }

    @Override
    public void lock() {
        Thread t;
        super.lock();
        this.locker = t = Thread.currentThread();
        if (t instanceof WorkerThread) {
            Task tsk = ((WorkerThread)t).getCurrentTask();
            if (t != null) {
                tsk.pinToThread();
            }
        }
    }

    @Override
    public boolean tryLock() {
        boolean ret = super.tryLock();
        Thread t = Thread.currentThread();
        if (ret && t instanceof WorkerThread) {
            this.locker = t;
            Task tsk = ((WorkerThread)t).getCurrentTask();
            if (t != null) {
                tsk.pinToThread();
            }
        }
        return ret;
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        boolean ret = super.tryLock(timeout, unit);
        Thread t = Thread.currentThread();
        if (ret && t instanceof WorkerThread) {
            this.locker = t;
            Task tsk = ((WorkerThread)t).getCurrentTask();
            if (t != null) {
                tsk.pinToThread();
            }
        }
        return ret;
    }

    @Override
    public void unlock() {
        try {
            super.unlock();
        }
        catch (IllegalMonitorStateException ims) {
            System.err.println("Locking thread: " + this.locker + ", unlocking thread: " + Thread.currentThread());
            ims.printStackTrace();
            System.exit(1);
        }
        Thread t = Thread.currentThread();
        if (t instanceof WorkerThread) {
            Task tsk = ((WorkerThread)t).getCurrentTask();
            if (t != null) {
                tsk.unpinFromThread();
            }
        }
    }
}

