/*
 * Decompiled with CFR 0.152.
 */
package kilim;

public class RingQueue<T> {
    protected T[] elements;
    protected int iprod;
    protected int icons;
    protected int maxSize;
    protected int size;

    public RingQueue(int initialSize) {
        this(initialSize, Integer.MAX_VALUE);
    }

    public RingQueue(int initialSize, int maxSize) {
        this.elements = new Object[initialSize];
        this.size = 0;
        this.maxSize = maxSize;
    }

    public int size() {
        return this.size;
    }

    public T get() {
        T elem;
        int n = this.size;
        if (n > 0) {
            T[] elems = this.elements;
            int ic = this.icons;
            elem = elems[ic];
            elems[ic] = null;
            this.icons = (ic + 1) % elems.length;
            this.size = n - 1;
        } else {
            elem = null;
        }
        return elem;
    }

    public boolean put(T elem) {
        boolean ret = true;
        if (elem == null) {
            throw new NullPointerException("Null message supplied to put");
        }
        int ip = this.iprod;
        int ic = this.icons;
        int n = this.size;
        if (n == this.elements.length) {
            assert (ic == ip) : "numElements == elements.length && ic != ip";
            if (n < this.maxSize) {
                Object[] newmsgs = new Object[Math.min(n * 2, this.maxSize)];
                System.arraycopy(this.elements, ic, newmsgs, 0, n - ic);
                if (ic > 0) {
                    System.arraycopy(this.elements, 0, newmsgs, n - ic, ic);
                }
                this.elements = newmsgs;
                ip = n;
                ic = 0;
            } else {
                ret = false;
            }
        }
        if (ret) {
            this.size = n + 1;
            this.elements[ip] = elem;
            this.iprod = (ip + 1) % this.elements.length;
            this.icons = ic;
        }
        return ret;
    }

    public boolean contains(T obj) {
        int i = this.icons;
        T[] elems = this.elements;
        for (int c = 0; c < this.size; ++c) {
            if (obj == elems[i]) {
                return true;
            }
            i = (i + 1) % elems.length;
        }
        return false;
    }

    public void reset() {
        this.iprod = 0;
        this.icons = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = this.icons;
        T[] elems = this.elements;
        for (int c = 0; c < this.size; ++c) {
            sb.append(elems[i]);
            i = (i + 1) % elems.length;
        }
        return sb.toString();
    }
}

