/*
 * Decompiled with CFR 0.152.
 */
package kilim;

import java.util.Iterator;
import java.util.LinkedList;
import kilim.RingQueue;
import kilim.ShutdownException;
import kilim.Task;
import kilim.WorkerThread;

public class Scheduler {
    public static volatile Scheduler defaultScheduler = null;
    public static int defaultNumberThreads;
    public LinkedList<WorkerThread> allThreads = new LinkedList();
    public RingQueue<WorkerThread> waitingThreads = new RingQueue(10);
    protected volatile boolean shutdown = false;
    public RingQueue<Task> runnableTasks = new RingQueue(100);

    protected Scheduler() {
        throw new IllegalStateException("Unexpected use of kilim schedulers");
    }

    public Scheduler(int numThreads) {
        throw new IllegalStateException("Unexpected use of kilim schedulers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWaitingThread(WorkerThread wt) {
        RingQueue<WorkerThread> ringQueue = this.waitingThreads;
        synchronized (ringQueue) {
            this.waitingThreads.put(wt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkerThread getWaitingThread() {
        RingQueue<WorkerThread> ringQueue = this.waitingThreads;
        synchronized (ringQueue) {
            return this.waitingThreads.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task t) {
        WorkerThread wt = null;
        Object object = this;
        synchronized (object) {
            assert (t.running) : "Task " + t + " scheduled even though running is false";
            this.runnableTasks.put(t);
        }
        wt = this.getWaitingThread();
        if (wt != null) {
            object = wt;
            synchronized (object) {
                wt.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        if (defaultScheduler == this) {
            defaultScheduler = null;
        }
        Iterator i$ = this.allThreads.iterator();
        while (i$.hasNext()) {
            WorkerThread wt;
            WorkerThread workerThread = wt = (WorkerThread)i$.next();
            synchronized (workerThread) {
                wt.notify();
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadNextTask(WorkerThread wt) throws ShutdownException {
        while (true) {
            Task t = null;
            WorkerThread prefThread = null;
            Scheduler scheduler = this;
            synchronized (scheduler) {
                if (this.shutdown) {
                    throw new ShutdownException();
                }
                t = this.runnableTasks.get();
                if (t == null) {
                    break;
                }
                prefThread = t.preferredResumeThread;
                if (prefThread == null || prefThread == wt) {
                    wt.addRunnableTask(t);
                    break;
                }
                prefThread.addRunnableTask(t);
                WorkerThread workerThread = prefThread;
                synchronized (workerThread) {
                    prefThread.notify();
                }
            }
        }
    }

    public static synchronized Scheduler getDefaultScheduler() {
        if (defaultScheduler == null) {
            defaultScheduler = new Scheduler(defaultNumberThreads);
        }
        return defaultScheduler;
    }

    public static void setDefaultScheduler(Scheduler s) {
        defaultScheduler = s;
    }

    public void dump() {
        System.out.println(this.runnableTasks);
    }

    static {
        String s = System.getProperty("kilim.Scheduler.numThreads");
        if (s != null) {
            try {
                defaultNumberThreads = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultNumberThreads == 0) {
            defaultNumberThreads = Runtime.getRuntime().availableProcessors();
        }
    }
}

